/* -----------------------------------------------------------------------------
 *
 * (c) The GHC Team, 1998-2009
 *
 * Bytecode definitions.
 *
 * ---------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------
 * Instructions
 *
 * Notes:
 * o CASEFAIL is generated by the compiler whenever it tests an "irrefutable"
 *   pattern which fails.  If we don't see too many of these, we could
 *   optimise out the redundant test.
 * ------------------------------------------------------------------------*/

/* NOTE:

   THIS FILE IS INCLUDED IN HASKELL SOURCES (ghc/compiler/GHC/ByteCode/Asm.hs).
   DO NOT PUT C-SPECIFIC STUFF IN HERE!

   I hope that's clear :-)
*/

#define bci_STKCHECK                    1
#define bci_PUSH_L                      2
#define bci_PUSH_LL                     3
#define bci_PUSH_LLL                    4
#define bci_PUSH8                       5
#define bci_PUSH16                      6
#define bci_PUSH32                      7
#define bci_PUSH8_W                     8
#define bci_PUSH16_W                    9
#define bci_PUSH32_W                    10
#define bci_PUSH_G                      11
#define bci_PUSH_ALTS_P                 13
#define bci_PUSH_ALTS_N                 14
#define bci_PUSH_ALTS_F                 15
#define bci_PUSH_ALTS_D                 16
#define bci_PUSH_ALTS_L                 17
#define bci_PUSH_ALTS_V                 18
#define bci_PUSH_PAD8                   19
#define bci_PUSH_PAD16                  20
#define bci_PUSH_PAD32                  21
#define bci_PUSH_UBX8                   22
#define bci_PUSH_UBX16                  23
#define bci_PUSH_UBX32                  24
#define bci_PUSH_UBX                    25
#define bci_PUSH_APPLY_N                26
#define bci_PUSH_APPLY_F                27
#define bci_PUSH_APPLY_D                28
#define bci_PUSH_APPLY_L                29
#define bci_PUSH_APPLY_V                30
#define bci_PUSH_APPLY_P                31
#define bci_PUSH_APPLY_PP               32
#define bci_PUSH_APPLY_PPP              33
#define bci_PUSH_APPLY_PPPP             34
#define bci_PUSH_APPLY_PPPPP            35
#define bci_PUSH_APPLY_PPPPPP           36
/* #define bci_PUSH_APPLY_PPPPPPP          37 */
#define bci_SLIDE                       38
#define bci_ALLOC_AP                    39
#define bci_ALLOC_AP_NOUPD              40
#define bci_ALLOC_PAP                   41
#define bci_MKAP                        42
#define bci_MKPAP                       43
#define bci_UNPACK                      44
#define bci_PACK                        45
#define bci_TESTLT_I                    46
#define bci_TESTEQ_I                    47
#define bci_TESTLT_F                    48
#define bci_TESTEQ_F                    49
#define bci_TESTLT_D                    50
#define bci_TESTEQ_D                    51
#define bci_TESTLT_P                    52
#define bci_TESTEQ_P                    53
#define bci_CASEFAIL                    54
#define bci_JMP                         55
#define bci_CCALL                       56
#define bci_SWIZZLE                     57
#define bci_ENTER                       58
#define bci_RETURN_P                    60
#define bci_RETURN_N                    61
#define bci_RETURN_F                    62
#define bci_RETURN_D                    63
#define bci_RETURN_L                    64
#define bci_RETURN_V                    65
#define bci_BRK_FUN                     66
#define bci_TESTLT_W                    67
#define bci_TESTEQ_W                    68

#define bci_RETURN_T                    69
#define bci_PUSH_ALTS_T                 70

#define bci_TESTLT_I64                  71
#define bci_TESTEQ_I64                  72
#define bci_TESTLT_I32                  73
#define bci_TESTEQ_I32                  74
#define bci_TESTLT_I16                  75
#define bci_TESTEQ_I16                  76
#define bci_TESTLT_I8                   77
#define bci_TESTEQ_I8                   78
#define bci_TESTLT_W64                  79
#define bci_TESTEQ_W64                  80
#define bci_TESTLT_W32                  81
#define bci_TESTEQ_W32                  82
#define bci_TESTLT_W16                  83
#define bci_TESTEQ_W16                  84
#define bci_TESTLT_W8                   85
#define bci_TESTEQ_W8                   86

#define bci_PRIMCALL                    87

#define bci_BCO_NAME                    88

#define bci_OP_ADD_64                   90
#define bci_OP_SUB_64                   91
#define bci_OP_AND_64                   92
#define bci_OP_XOR_64                   93
#define bci_OP_NOT_64                   94
#define bci_OP_NEG_64                   95
#define bci_OP_MUL_64                   96
#define bci_OP_SHL_64                   97
#define bci_OP_ASR_64                   98
#define bci_OP_LSR_64                   99
#define bci_OP_OR_64                   100

#define bci_OP_NEQ_64                  110
#define bci_OP_EQ_64                   111
#define bci_OP_U_GE_64                 112
#define bci_OP_U_GT_64                 113
#define bci_OP_U_LT_64                 114
#define bci_OP_U_LE_64                 115
#define bci_OP_S_GE_64                 116
#define bci_OP_S_GT_64                 117
#define bci_OP_S_LT_64                 118
#define bci_OP_S_LE_64                 119


#define bci_OP_ADD_32                  130
#define bci_OP_SUB_32                  131
#define bci_OP_AND_32                  132
#define bci_OP_XOR_32                  133
#define bci_OP_NOT_32                  134
#define bci_OP_NEG_32                  135
#define bci_OP_MUL_32                  136
#define bci_OP_SHL_32                  137
#define bci_OP_ASR_32                  138
#define bci_OP_LSR_32                  139
#define bci_OP_OR_32                   140

#define bci_OP_NEQ_32                  150
#define bci_OP_EQ_32                   151
#define bci_OP_U_GE_32                 152
#define bci_OP_U_GT_32                 153
#define bci_OP_U_LT_32                 154
#define bci_OP_U_LE_32                 155
#define bci_OP_S_GE_32                 156
#define bci_OP_S_GT_32                 157
#define bci_OP_S_LT_32                 158
#define bci_OP_S_LE_32                 159


#define bci_OP_ADD_16                  170
#define bci_OP_SUB_16                  171
#define bci_OP_AND_16                  172
#define bci_OP_XOR_16                  173
#define bci_OP_NOT_16                  174
#define bci_OP_NEG_16                  175
#define bci_OP_MUL_16                  176
#define bci_OP_SHL_16                  177
#define bci_OP_ASR_16                  178
#define bci_OP_LSR_16                  179
#define bci_OP_OR_16                   180

#define bci_OP_NEQ_16                  190
#define bci_OP_EQ_16                   191
#define bci_OP_U_GE_16                 192
#define bci_OP_U_GT_16                 193
#define bci_OP_U_LT_16                 194
#define bci_OP_U_LE_16                 195
#define bci_OP_S_GE_16                 196
#define bci_OP_S_GT_16                 197
#define bci_OP_S_LT_16                 198
#define bci_OP_S_LE_16                 199


#define bci_OP_ADD_08                  200
#define bci_OP_SUB_08                  201
#define bci_OP_AND_08                  202
#define bci_OP_XOR_08                  203
#define bci_OP_NOT_08                  204
#define bci_OP_NEG_08                  205
#define bci_OP_MUL_08                  206
#define bci_OP_SHL_08                  207
#define bci_OP_ASR_08                  208
#define bci_OP_LSR_08                  209
#define bci_OP_OR_08                   210

#define bci_OP_NEQ_08                  220
#define bci_OP_EQ_08                   221
#define bci_OP_U_GE_08                 222
#define bci_OP_U_GT_08                 223
#define bci_OP_U_LT_08                 224
#define bci_OP_U_LE_08                 225
#define bci_OP_S_GE_08                 226
#define bci_OP_S_GT_08                 227
#define bci_OP_S_LT_08                 228
#define bci_OP_S_LE_08                 229

#define bci_OP_INDEX_ADDR_08           240
#define bci_OP_INDEX_ADDR_16           241
#define bci_OP_INDEX_ADDR_32           242
#define bci_OP_INDEX_ADDR_64           243

#define bci_BRK_ALTS                   244


/* If you need to go past 255 then you will run into the flags */

/* If you need to go below 0x0100 then you will run into the instructions */
#define bci_FLAG_LARGE_ARGS 0x8000

/* If a BCO definitely requires less than this many words of stack,
   don't include an explicit STKCHECK insn in it.  The interpreter
   will check for this many words of stack before running each BCO,
   rendering an explicit check unnecessary in the majority of
   cases. */
#define INTERP_STACK_CHECK_THRESH 50

/*-------------------------------------------------------------------------*/
