{-# LANGUAGE MagicHash, UnboxedTuples, ExtendedLiterals #-}
import GHC.Int
import GHC.Prim

test :: [Int] -> (Int8X16# -> Int8X16# -> Int8X16#) -> IO ()
test t shuffle = do
  let a = packInt8X16# (# 100#Int8, 101#Int8, 102#Int8, 103#Int8, 104#Int8, 105#Int8, 106#Int8, 107#Int8, 108#Int8, 109#Int8, 110#Int8, 111#Int8, 112#Int8, 113#Int8, 114#Int8, 115#Int8 #)
      b = packInt8X16# (# 116#Int8, 117#Int8, 118#Int8, 119#Int8, 120#Int8, 121#Int8, 122#Int8, 123#Int8, 124#Int8, 125#Int8, 126#Int8, 127#Int8, 28#Int8, 29#Int8, 30#Int8, 31#Int8 #)
      c = shuffle a b
      (# x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15 #) = unpackInt8X16# c
      result = [I8# x0, I8# x1, I8# x2, I8# x3, I8# x4, I8# x5, I8# x6, I8# x7, I8# x8, I8# x9, I8# x10, I8# x11, I8# x12, I8# x13, I8# x14, I8# x15]
      ok = result == map (([100..127] ++ [28, 29, 30, 31]) !!) t
  putStrLn $ show t ++ ": " ++ show result ++ if ok then "" else "...WRONG"
{-# NOINLINE test #-}

test0x :: [Int] -> (Int8X16# -> Int8X16#) -> IO ()
test0x t shuffle = do
  let b = packInt8X16# (# 100#Int8, 101#Int8, 102#Int8, 103#Int8, 104#Int8, 105#Int8, 106#Int8, 107#Int8, 108#Int8, 109#Int8, 110#Int8, 111#Int8, 112#Int8, 113#Int8, 114#Int8, 115#Int8 #)
      c = shuffle b
      (# x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15 #) = unpackInt8X16# c
      result = [I8# x0, I8# x1, I8# x2, I8# x3, I8# x4, I8# x5, I8# x6, I8# x7, I8# x8, I8# x9, I8# x10, I8# x11, I8# x12, I8# x13, I8# x14, I8# x15]
      ok = result == map ((replicate 16 0 ++ [100..115]) !!) t
  putStrLn $ show t ++ ": " ++ show result ++ if ok then "" else "...WRONG"
{-# NOINLINE test0x #-}

testx0 :: [Int] -> (Int8X16# -> Int8X16#) -> IO ()
testx0 t shuffle = do
  let a = packInt8X16# (# 100#Int8, 101#Int8, 102#Int8, 103#Int8, 104#Int8, 105#Int8, 106#Int8, 107#Int8, 108#Int8, 109#Int8, 110#Int8, 111#Int8, 112#Int8, 113#Int8, 114#Int8, 115#Int8 #)
      c = shuffle a
      (# x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15 #) = unpackInt8X16# c
      result = [I8# x0, I8# x1, I8# x2, I8# x3, I8# x4, I8# x5, I8# x6, I8# x7, I8# x8, I8# x9, I8# x10, I8# x11, I8# x12, I8# x13, I8# x14, I8# x15]
      ok = result == map (([100..115] ++ replicate 16 0) !!) t
  putStrLn $ show t ++ ": " ++ show result ++ if ok then "" else "...WRONG"
{-# NOINLINE testx0 #-}

main :: IO ()
main = do
  test [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a b -> shuffleInt8X16# a b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15] $ \a b -> shuffleInt8X16# a b (# 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15# #)
  test [0, 1, 2, 3, 4, 5, 22, 23, 8, 9, 26, 27, 28, 29, 30, 31] $ \a b -> shuffleInt8X16# a b (# 0#, 1#, 2#, 3#, 4#, 5#, 22#, 23#, 8#, 9#, 26#, 27#, 28#, 29#, 30#, 31# #)
  test [0, 1, 2, 3, 20, 21, 22, 23, 24, 25, 26, 27, 12, 13, 14, 15] $ \a b -> shuffleInt8X16# a b (# 0#, 1#, 2#, 3#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 12#, 13#, 14#, 15# #)
  test [0, 1, 18, 19, 20, 21, 6, 7, 24, 25, 10, 11, 12, 13, 30, 31] $ \a b -> shuffleInt8X16# a b (# 0#, 1#, 18#, 19#, 20#, 21#, 6#, 7#, 24#, 25#, 10#, 11#, 12#, 13#, 30#, 31# #)
  test [0, 1, 18, 19, 20, 21, 6, 7, 24, 25, 10, 11, 28, 29, 14, 15] $ \a b -> shuffleInt8X16# a b (# 0#, 1#, 18#, 19#, 20#, 21#, 6#, 7#, 24#, 25#, 10#, 11#, 28#, 29#, 14#, 15# #)
  test [0, 7, 15, 15, 0, 2, 1, 7, 11, 15, 4, 2, 11, 5, 14, 9] $ \a b -> shuffleInt8X16# a b (# 0#, 7#, 15#, 15#, 0#, 2#, 1#, 7#, 11#, 15#, 4#, 2#, 11#, 5#, 14#, 9# #)
  test [0, 12, 1, 14, 10, 4, 3, 14, 6, 7, 7, 9, 6, 5, 12, 15] $ \a b -> shuffleInt8X16# a b (# 0#, 12#, 1#, 14#, 10#, 4#, 3#, 14#, 6#, 7#, 7#, 9#, 6#, 5#, 12#, 15# #)
  test [0, 14, 5, 9, 0, 14, 6, 5, 0, 7, 6, 14, 9, 7, 8, 2] $ \a b -> shuffleInt8X16# a b (# 0#, 14#, 5#, 9#, 0#, 14#, 6#, 5#, 0#, 7#, 6#, 14#, 9#, 7#, 8#, 2# #)
  test [0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23] $ \a b -> shuffleInt8X16# a b (# 0#, 16#, 1#, 17#, 2#, 18#, 3#, 19#, 4#, 20#, 5#, 21#, 6#, 22#, 7#, 23# #)
  test [0, 24, 11, 6, 22, 21, 5, 16, 12, 7, 18, 1, 1, 23, 8, 2] $ \a b -> shuffleInt8X16# a b (# 0#, 24#, 11#, 6#, 22#, 21#, 5#, 16#, 12#, 7#, 18#, 1#, 1#, 23#, 8#, 2# #)
  test [1, 0, 10, 14, 14, 7, 2, 11, 11, 0, 2, 12, 1, 4, 10, 9] $ \a b -> shuffleInt8X16# a b (# 1#, 0#, 10#, 14#, 14#, 7#, 2#, 11#, 11#, 0#, 2#, 12#, 1#, 4#, 10#, 9# #)
  test [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1] $ \a b -> shuffleInt8X16# a b (# 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1# #)
  test [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16] $ \a b -> shuffleInt8X16# a b (# 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16# #)
  test [1, 3, 12, 4, 5, 7, 14, 5, 15, 15, 6, 7, 8, 10, 8, 14] $ \a b -> shuffleInt8X16# a b (# 1#, 3#, 12#, 4#, 5#, 7#, 14#, 5#, 15#, 15#, 6#, 7#, 8#, 10#, 8#, 14# #)
  test [1, 8, 14, 4, 6, 15, 8, 14, 15, 10, 6, 0, 11, 0, 8, 6] $ \a b -> shuffleInt8X16# a b (# 1#, 8#, 14#, 4#, 6#, 15#, 8#, 14#, 15#, 10#, 6#, 0#, 11#, 0#, 8#, 6# #)
  test [1, 12, 7, 12, 8, 12, 0, 12, 12, 0, 2, 5, 14, 3, 4, 4] $ \a b -> shuffleInt8X16# a b (# 1#, 12#, 7#, 12#, 8#, 12#, 0#, 12#, 12#, 0#, 2#, 5#, 14#, 3#, 4#, 4# #)
  test [1, 28, 25, 30, 13, 15, 3, 21, 31, 13, 29, 31, 16, 14, 22, 15] $ \a b -> shuffleInt8X16# a b (# 1#, 28#, 25#, 30#, 13#, 15#, 3#, 21#, 31#, 13#, 29#, 31#, 16#, 14#, 22#, 15# #)
  test [1, 30, 26, 9, 5, 9, 13, 6, 20, 0, 7, 2, 22, 13, 8, 8] $ \a b -> shuffleInt8X16# a b (# 1#, 30#, 26#, 9#, 5#, 9#, 13#, 6#, 20#, 0#, 7#, 2#, 22#, 13#, 8#, 8# #)
  test [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2] $ \a b -> shuffleInt8X16# a b (# 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2# #)
  test [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17] $ \a b -> shuffleInt8X16# a b (# 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17# #)
  test [2, 11, 15, 8, 11, 2, 2, 13, 8, 11, 0, 13, 6, 8, 7, 15] $ \a b -> shuffleInt8X16# a b (# 2#, 11#, 15#, 8#, 11#, 2#, 2#, 13#, 8#, 11#, 0#, 13#, 6#, 8#, 7#, 15# #)
  test [2, 12, 3, 8, 13, 13, 9, 8, 15, 4, 11, 4, 9, 1, 13, 13] $ \a b -> shuffleInt8X16# a b (# 2#, 12#, 3#, 8#, 13#, 13#, 9#, 8#, 15#, 4#, 11#, 4#, 9#, 1#, 13#, 13# #)
  test [2, 14, 6, 13, 4, 9, 10, 12, 13, 12, 11, 15, 1, 3, 12, 12] $ \a b -> shuffleInt8X16# a b (# 2#, 14#, 6#, 13#, 4#, 9#, 10#, 12#, 13#, 12#, 11#, 15#, 1#, 3#, 12#, 12# #)
  test [2, 17, 12, 4, 27, 15, 27, 26, 30, 21, 1, 14, 16, 10, 6, 4] $ \a b -> shuffleInt8X16# a b (# 2#, 17#, 12#, 4#, 27#, 15#, 27#, 26#, 30#, 21#, 1#, 14#, 16#, 10#, 6#, 4# #)
  test [2, 19, 30, 1, 13, 26, 12, 10, 21, 9, 3, 6, 22, 31, 2, 31] $ \a b -> shuffleInt8X16# a b (# 2#, 19#, 30#, 1#, 13#, 26#, 12#, 10#, 21#, 9#, 3#, 6#, 22#, 31#, 2#, 31# #)
  test [3, 1, 5, 9, 13, 5, 2, 4, 0, 9, 1, 9, 13, 3, 15, 5] $ \a b -> shuffleInt8X16# a b (# 3#, 1#, 5#, 9#, 13#, 5#, 2#, 4#, 0#, 9#, 1#, 9#, 13#, 3#, 15#, 5# #)
  test [3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3] $ \a b -> shuffleInt8X16# a b (# 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3# #)
  test [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18] $ \a b -> shuffleInt8X16# a b (# 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18# #)
  test [3, 7, 1, 5, 3, 5, 11, 7, 4, 7, 7, 10, 2, 5, 0, 6] $ \a b -> shuffleInt8X16# a b (# 3#, 7#, 1#, 5#, 3#, 5#, 11#, 7#, 4#, 7#, 7#, 10#, 2#, 5#, 0#, 6# #)
  test [3, 8, 12, 12, 2, 9, 5, 3, 2, 2, 13, 8, 3, 9, 13, 15] $ \a b -> shuffleInt8X16# a b (# 3#, 8#, 12#, 12#, 2#, 9#, 5#, 3#, 2#, 2#, 13#, 8#, 3#, 9#, 13#, 15# #)
  test [3, 13, 2, 15, 10, 14, 13, 11, 7, 9, 10, 4, 1, 11, 6, 14] $ \a b -> shuffleInt8X16# a b (# 3#, 13#, 2#, 15#, 10#, 14#, 13#, 11#, 7#, 9#, 10#, 4#, 1#, 11#, 6#, 14# #)
  test [4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4] $ \a b -> shuffleInt8X16# a b (# 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4# #)
  test [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19] $ \a b -> shuffleInt8X16# a b (# 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19# #)
  test [4, 8, 0, 11, 14, 7, 6, 15, 6, 15, 3, 0, 13, 10, 6, 11] $ \a b -> shuffleInt8X16# a b (# 4#, 8#, 0#, 11#, 14#, 7#, 6#, 15#, 6#, 15#, 3#, 0#, 13#, 10#, 6#, 11# #)
  test [4, 12, 2, 10, 13, 14, 9, 2, 4, 7, 7, 12, 2, 5, 14, 0] $ \a b -> shuffleInt8X16# a b (# 4#, 12#, 2#, 10#, 13#, 14#, 9#, 2#, 4#, 7#, 7#, 12#, 2#, 5#, 14#, 0# #)
  test [4, 15, 0, 4, 12, 0, 10, 10, 0, 15, 3, 1, 3, 12, 13, 6] $ \a b -> shuffleInt8X16# a b (# 4#, 15#, 0#, 4#, 12#, 0#, 10#, 10#, 0#, 15#, 3#, 1#, 3#, 12#, 13#, 6# #)
  test [4, 27, 25, 11, 6, 13, 17, 1, 5, 0, 2, 25, 20, 0, 15, 0] $ \a b -> shuffleInt8X16# a b (# 4#, 27#, 25#, 11#, 6#, 13#, 17#, 1#, 5#, 0#, 2#, 25#, 20#, 0#, 15#, 0# #)
  test [5, 0, 8, 14, 14, 7, 3, 5, 1, 1, 4, 6, 9, 6, 0, 9] $ \a b -> shuffleInt8X16# a b (# 5#, 0#, 8#, 14#, 14#, 7#, 3#, 5#, 1#, 1#, 4#, 6#, 9#, 6#, 0#, 9# #)
  test [5, 2, 7, 13, 2, 9, 2, 2, 6, 9, 8, 9, 11, 9, 0, 12] $ \a b -> shuffleInt8X16# a b (# 5#, 2#, 7#, 13#, 2#, 9#, 2#, 2#, 6#, 9#, 8#, 9#, 11#, 9#, 0#, 12# #)
  test [5, 3, 11, 29, 30, 19, 3, 16, 5, 2, 20, 19, 25, 1, 22, 10] $ \a b -> shuffleInt8X16# a b (# 5#, 3#, 11#, 29#, 30#, 19#, 3#, 16#, 5#, 2#, 20#, 19#, 25#, 1#, 22#, 10# #)
  test [5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5] $ \a b -> shuffleInt8X16# a b (# 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5# #)
  test [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20] $ \a b -> shuffleInt8X16# a b (# 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20# #)
  test [5, 6, 14, 3, 1, 6, 0, 2, 11, 13, 1, 11, 6, 10, 3, 10] $ \a b -> shuffleInt8X16# a b (# 5#, 6#, 14#, 3#, 1#, 6#, 0#, 2#, 11#, 13#, 1#, 11#, 6#, 10#, 3#, 10# #)
  test [5, 10, 10, 15, 8, 11, 7, 14, 3, 15, 13, 2, 6, 6, 4, 4] $ \a b -> shuffleInt8X16# a b (# 5#, 10#, 10#, 15#, 8#, 11#, 7#, 14#, 3#, 15#, 13#, 2#, 6#, 6#, 4#, 4# #)
  test [5, 12, 6, 15, 2, 9, 6, 0, 10, 15, 15, 9, 13, 13, 14, 8] $ \a b -> shuffleInt8X16# a b (# 5#, 12#, 6#, 15#, 2#, 9#, 6#, 0#, 10#, 15#, 15#, 9#, 13#, 13#, 14#, 8# #)
  test [5, 15, 11, 4, 15, 11, 14, 7, 0, 0, 13, 0, 6, 10, 13, 15] $ \a b -> shuffleInt8X16# a b (# 5#, 15#, 11#, 4#, 15#, 11#, 14#, 7#, 0#, 0#, 13#, 0#, 6#, 10#, 13#, 15# #)
  test [5, 21, 19, 3, 21, 22, 25, 10, 7, 6, 31, 24, 23, 1, 20, 28] $ \a b -> shuffleInt8X16# a b (# 5#, 21#, 19#, 3#, 21#, 22#, 25#, 10#, 7#, 6#, 31#, 24#, 23#, 1#, 20#, 28# #)
  test [5, 21, 27, 2, 0, 21, 7, 4, 28, 5, 30, 26, 10, 13, 15, 8] $ \a b -> shuffleInt8X16# a b (# 5#, 21#, 27#, 2#, 0#, 21#, 7#, 4#, 28#, 5#, 30#, 26#, 10#, 13#, 15#, 8# #)
  test [5, 25, 27, 18, 27, 22, 5, 14, 24, 5, 23, 12, 6, 15, 16, 8] $ \a b -> shuffleInt8X16# a b (# 5#, 25#, 27#, 18#, 27#, 22#, 5#, 14#, 24#, 5#, 23#, 12#, 6#, 15#, 16#, 8# #)
  test [6, 3, 13, 5, 1, 3, 15, 10, 6, 9, 1, 4, 3, 2, 2, 14] $ \a b -> shuffleInt8X16# a b (# 6#, 3#, 13#, 5#, 1#, 3#, 15#, 10#, 6#, 9#, 1#, 4#, 3#, 2#, 2#, 14# #)
  test [6, 4, 10, 4, 16, 19, 17, 29, 31, 26, 4, 9, 14, 6, 14, 9] $ \a b -> shuffleInt8X16# a b (# 6#, 4#, 10#, 4#, 16#, 19#, 17#, 29#, 31#, 26#, 4#, 9#, 14#, 6#, 14#, 9# #)
  test [6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6] $ \a b -> shuffleInt8X16# a b (# 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6# #)
  test [6, 6, 11, 3, 13, 0, 10, 5, 14, 9, 6, 4, 2, 14, 5, 0] $ \a b -> shuffleInt8X16# a b (# 6#, 6#, 11#, 3#, 13#, 0#, 10#, 5#, 14#, 9#, 6#, 4#, 2#, 14#, 5#, 0# #)
  test [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21] $ \a b -> shuffleInt8X16# a b (# 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21# #)
  test [6, 13, 3, 0, 18, 16, 13, 15, 18, 29, 26, 28, 7, 26, 12, 9] $ \a b -> shuffleInt8X16# a b (# 6#, 13#, 3#, 0#, 18#, 16#, 13#, 15#, 18#, 29#, 26#, 28#, 7#, 26#, 12#, 9# #)
  test [7, 5, 2, 1, 3, 2, 11, 5, 13, 10, 3, 11, 8, 13, 5, 1] $ \a b -> shuffleInt8X16# a b (# 7#, 5#, 2#, 1#, 3#, 2#, 11#, 5#, 13#, 10#, 3#, 11#, 8#, 13#, 5#, 1# #)
  test [7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7] $ \a b -> shuffleInt8X16# a b (# 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7# #)
  test [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22] $ \a b -> shuffleInt8X16# a b (# 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22# #)
  test [7, 8, 24, 19, 16, 16, 14, 16, 17, 12, 8, 15, 24, 20, 11, 28] $ \a b -> shuffleInt8X16# a b (# 7#, 8#, 24#, 19#, 16#, 16#, 14#, 16#, 17#, 12#, 8#, 15#, 24#, 20#, 11#, 28# #)
  test [8, 2, 15, 6, 15, 14, 14, 4, 13, 10, 0, 10, 1, 7, 2, 14] $ \a b -> shuffleInt8X16# a b (# 8#, 2#, 15#, 6#, 15#, 14#, 14#, 4#, 13#, 10#, 0#, 10#, 1#, 7#, 2#, 14# #)
  test [8, 3, 5, 4, 9, 9, 5, 4, 8, 2, 5, 9, 3, 3, 1, 0] $ \a b -> shuffleInt8X16# a b (# 8#, 3#, 5#, 4#, 9#, 9#, 5#, 4#, 8#, 2#, 5#, 9#, 3#, 3#, 1#, 0# #)
  test [8, 7, 12, 13, 5, 5, 11, 9, 5, 13, 4, 4, 6, 5, 6, 8] $ \a b -> shuffleInt8X16# a b (# 8#, 7#, 12#, 13#, 5#, 5#, 11#, 9#, 5#, 13#, 4#, 4#, 6#, 5#, 6#, 8# #)
  test [8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8] $ \a b -> shuffleInt8X16# a b (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  test [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23] $ \a b -> shuffleInt8X16# a b (# 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23# #)
  test [8, 13, 15, 0, 10, 14, 26, 3, 29, 11, 27, 14, 12, 28, 20, 10] $ \a b -> shuffleInt8X16# a b (# 8#, 13#, 15#, 0#, 10#, 14#, 26#, 3#, 29#, 11#, 27#, 14#, 12#, 28#, 20#, 10# #)
  test [8, 14, 12, 11, 13, 15, 2, 9, 11, 11, 10, 8, 1, 0, 10, 2] $ \a b -> shuffleInt8X16# a b (# 8#, 14#, 12#, 11#, 13#, 15#, 2#, 9#, 11#, 11#, 10#, 8#, 1#, 0#, 10#, 2# #)
  test [8, 22, 25, 30, 19, 12, 30, 0, 25, 6, 29, 6, 10, 6, 31, 25] $ \a b -> shuffleInt8X16# a b (# 8#, 22#, 25#, 30#, 19#, 12#, 30#, 0#, 25#, 6#, 29#, 6#, 10#, 6#, 31#, 25# #)
  test [8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31] $ \a b -> shuffleInt8X16# a b (# 8#, 24#, 9#, 25#, 10#, 26#, 11#, 27#, 12#, 28#, 13#, 29#, 14#, 30#, 15#, 31# #)
  test [9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9] $ \a b -> shuffleInt8X16# a b (# 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9# #)
  test [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24] $ \a b -> shuffleInt8X16# a b (# 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24# #)
  test [9, 13, 6, 12, 9, 1, 15, 11, 8, 12, 15, 13, 15, 6, 1, 10] $ \a b -> shuffleInt8X16# a b (# 9#, 13#, 6#, 12#, 9#, 1#, 15#, 11#, 8#, 12#, 15#, 13#, 15#, 6#, 1#, 10# #)
  test [10, 2, 7, 25, 10, 25, 29, 11, 17, 5, 10, 27, 22, 9, 27, 6] $ \a b -> shuffleInt8X16# a b (# 10#, 2#, 7#, 25#, 10#, 25#, 29#, 11#, 17#, 5#, 10#, 27#, 22#, 9#, 27#, 6# #)
  test [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10] $ \a b -> shuffleInt8X16# a b (# 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10# #)
  test [10, 10, 11, 8, 0, 13, 4, 11, 14, 5, 6, 11, 12, 7, 10, 4] $ \a b -> shuffleInt8X16# a b (# 10#, 10#, 11#, 8#, 0#, 13#, 4#, 11#, 14#, 5#, 6#, 11#, 12#, 7#, 10#, 4# #)
  test [10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25] $ \a b -> shuffleInt8X16# a b (# 10#, 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25# #)
  test [11, 4, 1, 6, 13, 5, 5, 7, 7, 2, 11, 1, 13, 6, 9, 12] $ \a b -> shuffleInt8X16# a b (# 11#, 4#, 1#, 6#, 13#, 5#, 5#, 7#, 7#, 2#, 11#, 1#, 13#, 6#, 9#, 12# #)
  test [11, 4, 7, 0, 6, 6, 5, 13, 10, 8, 15, 8, 3, 4, 5, 14] $ \a b -> shuffleInt8X16# a b (# 11#, 4#, 7#, 0#, 6#, 6#, 5#, 13#, 10#, 8#, 15#, 8#, 3#, 4#, 5#, 14# #)
  test [11, 5, 30, 5, 8, 24, 27, 16, 29, 12, 14, 3, 7, 5, 26, 6] $ \a b -> shuffleInt8X16# a b (# 11#, 5#, 30#, 5#, 8#, 24#, 27#, 16#, 29#, 12#, 14#, 3#, 7#, 5#, 26#, 6# #)
  test [11, 6, 1, 12, 1, 11, 12, 10, 12, 15, 3, 15, 6, 3, 8, 2] $ \a b -> shuffleInt8X16# a b (# 11#, 6#, 1#, 12#, 1#, 11#, 12#, 10#, 12#, 15#, 3#, 15#, 6#, 3#, 8#, 2# #)
  test [11, 7, 4, 9, 13, 12, 2, 13, 12, 14, 12, 11, 7, 9, 2, 0] $ \a b -> shuffleInt8X16# a b (# 11#, 7#, 4#, 9#, 13#, 12#, 2#, 13#, 12#, 14#, 12#, 11#, 7#, 9#, 2#, 0# #)
  test [11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11] $ \a b -> shuffleInt8X16# a b (# 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11# #)
  test [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26] $ \a b -> shuffleInt8X16# a b (# 11#, 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26# #)
  test [11, 14, 6, 11, 1, 30, 21, 26, 29, 12, 24, 16, 26, 29, 2, 31] $ \a b -> shuffleInt8X16# a b (# 11#, 14#, 6#, 11#, 1#, 30#, 21#, 26#, 29#, 12#, 24#, 16#, 26#, 29#, 2#, 31# #)
  test [11, 14, 10, 8, 13, 8, 11, 11, 10, 5, 13, 3, 9, 10, 10, 11] $ \a b -> shuffleInt8X16# a b (# 11#, 14#, 10#, 8#, 13#, 8#, 11#, 11#, 10#, 5#, 13#, 3#, 9#, 10#, 10#, 11# #)
  test [12, 1, 0, 9, 6, 1, 14, 12, 8, 12, 13, 11, 4, 8, 5, 15] $ \a b -> shuffleInt8X16# a b (# 12#, 1#, 0#, 9#, 6#, 1#, 14#, 12#, 8#, 12#, 13#, 11#, 4#, 8#, 5#, 15# #)
  test [12, 3, 14, 11, 10, 10, 2, 1, 0, 13, 4, 10, 15, 2, 12, 9] $ \a b -> shuffleInt8X16# a b (# 12#, 3#, 14#, 11#, 10#, 10#, 2#, 1#, 0#, 13#, 4#, 10#, 15#, 2#, 12#, 9# #)
  test [12, 7, 15, 15, 6, 11, 3, 10, 8, 6, 3, 14, 14, 15, 13, 11] $ \a b -> shuffleInt8X16# a b (# 12#, 7#, 15#, 15#, 6#, 11#, 3#, 10#, 8#, 6#, 3#, 14#, 14#, 15#, 13#, 11# #)
  test [12, 12, 3, 3, 0, 13, 14, 9, 10, 4, 13, 10, 11, 15, 5, 9] $ \a b -> shuffleInt8X16# a b (# 12#, 12#, 3#, 3#, 0#, 13#, 14#, 9#, 10#, 4#, 13#, 10#, 11#, 15#, 5#, 9# #)
  test [12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12] $ \a b -> shuffleInt8X16# a b (# 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12# #)
  test [12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27] $ \a b -> shuffleInt8X16# a b (# 12#, 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27# #)
  test [12, 15, 15, 15, 15, 11, 1, 4, 13, 0, 10, 0, 2, 11, 15, 13] $ \a b -> shuffleInt8X16# a b (# 12#, 15#, 15#, 15#, 15#, 11#, 1#, 4#, 13#, 0#, 10#, 0#, 2#, 11#, 15#, 13# #)
  test [13, 9, 3, 30, 12, 24, 8, 23, 24, 15, 17, 27, 16, 3, 26, 3] $ \a b -> shuffleInt8X16# a b (# 13#, 9#, 3#, 30#, 12#, 24#, 8#, 23#, 24#, 15#, 17#, 27#, 16#, 3#, 26#, 3# #)
  test [13, 9, 15, 17, 16, 19, 19, 21, 12, 11, 25, 11, 28, 6, 5, 20] $ \a b -> shuffleInt8X16# a b (# 13#, 9#, 15#, 17#, 16#, 19#, 19#, 21#, 12#, 11#, 25#, 11#, 28#, 6#, 5#, 20# #)
  test [13, 10, 5, 10, 8, 3, 11, 4, 5, 0, 14, 5, 12, 7, 1, 9] $ \a b -> shuffleInt8X16# a b (# 13#, 10#, 5#, 10#, 8#, 3#, 11#, 4#, 5#, 0#, 14#, 5#, 12#, 7#, 1#, 9# #)
  test [13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13] $ \a b -> shuffleInt8X16# a b (# 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13# #)
  test [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28] $ \a b -> shuffleInt8X16# a b (# 13#, 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28# #)
  test [14, 7, 2, 0, 1, 7, 5, 13, 1, 13, 15, 10, 0, 3, 2, 5] $ \a b -> shuffleInt8X16# a b (# 14#, 7#, 2#, 0#, 1#, 7#, 5#, 13#, 1#, 13#, 15#, 10#, 0#, 3#, 2#, 5# #)
  test [14, 9, 20, 10, 29, 28, 19, 17, 18, 1, 13, 13, 7, 3, 7, 15] $ \a b -> shuffleInt8X16# a b (# 14#, 9#, 20#, 10#, 29#, 28#, 19#, 17#, 18#, 1#, 13#, 13#, 7#, 3#, 7#, 15# #)
  test [14, 11, 1, 3, 9, 15, 7, 15, 7, 0, 1, 1, 1, 12, 11, 5] $ \a b -> shuffleInt8X16# a b (# 14#, 11#, 1#, 3#, 9#, 15#, 7#, 15#, 7#, 0#, 1#, 1#, 1#, 12#, 11#, 5# #)
  test [14, 14, 13, 7, 9, 5, 9, 1, 10, 9, 8, 1, 2, 10, 3, 15] $ \a b -> shuffleInt8X16# a b (# 14#, 14#, 13#, 7#, 9#, 5#, 9#, 1#, 10#, 9#, 8#, 1#, 2#, 10#, 3#, 15# #)
  test [14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14] $ \a b -> shuffleInt8X16# a b (# 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14# #)
  test [14, 14, 15, 8, 12, 10, 21, 26, 31, 25, 20, 20, 11, 7, 0, 24] $ \a b -> shuffleInt8X16# a b (# 14#, 14#, 15#, 8#, 12#, 10#, 21#, 26#, 31#, 25#, 20#, 20#, 11#, 7#, 0#, 24# #)
  test [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29] $ \a b -> shuffleInt8X16# a b (# 14#, 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29# #)
  test [14, 27, 23, 13, 9, 23, 1, 5, 16, 7, 31, 9, 16, 26, 30, 11] $ \a b -> shuffleInt8X16# a b (# 14#, 27#, 23#, 13#, 9#, 23#, 1#, 5#, 16#, 7#, 31#, 9#, 16#, 26#, 30#, 11# #)
  test [15, 4, 6, 12, 6, 18, 29, 24, 10, 4, 3, 8, 9, 8, 20, 4] $ \a b -> shuffleInt8X16# a b (# 15#, 4#, 6#, 12#, 6#, 18#, 29#, 24#, 10#, 4#, 3#, 8#, 9#, 8#, 20#, 4# #)
  test [15, 6, 4, 10, 11, 1, 15, 15, 8, 14, 14, 5, 4, 5, 8, 2] $ \a b -> shuffleInt8X16# a b (# 15#, 6#, 4#, 10#, 11#, 1#, 15#, 15#, 8#, 14#, 14#, 5#, 4#, 5#, 8#, 2# #)
  test [15, 10, 9, 7, 11, 1, 11, 15, 3, 3, 13, 10, 12, 8, 14, 2] $ \a b -> shuffleInt8X16# a b (# 15#, 10#, 9#, 7#, 11#, 1#, 11#, 15#, 3#, 3#, 13#, 10#, 12#, 8#, 14#, 2# #)
  test [15, 11, 8, 3, 13, 8, 12, 11, 4, 13, 15, 10, 1, 3, 11, 1] $ \a b -> shuffleInt8X16# a b (# 15#, 11#, 8#, 3#, 13#, 8#, 12#, 11#, 4#, 13#, 15#, 10#, 1#, 3#, 11#, 1# #)
  test [15, 12, 1, 1, 11, 3, 6, 15, 1, 6, 5, 8, 10, 4, 15, 1] $ \a b -> shuffleInt8X16# a b (# 15#, 12#, 1#, 1#, 11#, 3#, 6#, 15#, 1#, 6#, 5#, 8#, 10#, 4#, 15#, 1# #)
  test [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0] $ \a b -> shuffleInt8X16# a b (# 15#, 14#, 13#, 12#, 11#, 10#, 9#, 8#, 7#, 6#, 5#, 4#, 3#, 2#, 1#, 0# #)
  test [15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15] $ \a b -> shuffleInt8X16# a b (# 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15# #)
  test [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30] $ \a b -> shuffleInt8X16# a b (# 15#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30# #)
  test [15, 24, 4, 15, 4, 18, 27, 29, 10, 24, 6, 12, 28, 20, 12, 18] $ \a b -> shuffleInt8X16# a b (# 15#, 24#, 4#, 15#, 4#, 18#, 27#, 29#, 10#, 24#, 6#, 12#, 28#, 20#, 12#, 18# #)
  test [16, 0, 17, 1, 18, 2, 19, 3, 20, 4, 21, 5, 22, 6, 23, 7] $ \a b -> shuffleInt8X16# a b (# 16#, 0#, 17#, 1#, 18#, 2#, 19#, 3#, 20#, 4#, 21#, 5#, 22#, 6#, 23#, 7# #)
  test [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a b -> shuffleInt8X16# a b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test [16, 17, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 28, 29, 30, 31] $ \a b -> shuffleInt8X16# a b (# 16#, 17#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 28#, 29#, 30#, 31# #)
  test [16, 17, 2, 3, 20, 21, 22, 23, 24, 25, 10, 11, 12, 13, 30, 31] $ \a b -> shuffleInt8X16# a b (# 16#, 17#, 2#, 3#, 20#, 21#, 22#, 23#, 24#, 25#, 10#, 11#, 12#, 13#, 30#, 31# #)
  test [16, 17, 18, 19, 4, 5, 6, 7, 24, 25, 10, 11, 28, 29, 14, 15] $ \a b -> shuffleInt8X16# a b (# 16#, 17#, 18#, 19#, 4#, 5#, 6#, 7#, 24#, 25#, 10#, 11#, 28#, 29#, 14#, 15# #)
  test [16, 17, 18, 19, 4, 5, 22, 23, 24, 25, 10, 11, 12, 13, 14, 15] $ \a b -> shuffleInt8X16# a b (# 16#, 17#, 18#, 19#, 4#, 5#, 22#, 23#, 24#, 25#, 10#, 11#, 12#, 13#, 14#, 15# #)
  test [16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 28, 29, 14, 15] $ \a b -> shuffleInt8X16# a b (# 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 8#, 9#, 10#, 11#, 28#, 29#, 14#, 15# #)
  test [16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31] $ \a b -> shuffleInt8X16# a b (# 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31# #)
  test [16, 22, 19, 21, 22, 17, 20, 30, 31, 19, 22, 18, 23, 22, 24, 27] $ \a b -> shuffleInt8X16# a b (# 16#, 22#, 19#, 21#, 22#, 17#, 20#, 30#, 31#, 19#, 22#, 18#, 23#, 22#, 24#, 27# #)
  test [16, 22, 28, 21, 26, 19, 16, 28, 16, 23, 23, 16, 25, 18, 31, 20] $ \a b -> shuffleInt8X16# a b (# 16#, 22#, 28#, 21#, 26#, 19#, 16#, 28#, 16#, 23#, 23#, 16#, 25#, 18#, 31#, 20# #)
  test [16, 29, 17, 29, 16, 25, 22, 22, 30, 20, 23, 28, 17, 17, 25, 19] $ \a b -> shuffleInt8X16# a b (# 16#, 29#, 17#, 29#, 16#, 25#, 22#, 22#, 30#, 20#, 23#, 28#, 17#, 17#, 25#, 19# #)
  test [17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17] $ \a b -> shuffleInt8X16# a b (# 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17#, 17# #)
  test [17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0] $ \a b -> shuffleInt8X16# a b (# 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0# #)
  test [17, 20, 16, 18, 21, 30, 17, 17, 17, 22, 18, 17, 23, 30, 22, 31] $ \a b -> shuffleInt8X16# a b (# 17#, 20#, 16#, 18#, 21#, 30#, 17#, 17#, 17#, 22#, 18#, 17#, 23#, 30#, 22#, 31# #)
  test [17, 23, 21, 21, 25, 18, 22, 31, 18, 26, 29, 22, 31, 27, 24, 24] $ \a b -> shuffleInt8X16# a b (# 17#, 23#, 21#, 21#, 25#, 18#, 22#, 31#, 18#, 26#, 29#, 22#, 31#, 27#, 24#, 24# #)
  test [18, 17, 21, 19, 30, 30, 21, 16, 30, 26, 31, 29, 17, 16, 22, 26] $ \a b -> shuffleInt8X16# a b (# 18#, 17#, 21#, 19#, 30#, 30#, 21#, 16#, 30#, 26#, 31#, 29#, 17#, 16#, 22#, 26# #)
  test [18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18] $ \a b -> shuffleInt8X16# a b (# 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18#, 18# #)
  test [18, 18, 23, 26, 27, 23, 25, 20, 24, 22, 31, 25, 31, 27, 27, 20] $ \a b -> shuffleInt8X16# a b (# 18#, 18#, 23#, 26#, 27#, 23#, 25#, 20#, 24#, 22#, 31#, 25#, 31#, 27#, 27#, 20# #)
  test [18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1] $ \a b -> shuffleInt8X16# a b (# 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1# #)
  test [18, 23, 27, 23, 26, 26, 29, 29, 30, 25, 17, 29, 16, 29, 21, 22] $ \a b -> shuffleInt8X16# a b (# 18#, 23#, 27#, 23#, 26#, 26#, 29#, 29#, 30#, 25#, 17#, 29#, 16#, 29#, 21#, 22# #)
  test [18, 24, 31, 19, 17, 31, 23, 16, 28, 22, 26, 22, 25, 16, 24, 26] $ \a b -> shuffleInt8X16# a b (# 18#, 24#, 31#, 19#, 17#, 31#, 23#, 16#, 28#, 22#, 26#, 22#, 25#, 16#, 24#, 26# #)
  test [18, 26, 23, 29, 28, 27, 20, 16, 26, 21, 18, 17, 31, 17, 23, 24] $ \a b -> shuffleInt8X16# a b (# 18#, 26#, 23#, 29#, 28#, 27#, 20#, 16#, 26#, 21#, 18#, 17#, 31#, 17#, 23#, 24# #)
  test [19, 17, 31, 27, 30, 16, 26, 29, 27, 28, 17, 22, 31, 17, 18, 21] $ \a b -> shuffleInt8X16# a b (# 19#, 17#, 31#, 27#, 30#, 16#, 26#, 29#, 27#, 28#, 17#, 22#, 31#, 17#, 18#, 21# #)
  test [19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19] $ \a b -> shuffleInt8X16# a b (# 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19#, 19# #)
  test [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2] $ \a b -> shuffleInt8X16# a b (# 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2# #)
  test [19, 21, 17, 2, 24, 7, 12, 18, 27, 29, 27, 16, 21, 16, 4, 7] $ \a b -> shuffleInt8X16# a b (# 19#, 21#, 17#, 2#, 24#, 7#, 12#, 18#, 27#, 29#, 27#, 16#, 21#, 16#, 4#, 7# #)
  test [19, 28, 26, 28, 27, 27, 29, 31, 16, 28, 24, 21, 30, 16, 24, 31] $ \a b -> shuffleInt8X16# a b (# 19#, 28#, 26#, 28#, 27#, 27#, 29#, 31#, 16#, 28#, 24#, 21#, 30#, 16#, 24#, 31# #)
  test [19, 31, 28, 20, 25, 19, 18, 18, 19, 29, 31, 31, 24, 17, 22, 28] $ \a b -> shuffleInt8X16# a b (# 19#, 31#, 28#, 20#, 25#, 19#, 18#, 18#, 19#, 29#, 31#, 31#, 24#, 17#, 22#, 28# #)
  test [20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20] $ \a b -> shuffleInt8X16# a b (# 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20#, 20# #)
  test [20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3] $ \a b -> shuffleInt8X16# a b (# 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3# #)
  test [20, 30, 16, 23, 18, 29, 21, 16, 28, 18, 19, 21, 18, 18, 17, 20] $ \a b -> shuffleInt8X16# a b (# 20#, 30#, 16#, 23#, 18#, 29#, 21#, 16#, 28#, 18#, 19#, 21#, 18#, 18#, 17#, 20# #)
  test [20, 31, 17, 28, 31, 30, 25, 22, 23, 18, 30, 20, 26, 31, 29, 29] $ \a b -> shuffleInt8X16# a b (# 20#, 31#, 17#, 28#, 31#, 30#, 25#, 22#, 23#, 18#, 30#, 20#, 26#, 31#, 29#, 29# #)
  test [21, 6, 19, 16, 14, 21, 5, 29, 28, 31, 10, 0, 12, 8, 3, 12] $ \a b -> shuffleInt8X16# a b (# 21#, 6#, 19#, 16#, 14#, 21#, 5#, 29#, 28#, 31#, 10#, 0#, 12#, 8#, 3#, 12# #)
  test [21, 17, 24, 21, 28, 20, 31, 18, 26, 21, 20, 17, 23, 21, 16, 29] $ \a b -> shuffleInt8X16# a b (# 21#, 17#, 24#, 21#, 28#, 20#, 31#, 18#, 26#, 21#, 20#, 17#, 23#, 21#, 16#, 29# #)
  test [21, 18, 29, 16, 19, 20, 28, 29, 20, 21, 28, 29, 21, 20, 29, 30] $ \a b -> shuffleInt8X16# a b (# 21#, 18#, 29#, 16#, 19#, 20#, 28#, 29#, 20#, 21#, 28#, 29#, 21#, 20#, 29#, 30# #)
  test [21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21] $ \a b -> shuffleInt8X16# a b (# 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21#, 21# #)
  test [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4] $ \a b -> shuffleInt8X16# a b (# 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4# #)
  test [21, 24, 27, 20, 17, 31, 31, 12, 21, 4, 22, 3, 4, 21, 14, 3] $ \a b -> shuffleInt8X16# a b (# 21#, 24#, 27#, 20#, 17#, 31#, 31#, 12#, 21#, 4#, 22#, 3#, 4#, 21#, 14#, 3# #)
  test [21, 28, 28, 18, 4, 12, 13, 25, 20, 26, 22, 24, 28, 11, 28, 10] $ \a b -> shuffleInt8X16# a b (# 21#, 28#, 28#, 18#, 4#, 12#, 13#, 25#, 20#, 26#, 22#, 24#, 28#, 11#, 28#, 10# #)
  test [22, 0, 27, 14, 5, 24, 7, 16, 19, 19, 11, 20, 24, 11, 31, 28] $ \a b -> shuffleInt8X16# a b (# 22#, 0#, 27#, 14#, 5#, 24#, 7#, 16#, 19#, 19#, 11#, 20#, 24#, 11#, 31#, 28# #)
  test [22, 5, 22, 23, 28, 12, 9, 12, 15, 19, 8, 29, 20, 11, 3, 9] $ \a b -> shuffleInt8X16# a b (# 22#, 5#, 22#, 23#, 28#, 12#, 9#, 12#, 15#, 19#, 8#, 29#, 20#, 11#, 3#, 9# #)
  test [22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22] $ \a b -> shuffleInt8X16# a b (# 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22#, 22# #)
  test [22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5] $ \a b -> shuffleInt8X16# a b (# 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5# #)
  test [22, 24, 28, 28, 27, 26, 26, 28, 20, 17, 28, 26, 28, 26, 28, 16] $ \a b -> shuffleInt8X16# a b (# 22#, 24#, 28#, 28#, 27#, 26#, 26#, 28#, 20#, 17#, 28#, 26#, 28#, 26#, 28#, 16# #)
  test [22, 30, 26, 23, 30, 18, 28, 20, 29, 16, 18, 18, 16, 17, 23, 16] $ \a b -> shuffleInt8X16# a b (# 22#, 30#, 26#, 23#, 30#, 18#, 28#, 20#, 29#, 16#, 18#, 18#, 16#, 17#, 23#, 16# #)
  test [23, 8, 4, 4, 9, 10, 6, 30, 13, 5, 9, 22, 25, 20, 2, 11] $ \a b -> shuffleInt8X16# a b (# 23#, 8#, 4#, 4#, 9#, 10#, 6#, 30#, 13#, 5#, 9#, 22#, 25#, 20#, 2#, 11# #)
  test [23, 22, 20, 29, 31, 28, 21, 27, 25, 25, 29, 17, 26, 31, 21, 16] $ \a b -> shuffleInt8X16# a b (# 23#, 22#, 20#, 29#, 31#, 28#, 21#, 27#, 25#, 25#, 29#, 17#, 26#, 31#, 21#, 16# #)
  test [23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23] $ \a b -> shuffleInt8X16# a b (# 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23#, 23# #)
  test [23, 23, 29, 24, 30, 25, 25, 26, 30, 25, 21, 30, 18, 30, 24, 27] $ \a b -> shuffleInt8X16# a b (# 23#, 23#, 29#, 24#, 30#, 25#, 25#, 26#, 30#, 25#, 21#, 30#, 18#, 30#, 24#, 27# #)
  test [23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6] $ \a b -> shuffleInt8X16# a b (# 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6# #)
  test [23, 26, 28, 25, 23, 24, 18, 26, 18, 22, 28, 21, 26, 16, 29, 16] $ \a b -> shuffleInt8X16# a b (# 23#, 26#, 28#, 25#, 23#, 24#, 18#, 26#, 18#, 22#, 28#, 21#, 26#, 16#, 29#, 16# #)
  test [23, 26, 30, 18, 31, 25, 20, 18, 28, 18, 22, 18, 31, 19, 19, 21] $ \a b -> shuffleInt8X16# a b (# 23#, 26#, 30#, 18#, 31#, 25#, 20#, 18#, 28#, 18#, 22#, 18#, 31#, 19#, 19#, 21# #)
  test [24, 5, 3, 16, 7, 13, 14, 15, 9, 5, 5, 20, 20, 24, 2, 15] $ \a b -> shuffleInt8X16# a b (# 24#, 5#, 3#, 16#, 7#, 13#, 14#, 15#, 9#, 5#, 5#, 20#, 20#, 24#, 2#, 15# #)
  test [24, 8, 25, 9, 26, 10, 27, 11, 28, 12, 29, 13, 30, 14, 31, 15] $ \a b -> shuffleInt8X16# a b (# 24#, 8#, 25#, 9#, 26#, 10#, 27#, 11#, 28#, 12#, 29#, 13#, 30#, 14#, 31#, 15# #)
  test [24, 10, 9, 23, 28, 26, 8, 4, 21, 29, 2, 21, 5, 20, 4, 14] $ \a b -> shuffleInt8X16# a b (# 24#, 10#, 9#, 23#, 28#, 26#, 8#, 4#, 21#, 29#, 2#, 21#, 5#, 20#, 4#, 14# #)
  test [24, 16, 23, 25, 0, 16, 1, 17, 5, 21, 18, 6, 30, 23, 10, 31] $ \a b -> shuffleInt8X16# a b (# 24#, 16#, 23#, 25#, 0#, 16#, 1#, 17#, 5#, 21#, 18#, 6#, 30#, 23#, 10#, 31# #)
  test [24, 17, 20, 19, 27, 27, 30, 26, 18, 19, 26, 19, 19, 16, 18, 30] $ \a b -> shuffleInt8X16# a b (# 24#, 17#, 20#, 19#, 27#, 27#, 30#, 26#, 18#, 19#, 26#, 19#, 19#, 16#, 18#, 30# #)
  test [24, 17, 26, 21, 19, 19, 19, 16, 23, 28, 31, 29, 19, 23, 26, 22] $ \a b -> shuffleInt8X16# a b (# 24#, 17#, 26#, 21#, 19#, 19#, 19#, 16#, 23#, 28#, 31#, 29#, 19#, 23#, 26#, 22# #)
  test [24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24] $ \a b -> shuffleInt8X16# a b (# 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24#, 24# #)
  test [24, 25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7] $ \a b -> shuffleInt8X16# a b (# 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7# #)
  test [24, 28, 22, 27, 20, 31, 25, 30, 25, 19, 25, 20, 29, 23, 18, 26] $ \a b -> shuffleInt8X16# a b (# 24#, 28#, 22#, 27#, 20#, 31#, 25#, 30#, 25#, 19#, 25#, 20#, 29#, 23#, 18#, 26# #)
  test [25, 1, 25, 24, 13, 2, 6, 15, 7, 7, 16, 7, 27, 2, 1, 16] $ \a b -> shuffleInt8X16# a b (# 25#, 1#, 25#, 24#, 13#, 2#, 6#, 15#, 7#, 7#, 16#, 7#, 27#, 2#, 1#, 16# #)
  test [25, 17, 4, 30, 31, 31, 25, 13, 26, 29, 12, 18, 5, 5, 28, 6] $ \a b -> shuffleInt8X16# a b (# 25#, 17#, 4#, 30#, 31#, 31#, 25#, 13#, 26#, 29#, 12#, 18#, 5#, 5#, 28#, 6# #)
  test [25, 22, 31, 22, 24, 31, 23, 18, 20, 21, 29, 16, 26, 19, 26, 28] $ \a b -> shuffleInt8X16# a b (# 25#, 22#, 31#, 22#, 24#, 31#, 23#, 18#, 20#, 21#, 29#, 16#, 26#, 19#, 26#, 28# #)
  test [25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25] $ \a b -> shuffleInt8X16# a b (# 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25#, 25# #)
  test [25, 26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8] $ \a b -> shuffleInt8X16# a b (# 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8# #)
  test [25, 29, 24, 27, 30, 24, 31, 27, 30, 21, 21, 27, 17, 23, 26, 20] $ \a b -> shuffleInt8X16# a b (# 25#, 29#, 24#, 27#, 30#, 24#, 31#, 27#, 30#, 21#, 21#, 27#, 17#, 23#, 26#, 20# #)
  test [26, 7, 21, 29, 7, 20, 19, 31, 1, 9, 28, 31, 16, 29, 19, 4] $ \a b -> shuffleInt8X16# a b (# 26#, 7#, 21#, 29#, 7#, 20#, 19#, 31#, 1#, 9#, 28#, 31#, 16#, 29#, 19#, 4# #)
  test [26, 17, 16, 16, 21, 7, 19, 21, 15, 18, 7, 1, 5, 6, 11, 7] $ \a b -> shuffleInt8X16# a b (# 26#, 17#, 16#, 16#, 21#, 7#, 19#, 21#, 15#, 18#, 7#, 1#, 5#, 6#, 11#, 7# #)
  test [26, 24, 22, 26, 22, 27, 31, 23, 30, 19, 25, 21, 22, 23, 21, 28] $ \a b -> shuffleInt8X16# a b (# 26#, 24#, 22#, 26#, 22#, 27#, 31#, 23#, 30#, 19#, 25#, 21#, 22#, 23#, 21#, 28# #)
  test [26, 25, 26, 25, 21, 22, 28, 24, 26, 26, 19, 16, 30, 26, 24, 23] $ \a b -> shuffleInt8X16# a b (# 26#, 25#, 26#, 25#, 21#, 22#, 28#, 24#, 26#, 26#, 19#, 16#, 30#, 26#, 24#, 23# #)
  test [26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26] $ \a b -> shuffleInt8X16# a b (# 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26#, 26# #)
  test [26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9] $ \a b -> shuffleInt8X16# a b (# 26#, 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9# #)
  test [27, 10, 23, 12, 18, 30, 2, 23, 28, 3, 0, 27, 12, 8, 7, 16] $ \a b -> shuffleInt8X16# a b (# 27#, 10#, 23#, 12#, 18#, 30#, 2#, 23#, 28#, 3#, 0#, 27#, 12#, 8#, 7#, 16# #)
  test [27, 21, 30, 27, 22, 18, 29, 16, 29, 30, 24, 28, 18, 16, 19, 20] $ \a b -> shuffleInt8X16# a b (# 27#, 21#, 30#, 27#, 22#, 18#, 29#, 16#, 29#, 30#, 24#, 28#, 18#, 16#, 19#, 20# #)
  test [27, 25, 10, 10, 12, 25, 17, 24, 22, 15, 19, 27, 1, 21, 7, 8] $ \a b -> shuffleInt8X16# a b (# 27#, 25#, 10#, 10#, 12#, 25#, 17#, 24#, 22#, 15#, 19#, 27#, 1#, 21#, 7#, 8# #)
  test [27, 26, 29, 27, 20, 18, 31, 19, 30, 20, 19, 19, 24, 21, 22, 21] $ \a b -> shuffleInt8X16# a b (# 27#, 26#, 29#, 27#, 20#, 18#, 31#, 19#, 30#, 20#, 19#, 19#, 24#, 21#, 22#, 21# #)
  test [27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27] $ \a b -> shuffleInt8X16# a b (# 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27#, 27# #)
  test [27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10] $ \a b -> shuffleInt8X16# a b (# 27#, 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10# #)
  test [28, 5, 2, 22, 26, 27, 22, 30, 17, 28, 10, 9, 6, 3, 8, 26] $ \a b -> shuffleInt8X16# a b (# 28#, 5#, 2#, 22#, 26#, 27#, 22#, 30#, 17#, 28#, 10#, 9#, 6#, 3#, 8#, 26# #)
  test [28, 14, 7, 23, 24, 14, 24, 21, 3, 22, 2, 22, 30, 22, 20, 31] $ \a b -> shuffleInt8X16# a b (# 28#, 14#, 7#, 23#, 24#, 14#, 24#, 21#, 3#, 22#, 2#, 22#, 30#, 22#, 20#, 31# #)
  test [28, 16, 19, 31, 20, 19, 24, 30, 29, 22, 22, 20, 22, 23, 17, 23] $ \a b -> shuffleInt8X16# a b (# 28#, 16#, 19#, 31#, 20#, 19#, 24#, 30#, 29#, 22#, 22#, 20#, 22#, 23#, 17#, 23# #)
  test [28, 20, 18, 30, 19, 27, 22, 28, 22, 31, 20, 22, 20, 24, 28, 25] $ \a b -> shuffleInt8X16# a b (# 28#, 20#, 18#, 30#, 19#, 27#, 22#, 28#, 22#, 31#, 20#, 22#, 20#, 24#, 28#, 25# #)
  test [28, 20, 21, 18, 19, 19, 27, 16, 21, 28, 20, 26, 31, 24, 20, 25] $ \a b -> shuffleInt8X16# a b (# 28#, 20#, 21#, 18#, 19#, 19#, 27#, 16#, 21#, 28#, 20#, 26#, 31#, 24#, 20#, 25# #)
  test [28, 23, 24, 28, 21, 30, 21, 23, 18, 31, 23, 27, 29, 31, 18, 21] $ \a b -> shuffleInt8X16# a b (# 28#, 23#, 24#, 28#, 21#, 30#, 21#, 23#, 18#, 31#, 23#, 27#, 29#, 31#, 18#, 21# #)
  test [28, 28, 16, 25, 26, 22, 23, 21, 17, 27, 31, 25, 18, 19, 19, 16] $ \a b -> shuffleInt8X16# a b (# 28#, 28#, 16#, 25#, 26#, 22#, 23#, 21#, 17#, 27#, 31#, 25#, 18#, 19#, 19#, 16# #)
  test [28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28] $ \a b -> shuffleInt8X16# a b (# 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28#, 28# #)
  test [28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11] $ \a b -> shuffleInt8X16# a b (# 28#, 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11# #)
  test [29, 0, 19, 5, 28, 14, 24, 14, 28, 1, 8, 18, 30, 20, 16, 3] $ \a b -> shuffleInt8X16# a b (# 29#, 0#, 19#, 5#, 28#, 14#, 24#, 14#, 28#, 1#, 8#, 18#, 30#, 20#, 16#, 3# #)
  test [29, 15, 12, 31, 8, 22, 30, 20, 8, 26, 7, 12, 2, 4, 6, 19] $ \a b -> shuffleInt8X16# a b (# 29#, 15#, 12#, 31#, 8#, 22#, 30#, 20#, 8#, 26#, 7#, 12#, 2#, 4#, 6#, 19# #)
  test [29, 19, 19, 24, 0, 13, 30, 25, 13, 25, 7, 23, 23, 7, 17, 24] $ \a b -> shuffleInt8X16# a b (# 29#, 19#, 19#, 24#, 0#, 13#, 30#, 25#, 13#, 25#, 7#, 23#, 23#, 7#, 17#, 24# #)
  test [29, 19, 26, 20, 20, 19, 17, 24, 23, 19, 18, 28, 26, 19, 21, 22] $ \a b -> shuffleInt8X16# a b (# 29#, 19#, 26#, 20#, 20#, 19#, 17#, 24#, 23#, 19#, 18#, 28#, 26#, 19#, 21#, 22# #)
  test [29, 23, 21, 27, 16, 16, 16, 23, 24, 23, 16, 31, 19, 26, 19, 31] $ \a b -> shuffleInt8X16# a b (# 29#, 23#, 21#, 27#, 16#, 16#, 16#, 23#, 24#, 23#, 16#, 31#, 19#, 26#, 19#, 31# #)
  test [29, 29, 0, 16, 11, 25, 3, 19, 6, 4, 10, 27, 14, 16, 8, 0] $ \a b -> shuffleInt8X16# a b (# 29#, 29#, 0#, 16#, 11#, 25#, 3#, 19#, 6#, 4#, 10#, 27#, 14#, 16#, 8#, 0# #)
  test [29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29] $ \a b -> shuffleInt8X16# a b (# 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29#, 29# #)
  test [29, 30, 22, 16, 19, 25, 17, 21, 29, 16, 28, 31, 29, 24, 22, 18] $ \a b -> shuffleInt8X16# a b (# 29#, 30#, 22#, 16#, 19#, 25#, 17#, 21#, 29#, 16#, 28#, 31#, 29#, 24#, 22#, 18# #)
  test [29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12] $ \a b -> shuffleInt8X16# a b (# 29#, 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12# #)
  test [30, 16, 22, 24, 23, 16, 23, 21, 30, 22, 22, 21, 16, 20, 31, 17] $ \a b -> shuffleInt8X16# a b (# 30#, 16#, 22#, 24#, 23#, 16#, 23#, 21#, 30#, 22#, 22#, 21#, 16#, 20#, 31#, 17# #)
  test [30, 19, 17, 21, 23, 19, 30, 30, 17, 18, 17, 20, 17, 24, 27, 21] $ \a b -> shuffleInt8X16# a b (# 30#, 19#, 17#, 21#, 23#, 19#, 30#, 30#, 17#, 18#, 17#, 20#, 17#, 24#, 27#, 21# #)
  test [30, 20, 18, 24, 25, 19, 18, 23, 19, 22, 27, 26, 28, 29, 25, 21] $ \a b -> shuffleInt8X16# a b (# 30#, 20#, 18#, 24#, 25#, 19#, 18#, 23#, 19#, 22#, 27#, 26#, 28#, 29#, 25#, 21# #)
  test [30, 22, 19, 26, 21, 24, 20, 26, 23, 23, 28, 20, 27, 31, 29, 20] $ \a b -> shuffleInt8X16# a b (# 30#, 22#, 19#, 26#, 21#, 24#, 20#, 26#, 23#, 23#, 28#, 20#, 27#, 31#, 29#, 20# #)
  test [30, 23, 28, 23, 20, 23, 29, 31, 31, 24, 27, 17, 31, 23, 18, 20] $ \a b -> shuffleInt8X16# a b (# 30#, 23#, 28#, 23#, 20#, 23#, 29#, 31#, 31#, 24#, 27#, 17#, 31#, 23#, 18#, 20# #)
  test [30, 24, 26, 7, 7, 1, 20, 7, 18, 12, 16, 2, 19, 27, 8, 5] $ \a b -> shuffleInt8X16# a b (# 30#, 24#, 26#, 7#, 7#, 1#, 20#, 7#, 18#, 12#, 16#, 2#, 19#, 27#, 8#, 5# #)
  test [30, 26, 27, 20, 29, 22, 28, 21, 25, 18, 21, 28, 21, 21, 21, 30] $ \a b -> shuffleInt8X16# a b (# 30#, 26#, 27#, 20#, 29#, 22#, 28#, 21#, 25#, 18#, 21#, 28#, 21#, 21#, 21#, 30# #)
  test [30, 26, 31, 31, 21, 23, 26, 28, 30, 23, 31, 27, 18, 21, 17, 28] $ \a b -> shuffleInt8X16# a b (# 30#, 26#, 31#, 31#, 21#, 23#, 26#, 28#, 30#, 23#, 31#, 27#, 18#, 21#, 17#, 28# #)
  test [30, 29, 28, 31, 28, 22, 17, 27, 24, 18, 21, 24, 20, 18, 22, 23] $ \a b -> shuffleInt8X16# a b (# 30#, 29#, 28#, 31#, 28#, 22#, 17#, 27#, 24#, 18#, 21#, 24#, 20#, 18#, 22#, 23# #)
  test [30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30] $ \a b -> shuffleInt8X16# a b (# 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30#, 30# #)
  test [30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13] $ \a b -> shuffleInt8X16# a b (# 30#, 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13# #)
  test [31, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14] $ \a b -> shuffleInt8X16# a b (# 31#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14# #)
  test [31, 6, 25, 1, 30, 17, 0, 4, 4, 4, 15, 30, 7, 5, 0, 16] $ \a b -> shuffleInt8X16# a b (# 31#, 6#, 25#, 1#, 30#, 17#, 0#, 4#, 4#, 4#, 15#, 30#, 7#, 5#, 0#, 16# #)
  test [31, 19, 24, 27, 26, 16, 29, 24, 31, 28, 27, 24, 19, 26, 23, 20] $ \a b -> shuffleInt8X16# a b (# 31#, 19#, 24#, 27#, 26#, 16#, 29#, 24#, 31#, 28#, 27#, 24#, 19#, 26#, 23#, 20# #)
  test [31, 24, 9, 17, 18, 15, 9, 13, 26, 31, 13, 26, 15, 23, 21, 12] $ \a b -> shuffleInt8X16# a b (# 31#, 24#, 9#, 17#, 18#, 15#, 9#, 13#, 26#, 31#, 13#, 26#, 15#, 23#, 21#, 12# #)
  test [31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16] $ \a b -> shuffleInt8X16# a b (# 31#, 30#, 29#, 28#, 27#, 26#, 25#, 24#, 23#, 22#, 21#, 20#, 19#, 18#, 17#, 16# #)
  test [31, 31, 22, 27, 27, 17, 29, 21, 25, 28, 24, 27, 25, 25, 22, 22] $ \a b -> shuffleInt8X16# a b (# 31#, 31#, 22#, 27#, 27#, 17#, 29#, 21#, 25#, 28#, 24#, 27#, 25#, 25#, 22#, 22# #)
  test [31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31] $ \a b -> shuffleInt8X16# a b (# 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31#, 31# #)
  test0x [16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14# #)
  test0x [16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13# #)
  test0x [16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12# #)
  test0x [16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11# #)
  test0x [16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10# #)
  test0x [16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30# #)
  test0x [0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29# #)
  test0x [0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28# #)
  test0x [0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27# #)
  test0x [0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26# #)
  test0x [0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16# #)
  test0x [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16# #)
  test0x [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16# #)
  test0x [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16# #)
  test0x [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16# #)
  test0x [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  test0x [17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0# #)
  test0x [18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0# #)
  test0x [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0# #)
  test0x [20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0# #)
  test0x [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0# #)
  test0x [22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x [0, 24, 11, 6, 22, 21, 5, 16, 12, 7, 18, 1, 1, 23, 8, 2] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 0#, 24#, 11#, 6#, 22#, 21#, 5#, 16#, 12#, 7#, 18#, 1#, 1#, 23#, 8#, 2# #)
  test0x [1, 28, 25, 30, 13, 15, 3, 21, 31, 13, 29, 31, 16, 14, 22, 15] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 1#, 28#, 25#, 30#, 13#, 15#, 3#, 21#, 31#, 13#, 29#, 31#, 16#, 14#, 22#, 15# #)
  test0x [1, 30, 26, 9, 5, 9, 13, 6, 20, 0, 7, 2, 22, 13, 8, 8] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 1#, 30#, 26#, 9#, 5#, 9#, 13#, 6#, 20#, 0#, 7#, 2#, 22#, 13#, 8#, 8# #)
  test0x [2, 17, 12, 4, 27, 15, 27, 26, 30, 21, 1, 14, 16, 10, 6, 4] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 2#, 17#, 12#, 4#, 27#, 15#, 27#, 26#, 30#, 21#, 1#, 14#, 16#, 10#, 6#, 4# #)
  test0x [2, 19, 30, 1, 13, 26, 12, 10, 21, 9, 3, 6, 22, 31, 2, 31] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 2#, 19#, 30#, 1#, 13#, 26#, 12#, 10#, 21#, 9#, 3#, 6#, 22#, 31#, 2#, 31# #)
  test0x [4, 27, 25, 11, 6, 13, 17, 1, 5, 0, 2, 25, 20, 0, 15, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 4#, 27#, 25#, 11#, 6#, 13#, 17#, 1#, 5#, 0#, 2#, 25#, 20#, 0#, 15#, 0# #)
  test0x [5, 3, 11, 29, 30, 19, 3, 16, 5, 2, 20, 19, 25, 1, 22, 10] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 5#, 3#, 11#, 29#, 30#, 19#, 3#, 16#, 5#, 2#, 20#, 19#, 25#, 1#, 22#, 10# #)
  test0x [5, 21, 19, 3, 21, 22, 25, 10, 7, 6, 31, 24, 23, 1, 20, 28] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 5#, 21#, 19#, 3#, 21#, 22#, 25#, 10#, 7#, 6#, 31#, 24#, 23#, 1#, 20#, 28# #)
  test0x [5, 21, 27, 2, 0, 21, 7, 4, 28, 5, 30, 26, 10, 13, 15, 8] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 5#, 21#, 27#, 2#, 0#, 21#, 7#, 4#, 28#, 5#, 30#, 26#, 10#, 13#, 15#, 8# #)
  test0x [5, 25, 27, 18, 27, 22, 5, 14, 24, 5, 23, 12, 6, 15, 16, 8] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 5#, 25#, 27#, 18#, 27#, 22#, 5#, 14#, 24#, 5#, 23#, 12#, 6#, 15#, 16#, 8# #)
  test0x [6, 4, 10, 4, 16, 19, 17, 29, 31, 26, 4, 9, 14, 6, 14, 9] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 6#, 4#, 10#, 4#, 16#, 19#, 17#, 29#, 31#, 26#, 4#, 9#, 14#, 6#, 14#, 9# #)
  test0x [6, 13, 3, 0, 18, 16, 13, 15, 18, 29, 26, 28, 7, 26, 12, 9] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 6#, 13#, 3#, 0#, 18#, 16#, 13#, 15#, 18#, 29#, 26#, 28#, 7#, 26#, 12#, 9# #)
  test0x [7, 8, 24, 19, 16, 16, 14, 16, 17, 12, 8, 15, 24, 20, 11, 28] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 7#, 8#, 24#, 19#, 16#, 16#, 14#, 16#, 17#, 12#, 8#, 15#, 24#, 20#, 11#, 28# #)
  test0x [8, 13, 15, 0, 10, 14, 26, 3, 29, 11, 27, 14, 12, 28, 20, 10] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 8#, 13#, 15#, 0#, 10#, 14#, 26#, 3#, 29#, 11#, 27#, 14#, 12#, 28#, 20#, 10# #)
  test0x [8, 22, 25, 30, 19, 12, 30, 0, 25, 6, 29, 6, 10, 6, 31, 25] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 8#, 22#, 25#, 30#, 19#, 12#, 30#, 0#, 25#, 6#, 29#, 6#, 10#, 6#, 31#, 25# #)
  test0x [10, 2, 7, 25, 10, 25, 29, 11, 17, 5, 10, 27, 22, 9, 27, 6] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 10#, 2#, 7#, 25#, 10#, 25#, 29#, 11#, 17#, 5#, 10#, 27#, 22#, 9#, 27#, 6# #)
  test0x [11, 5, 30, 5, 8, 24, 27, 16, 29, 12, 14, 3, 7, 5, 26, 6] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 11#, 5#, 30#, 5#, 8#, 24#, 27#, 16#, 29#, 12#, 14#, 3#, 7#, 5#, 26#, 6# #)
  test0x [11, 14, 6, 11, 1, 30, 21, 26, 29, 12, 24, 16, 26, 29, 2, 31] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 11#, 14#, 6#, 11#, 1#, 30#, 21#, 26#, 29#, 12#, 24#, 16#, 26#, 29#, 2#, 31# #)
  test0x [13, 9, 3, 30, 12, 24, 8, 23, 24, 15, 17, 27, 16, 3, 26, 3] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 13#, 9#, 3#, 30#, 12#, 24#, 8#, 23#, 24#, 15#, 17#, 27#, 16#, 3#, 26#, 3# #)
  test0x [13, 9, 15, 17, 16, 19, 19, 21, 12, 11, 25, 11, 28, 6, 5, 20] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 13#, 9#, 15#, 17#, 16#, 19#, 19#, 21#, 12#, 11#, 25#, 11#, 28#, 6#, 5#, 20# #)
  test0x [14, 9, 20, 10, 29, 28, 19, 17, 18, 1, 13, 13, 7, 3, 7, 15] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 14#, 9#, 20#, 10#, 29#, 28#, 19#, 17#, 18#, 1#, 13#, 13#, 7#, 3#, 7#, 15# #)
  test0x [14, 14, 15, 8, 12, 10, 21, 26, 31, 25, 20, 20, 11, 7, 0, 24] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 14#, 14#, 15#, 8#, 12#, 10#, 21#, 26#, 31#, 25#, 20#, 20#, 11#, 7#, 0#, 24# #)
  test0x [14, 27, 23, 13, 9, 23, 1, 5, 16, 7, 31, 9, 16, 26, 30, 11] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 14#, 27#, 23#, 13#, 9#, 23#, 1#, 5#, 16#, 7#, 31#, 9#, 16#, 26#, 30#, 11# #)
  test0x [15, 4, 6, 12, 6, 18, 29, 24, 10, 4, 3, 8, 9, 8, 20, 4] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 15#, 4#, 6#, 12#, 6#, 18#, 29#, 24#, 10#, 4#, 3#, 8#, 9#, 8#, 20#, 4# #)
  test0x [15, 24, 4, 15, 4, 18, 27, 29, 10, 24, 6, 12, 28, 20, 12, 18] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 15#, 24#, 4#, 15#, 4#, 18#, 27#, 29#, 10#, 24#, 6#, 12#, 28#, 20#, 12#, 18# #)
  test0x [19, 21, 17, 2, 24, 7, 12, 18, 27, 29, 27, 16, 21, 16, 4, 7] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 19#, 21#, 17#, 2#, 24#, 7#, 12#, 18#, 27#, 29#, 27#, 16#, 21#, 16#, 4#, 7# #)
  test0x [21, 6, 19, 16, 14, 21, 5, 29, 28, 31, 10, 0, 12, 8, 3, 12] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 21#, 6#, 19#, 16#, 14#, 21#, 5#, 29#, 28#, 31#, 10#, 0#, 12#, 8#, 3#, 12# #)
  test0x [21, 24, 27, 20, 17, 31, 31, 12, 21, 4, 22, 3, 4, 21, 14, 3] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 21#, 24#, 27#, 20#, 17#, 31#, 31#, 12#, 21#, 4#, 22#, 3#, 4#, 21#, 14#, 3# #)
  test0x [21, 28, 28, 18, 4, 12, 13, 25, 20, 26, 22, 24, 28, 11, 28, 10] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 21#, 28#, 28#, 18#, 4#, 12#, 13#, 25#, 20#, 26#, 22#, 24#, 28#, 11#, 28#, 10# #)
  test0x [22, 0, 27, 14, 5, 24, 7, 16, 19, 19, 11, 20, 24, 11, 31, 28] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 22#, 0#, 27#, 14#, 5#, 24#, 7#, 16#, 19#, 19#, 11#, 20#, 24#, 11#, 31#, 28# #)
  test0x [22, 5, 22, 23, 28, 12, 9, 12, 15, 19, 8, 29, 20, 11, 3, 9] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 22#, 5#, 22#, 23#, 28#, 12#, 9#, 12#, 15#, 19#, 8#, 29#, 20#, 11#, 3#, 9# #)
  test0x [23, 8, 4, 4, 9, 10, 6, 30, 13, 5, 9, 22, 25, 20, 2, 11] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 23#, 8#, 4#, 4#, 9#, 10#, 6#, 30#, 13#, 5#, 9#, 22#, 25#, 20#, 2#, 11# #)
  test0x [24, 5, 3, 16, 7, 13, 14, 15, 9, 5, 5, 20, 20, 24, 2, 15] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 24#, 5#, 3#, 16#, 7#, 13#, 14#, 15#, 9#, 5#, 5#, 20#, 20#, 24#, 2#, 15# #)
  test0x [24, 10, 9, 23, 28, 26, 8, 4, 21, 29, 2, 21, 5, 20, 4, 14] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 24#, 10#, 9#, 23#, 28#, 26#, 8#, 4#, 21#, 29#, 2#, 21#, 5#, 20#, 4#, 14# #)
  test0x [24, 16, 23, 25, 0, 16, 1, 17, 5, 21, 18, 6, 30, 23, 10, 31] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 24#, 16#, 23#, 25#, 0#, 16#, 1#, 17#, 5#, 21#, 18#, 6#, 30#, 23#, 10#, 31# #)
  test0x [25, 1, 25, 24, 13, 2, 6, 15, 7, 7, 16, 7, 27, 2, 1, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 25#, 1#, 25#, 24#, 13#, 2#, 6#, 15#, 7#, 7#, 16#, 7#, 27#, 2#, 1#, 16# #)
  test0x [25, 17, 4, 30, 31, 31, 25, 13, 26, 29, 12, 18, 5, 5, 28, 6] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 25#, 17#, 4#, 30#, 31#, 31#, 25#, 13#, 26#, 29#, 12#, 18#, 5#, 5#, 28#, 6# #)
  test0x [26, 7, 21, 29, 7, 20, 19, 31, 1, 9, 28, 31, 16, 29, 19, 4] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 26#, 7#, 21#, 29#, 7#, 20#, 19#, 31#, 1#, 9#, 28#, 31#, 16#, 29#, 19#, 4# #)
  test0x [26, 17, 16, 16, 21, 7, 19, 21, 15, 18, 7, 1, 5, 6, 11, 7] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 26#, 17#, 16#, 16#, 21#, 7#, 19#, 21#, 15#, 18#, 7#, 1#, 5#, 6#, 11#, 7# #)
  test0x [27, 10, 23, 12, 18, 30, 2, 23, 28, 3, 0, 27, 12, 8, 7, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 27#, 10#, 23#, 12#, 18#, 30#, 2#, 23#, 28#, 3#, 0#, 27#, 12#, 8#, 7#, 16# #)
  test0x [27, 25, 10, 10, 12, 25, 17, 24, 22, 15, 19, 27, 1, 21, 7, 8] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 27#, 25#, 10#, 10#, 12#, 25#, 17#, 24#, 22#, 15#, 19#, 27#, 1#, 21#, 7#, 8# #)
  test0x [28, 5, 2, 22, 26, 27, 22, 30, 17, 28, 10, 9, 6, 3, 8, 26] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 28#, 5#, 2#, 22#, 26#, 27#, 22#, 30#, 17#, 28#, 10#, 9#, 6#, 3#, 8#, 26# #)
  test0x [28, 14, 7, 23, 24, 14, 24, 21, 3, 22, 2, 22, 30, 22, 20, 31] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 28#, 14#, 7#, 23#, 24#, 14#, 24#, 21#, 3#, 22#, 2#, 22#, 30#, 22#, 20#, 31# #)
  test0x [29, 0, 19, 5, 28, 14, 24, 14, 28, 1, 8, 18, 30, 20, 16, 3] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 29#, 0#, 19#, 5#, 28#, 14#, 24#, 14#, 28#, 1#, 8#, 18#, 30#, 20#, 16#, 3# #)
  test0x [29, 15, 12, 31, 8, 22, 30, 20, 8, 26, 7, 12, 2, 4, 6, 19] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 29#, 15#, 12#, 31#, 8#, 22#, 30#, 20#, 8#, 26#, 7#, 12#, 2#, 4#, 6#, 19# #)
  test0x [29, 19, 19, 24, 0, 13, 30, 25, 13, 25, 7, 23, 23, 7, 17, 24] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 29#, 19#, 19#, 24#, 0#, 13#, 30#, 25#, 13#, 25#, 7#, 23#, 23#, 7#, 17#, 24# #)
  test0x [29, 29, 0, 16, 11, 25, 3, 19, 6, 4, 10, 27, 14, 16, 8, 0] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 29#, 29#, 0#, 16#, 11#, 25#, 3#, 19#, 6#, 4#, 10#, 27#, 14#, 16#, 8#, 0# #)
  test0x [30, 24, 26, 7, 7, 1, 20, 7, 18, 12, 16, 2, 19, 27, 8, 5] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 30#, 24#, 26#, 7#, 7#, 1#, 20#, 7#, 18#, 12#, 16#, 2#, 19#, 27#, 8#, 5# #)
  test0x [31, 6, 25, 1, 30, 17, 0, 4, 4, 4, 15, 30, 7, 5, 0, 16] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 31#, 6#, 25#, 1#, 30#, 17#, 0#, 4#, 4#, 4#, 15#, 30#, 7#, 5#, 0#, 16# #)
  test0x [31, 24, 9, 17, 18, 15, 9, 13, 26, 31, 13, 26, 15, 23, 21, 12] $ \b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# 31#, 24#, 9#, 17#, 18#, 15#, 9#, 13#, 26#, 31#, 13#, 26#, 15#, 23#, 21#, 12# #)
  testx0 [16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14# #)
  testx0 [16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13# #)
  testx0 [16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12# #)
  testx0 [16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11# #)
  testx0 [16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10# #)
  testx0 [16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5#, 6# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4#, 5# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3#, 4# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2#, 3# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1#, 2# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0#, 1# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 0# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30# #)
  testx0 [0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29# #)
  testx0 [0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28# #)
  testx0 [0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27# #)
  testx0 [0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26# #)
  testx0 [0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23, 24] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22, 23] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22#, 23# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21, 22] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21#, 22# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20#, 21# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19#, 20# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18#, 19# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17#, 18# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16#, 17# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 16# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16# #)
  testx0 [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16# #)
  testx0 [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16# #)
  testx0 [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16# #)
  testx0 [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 9#, 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 10#, 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 11#, 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 12#, 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 13#, 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 14#, 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 15#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16#, 16# #)
  testx0 [17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 17#, 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0# #)
  testx0 [18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 18#, 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0# #)
  testx0 [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 19#, 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0# #)
  testx0 [20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 20#, 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0# #)
  testx0 [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 21#, 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 22#, 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [23, 24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 23#, 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [24, 25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 24#, 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [25, 26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 25#, 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [26, 27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 26#, 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [27, 28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 27#, 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [28, 29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 28#, 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [29, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 29#, 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 30#, 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 31#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 [0, 24, 11, 6, 22, 21, 5, 16, 12, 7, 18, 1, 1, 23, 8, 2] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 0#, 24#, 11#, 6#, 22#, 21#, 5#, 16#, 12#, 7#, 18#, 1#, 1#, 23#, 8#, 2# #)
  testx0 [1, 28, 25, 30, 13, 15, 3, 21, 31, 13, 29, 31, 16, 14, 22, 15] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 1#, 28#, 25#, 30#, 13#, 15#, 3#, 21#, 31#, 13#, 29#, 31#, 16#, 14#, 22#, 15# #)
  testx0 [1, 30, 26, 9, 5, 9, 13, 6, 20, 0, 7, 2, 22, 13, 8, 8] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 1#, 30#, 26#, 9#, 5#, 9#, 13#, 6#, 20#, 0#, 7#, 2#, 22#, 13#, 8#, 8# #)
  testx0 [2, 17, 12, 4, 27, 15, 27, 26, 30, 21, 1, 14, 16, 10, 6, 4] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 2#, 17#, 12#, 4#, 27#, 15#, 27#, 26#, 30#, 21#, 1#, 14#, 16#, 10#, 6#, 4# #)
  testx0 [2, 19, 30, 1, 13, 26, 12, 10, 21, 9, 3, 6, 22, 31, 2, 31] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 2#, 19#, 30#, 1#, 13#, 26#, 12#, 10#, 21#, 9#, 3#, 6#, 22#, 31#, 2#, 31# #)
  testx0 [4, 27, 25, 11, 6, 13, 17, 1, 5, 0, 2, 25, 20, 0, 15, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 4#, 27#, 25#, 11#, 6#, 13#, 17#, 1#, 5#, 0#, 2#, 25#, 20#, 0#, 15#, 0# #)
  testx0 [5, 3, 11, 29, 30, 19, 3, 16, 5, 2, 20, 19, 25, 1, 22, 10] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 5#, 3#, 11#, 29#, 30#, 19#, 3#, 16#, 5#, 2#, 20#, 19#, 25#, 1#, 22#, 10# #)
  testx0 [5, 21, 19, 3, 21, 22, 25, 10, 7, 6, 31, 24, 23, 1, 20, 28] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 5#, 21#, 19#, 3#, 21#, 22#, 25#, 10#, 7#, 6#, 31#, 24#, 23#, 1#, 20#, 28# #)
  testx0 [5, 21, 27, 2, 0, 21, 7, 4, 28, 5, 30, 26, 10, 13, 15, 8] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 5#, 21#, 27#, 2#, 0#, 21#, 7#, 4#, 28#, 5#, 30#, 26#, 10#, 13#, 15#, 8# #)
  testx0 [5, 25, 27, 18, 27, 22, 5, 14, 24, 5, 23, 12, 6, 15, 16, 8] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 5#, 25#, 27#, 18#, 27#, 22#, 5#, 14#, 24#, 5#, 23#, 12#, 6#, 15#, 16#, 8# #)
  testx0 [6, 4, 10, 4, 16, 19, 17, 29, 31, 26, 4, 9, 14, 6, 14, 9] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 6#, 4#, 10#, 4#, 16#, 19#, 17#, 29#, 31#, 26#, 4#, 9#, 14#, 6#, 14#, 9# #)
  testx0 [6, 13, 3, 0, 18, 16, 13, 15, 18, 29, 26, 28, 7, 26, 12, 9] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 6#, 13#, 3#, 0#, 18#, 16#, 13#, 15#, 18#, 29#, 26#, 28#, 7#, 26#, 12#, 9# #)
  testx0 [7, 8, 24, 19, 16, 16, 14, 16, 17, 12, 8, 15, 24, 20, 11, 28] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 7#, 8#, 24#, 19#, 16#, 16#, 14#, 16#, 17#, 12#, 8#, 15#, 24#, 20#, 11#, 28# #)
  testx0 [8, 13, 15, 0, 10, 14, 26, 3, 29, 11, 27, 14, 12, 28, 20, 10] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 8#, 13#, 15#, 0#, 10#, 14#, 26#, 3#, 29#, 11#, 27#, 14#, 12#, 28#, 20#, 10# #)
  testx0 [8, 22, 25, 30, 19, 12, 30, 0, 25, 6, 29, 6, 10, 6, 31, 25] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 8#, 22#, 25#, 30#, 19#, 12#, 30#, 0#, 25#, 6#, 29#, 6#, 10#, 6#, 31#, 25# #)
  testx0 [10, 2, 7, 25, 10, 25, 29, 11, 17, 5, 10, 27, 22, 9, 27, 6] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 10#, 2#, 7#, 25#, 10#, 25#, 29#, 11#, 17#, 5#, 10#, 27#, 22#, 9#, 27#, 6# #)
  testx0 [11, 5, 30, 5, 8, 24, 27, 16, 29, 12, 14, 3, 7, 5, 26, 6] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 11#, 5#, 30#, 5#, 8#, 24#, 27#, 16#, 29#, 12#, 14#, 3#, 7#, 5#, 26#, 6# #)
  testx0 [11, 14, 6, 11, 1, 30, 21, 26, 29, 12, 24, 16, 26, 29, 2, 31] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 11#, 14#, 6#, 11#, 1#, 30#, 21#, 26#, 29#, 12#, 24#, 16#, 26#, 29#, 2#, 31# #)
  testx0 [13, 9, 3, 30, 12, 24, 8, 23, 24, 15, 17, 27, 16, 3, 26, 3] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 13#, 9#, 3#, 30#, 12#, 24#, 8#, 23#, 24#, 15#, 17#, 27#, 16#, 3#, 26#, 3# #)
  testx0 [13, 9, 15, 17, 16, 19, 19, 21, 12, 11, 25, 11, 28, 6, 5, 20] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 13#, 9#, 15#, 17#, 16#, 19#, 19#, 21#, 12#, 11#, 25#, 11#, 28#, 6#, 5#, 20# #)
  testx0 [14, 9, 20, 10, 29, 28, 19, 17, 18, 1, 13, 13, 7, 3, 7, 15] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 14#, 9#, 20#, 10#, 29#, 28#, 19#, 17#, 18#, 1#, 13#, 13#, 7#, 3#, 7#, 15# #)
  testx0 [14, 14, 15, 8, 12, 10, 21, 26, 31, 25, 20, 20, 11, 7, 0, 24] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 14#, 14#, 15#, 8#, 12#, 10#, 21#, 26#, 31#, 25#, 20#, 20#, 11#, 7#, 0#, 24# #)
  testx0 [14, 27, 23, 13, 9, 23, 1, 5, 16, 7, 31, 9, 16, 26, 30, 11] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 14#, 27#, 23#, 13#, 9#, 23#, 1#, 5#, 16#, 7#, 31#, 9#, 16#, 26#, 30#, 11# #)
  testx0 [15, 4, 6, 12, 6, 18, 29, 24, 10, 4, 3, 8, 9, 8, 20, 4] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 15#, 4#, 6#, 12#, 6#, 18#, 29#, 24#, 10#, 4#, 3#, 8#, 9#, 8#, 20#, 4# #)
  testx0 [15, 24, 4, 15, 4, 18, 27, 29, 10, 24, 6, 12, 28, 20, 12, 18] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 15#, 24#, 4#, 15#, 4#, 18#, 27#, 29#, 10#, 24#, 6#, 12#, 28#, 20#, 12#, 18# #)
  testx0 [19, 21, 17, 2, 24, 7, 12, 18, 27, 29, 27, 16, 21, 16, 4, 7] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 19#, 21#, 17#, 2#, 24#, 7#, 12#, 18#, 27#, 29#, 27#, 16#, 21#, 16#, 4#, 7# #)
  testx0 [21, 6, 19, 16, 14, 21, 5, 29, 28, 31, 10, 0, 12, 8, 3, 12] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 21#, 6#, 19#, 16#, 14#, 21#, 5#, 29#, 28#, 31#, 10#, 0#, 12#, 8#, 3#, 12# #)
  testx0 [21, 24, 27, 20, 17, 31, 31, 12, 21, 4, 22, 3, 4, 21, 14, 3] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 21#, 24#, 27#, 20#, 17#, 31#, 31#, 12#, 21#, 4#, 22#, 3#, 4#, 21#, 14#, 3# #)
  testx0 [21, 28, 28, 18, 4, 12, 13, 25, 20, 26, 22, 24, 28, 11, 28, 10] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 21#, 28#, 28#, 18#, 4#, 12#, 13#, 25#, 20#, 26#, 22#, 24#, 28#, 11#, 28#, 10# #)
  testx0 [22, 0, 27, 14, 5, 24, 7, 16, 19, 19, 11, 20, 24, 11, 31, 28] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 22#, 0#, 27#, 14#, 5#, 24#, 7#, 16#, 19#, 19#, 11#, 20#, 24#, 11#, 31#, 28# #)
  testx0 [22, 5, 22, 23, 28, 12, 9, 12, 15, 19, 8, 29, 20, 11, 3, 9] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 22#, 5#, 22#, 23#, 28#, 12#, 9#, 12#, 15#, 19#, 8#, 29#, 20#, 11#, 3#, 9# #)
  testx0 [23, 8, 4, 4, 9, 10, 6, 30, 13, 5, 9, 22, 25, 20, 2, 11] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 23#, 8#, 4#, 4#, 9#, 10#, 6#, 30#, 13#, 5#, 9#, 22#, 25#, 20#, 2#, 11# #)
  testx0 [24, 5, 3, 16, 7, 13, 14, 15, 9, 5, 5, 20, 20, 24, 2, 15] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 24#, 5#, 3#, 16#, 7#, 13#, 14#, 15#, 9#, 5#, 5#, 20#, 20#, 24#, 2#, 15# #)
  testx0 [24, 10, 9, 23, 28, 26, 8, 4, 21, 29, 2, 21, 5, 20, 4, 14] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 24#, 10#, 9#, 23#, 28#, 26#, 8#, 4#, 21#, 29#, 2#, 21#, 5#, 20#, 4#, 14# #)
  testx0 [24, 16, 23, 25, 0, 16, 1, 17, 5, 21, 18, 6, 30, 23, 10, 31] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 24#, 16#, 23#, 25#, 0#, 16#, 1#, 17#, 5#, 21#, 18#, 6#, 30#, 23#, 10#, 31# #)
  testx0 [25, 1, 25, 24, 13, 2, 6, 15, 7, 7, 16, 7, 27, 2, 1, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 25#, 1#, 25#, 24#, 13#, 2#, 6#, 15#, 7#, 7#, 16#, 7#, 27#, 2#, 1#, 16# #)
  testx0 [25, 17, 4, 30, 31, 31, 25, 13, 26, 29, 12, 18, 5, 5, 28, 6] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 25#, 17#, 4#, 30#, 31#, 31#, 25#, 13#, 26#, 29#, 12#, 18#, 5#, 5#, 28#, 6# #)
  testx0 [26, 7, 21, 29, 7, 20, 19, 31, 1, 9, 28, 31, 16, 29, 19, 4] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 26#, 7#, 21#, 29#, 7#, 20#, 19#, 31#, 1#, 9#, 28#, 31#, 16#, 29#, 19#, 4# #)
  testx0 [26, 17, 16, 16, 21, 7, 19, 21, 15, 18, 7, 1, 5, 6, 11, 7] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 26#, 17#, 16#, 16#, 21#, 7#, 19#, 21#, 15#, 18#, 7#, 1#, 5#, 6#, 11#, 7# #)
  testx0 [27, 10, 23, 12, 18, 30, 2, 23, 28, 3, 0, 27, 12, 8, 7, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 27#, 10#, 23#, 12#, 18#, 30#, 2#, 23#, 28#, 3#, 0#, 27#, 12#, 8#, 7#, 16# #)
  testx0 [27, 25, 10, 10, 12, 25, 17, 24, 22, 15, 19, 27, 1, 21, 7, 8] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 27#, 25#, 10#, 10#, 12#, 25#, 17#, 24#, 22#, 15#, 19#, 27#, 1#, 21#, 7#, 8# #)
  testx0 [28, 5, 2, 22, 26, 27, 22, 30, 17, 28, 10, 9, 6, 3, 8, 26] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 28#, 5#, 2#, 22#, 26#, 27#, 22#, 30#, 17#, 28#, 10#, 9#, 6#, 3#, 8#, 26# #)
  testx0 [28, 14, 7, 23, 24, 14, 24, 21, 3, 22, 2, 22, 30, 22, 20, 31] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 28#, 14#, 7#, 23#, 24#, 14#, 24#, 21#, 3#, 22#, 2#, 22#, 30#, 22#, 20#, 31# #)
  testx0 [29, 0, 19, 5, 28, 14, 24, 14, 28, 1, 8, 18, 30, 20, 16, 3] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 29#, 0#, 19#, 5#, 28#, 14#, 24#, 14#, 28#, 1#, 8#, 18#, 30#, 20#, 16#, 3# #)
  testx0 [29, 15, 12, 31, 8, 22, 30, 20, 8, 26, 7, 12, 2, 4, 6, 19] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 29#, 15#, 12#, 31#, 8#, 22#, 30#, 20#, 8#, 26#, 7#, 12#, 2#, 4#, 6#, 19# #)
  testx0 [29, 19, 19, 24, 0, 13, 30, 25, 13, 25, 7, 23, 23, 7, 17, 24] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 29#, 19#, 19#, 24#, 0#, 13#, 30#, 25#, 13#, 25#, 7#, 23#, 23#, 7#, 17#, 24# #)
  testx0 [29, 29, 0, 16, 11, 25, 3, 19, 6, 4, 10, 27, 14, 16, 8, 0] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 29#, 29#, 0#, 16#, 11#, 25#, 3#, 19#, 6#, 4#, 10#, 27#, 14#, 16#, 8#, 0# #)
  testx0 [30, 24, 26, 7, 7, 1, 20, 7, 18, 12, 16, 2, 19, 27, 8, 5] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 30#, 24#, 26#, 7#, 7#, 1#, 20#, 7#, 18#, 12#, 16#, 2#, 19#, 27#, 8#, 5# #)
  testx0 [31, 6, 25, 1, 30, 17, 0, 4, 4, 4, 15, 30, 7, 5, 0, 16] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 31#, 6#, 25#, 1#, 30#, 17#, 0#, 4#, 4#, 4#, 15#, 30#, 7#, 5#, 0#, 16# #)
  testx0 [31, 24, 9, 17, 18, 15, 9, 13, 26, 31, 13, 26, 15, 23, 21, 12] $ \a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# 31#, 24#, 9#, 17#, 18#, 15#, 9#, 13#, 26#, 31#, 13#, 26#, 15#, 23#, 21#, 12# #)

{- Generated by:
{- cabal:
build-depends: base, random >= 1.3.0
-}
import System.Random.Stateful
import qualified Data.List as List
import Control.Monad

main :: IO ()
main = do
  let fixedCases = [replicate 16 i | i <- [0..31]]
        ++ [[0..15]
           ,[16..31]
           ,[15,14..0]
           ,[31,30..16]
           ,concat [[i,16+i] | i <- [0..7]] -- PUNPCKLBW
           ,concat [[16+i,i] | i <- [0..7]] -- PUNPCKLBW
           ,concat [[8+i,24+i] | i <- [0..7]] -- PUNPCKHBW
           ,concat [[24+i,8+i] | i <- [0..7]] -- PUNPCKHBW
           ]
        ++ [take 16 (drop i [0..31]) | i <- [0..16]] -- PALIGNR
        ++ [take 16 (drop i ([16..31] ++ [0..15])) | i <- [0..16]] -- PALIGNR
      cases, randomCases :: [[Int]]
      (cases, randomCases) = runStateGen_ (mkStdGen 42) $ \g -> do
        first <- replicateM 50 $ replicateM 16 (uniformRM (0, 15) g)
        second <- replicateM 50 $ replicateM 16 (uniformRM (16, 31) g)
        randomCases <- replicateM 50 $ replicateM 16 (uniformRM (0, 31) g)
        blend <- replicateM 10 $ replicateM 8 (uniformRM (0, 1) g)
        let blendCases = [concat [[l, l + 1] | l <- zipWith (\i j -> 16 * i + 2 * j) is [0..]] | is <- blend]
        pure (List.nub $ List.sort $ fixedCases ++ first ++ second ++ randomCases ++ blendCases, List.nub $ List.sort randomCases)
  forM_ cases $ \xs -> do
    putStrLn $ "  test [" ++ List.intercalate ", " (map show xs) ++ "] $ \\a b -> shuffleInt8X16# a b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  let shiftCases = concat
        [[replicate i 16 ++ [0..15-i] | i <- [1..16]] -- PSLLDQ
        ,[replicate i 0 ++ [16..31-i] | i <- [1..16]] -- PSLLDQ
        ,[[i..15] ++ replicate i 16 | i <- [1..16]] -- PSRLDQ
        ,[[16+i..31] ++ replicate i 0 | i <- [1..16]] -- PSRLDQ
        ]
  forM_ (shiftCases ++ randomCases) $ \xs -> do
    putStrLn $ "  test0x [" ++ List.intercalate ", " (map show xs) ++ "] $ \\b -> shuffleInt8X16# (broadcastInt8X16# 0#Int8) b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  forM_ (shiftCases ++ randomCases) $ \xs -> do
    putStrLn $ "  testx0 [" ++ List.intercalate ", " (map show xs) ++ "] $ \\a -> shuffleInt8X16# a (broadcastInt8X16# 0#Int8) (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
-}
