; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -global-isel -stop-before=legalizer -simplify-mir < %s | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+v -global-isel -stop-before=legalizer -simplify-mir < %s | FileCheck %s --check-prefixes=CHECK

define void @add_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
  ; CHECK-LABEL: name: add_nxv2i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v8, $v9
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   PseudoRET
  %c = add <vscale x 2 x i32> %a, %b
  ret void
}

define void @sub_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
  ; CHECK-LABEL: name: sub_nxv2i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v8, $v9
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   PseudoRET
  %c = sub <vscale x 2 x i32> %a, %b
  ret void
}

define void @and_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
  ; CHECK-LABEL: name: and_nxv2i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v8, $v9
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   PseudoRET
  %c = and <vscale x 2 x i32> %a, %b
  ret void
}

define void @or_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
  ; CHECK-LABEL: name: or_nxv2i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v8, $v9
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   PseudoRET
  %c = or <vscale x 2 x i32> %a, %b
  ret void
}

define void @xor_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b) {
  ; CHECK-LABEL: name: xor_nxv2i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v8, $v9
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   PseudoRET
  %c = xor <vscale x 2 x i32> %a, %b
  ret void
}
