; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare void @use.i8(i8)

; Should be optimized to one and.
define i1 @test1(i32 %a, i32 %b) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 65280
; CHECK-NEXT:    [[TMP:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[TMP]]
;
  %tmp1 = and i32 %a, 65280
  %tmp3 = and i32 %b, 65280
  %tmp = icmp ne i32 %tmp1, %tmp3
  ret i1 %tmp
}

define <2 x i1> @test1vec(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @test1vec(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i32> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = and <2 x i32> [[TMP1]], splat (i32 65280)
; CHECK-NEXT:    [[TMP:%.*]] = icmp ne <2 x i32> [[TMP2]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[TMP]]
;
  %tmp1 = and <2 x i32> %a, <i32 65280, i32 65280>
  %tmp3 = and <2 x i32> %b, <i32 65280, i32 65280>
  %tmp = icmp ne <2 x i32> %tmp1, %tmp3
  ret <2 x i1> %tmp
}

define i1 @test2(i64 %A) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[A:%.*]], 128
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[AND]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i64 %A, 128
  %cmp = icmp eq i64 %and, 0
  ret i1 %cmp
}

define <2 x i1> @test2vec(<2 x i64> %A) {
; CHECK-LABEL: @test2vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i64> [[A:%.*]], splat (i64 128)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[AND]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %and = and <2 x i64> %A, <i64 128, i64 128>
  %cmp = icmp eq <2 x i64> %and, zeroinitializer
  ret <2 x i1> %cmp
}

define i1 @test3(i64 %A) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[A:%.*]], 128
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[AND]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i64 %A, 128
  %cmp = icmp ne i64 %and, 0
  ret i1 %cmp
}

define <2 x i1> @test3vec(<2 x i64> %A) {
; CHECK-LABEL: @test3vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i64> [[A:%.*]], splat (i64 128)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i64> [[AND]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %and = and <2 x i64> %A, <i64 128, i64 128>
  %cmp = icmp ne <2 x i64> %and, zeroinitializer
  ret <2 x i1> %cmp
}

define i1 @test_ne_cp2(i8 %x, i8 %yy) {
; CHECK-LABEL: @test_ne_cp2(
; CHECK-NEXT:    [[AND_X_NEG_Y:%.*]] = and i8 [[X:%.*]], -16
; CHECK-NEXT:    [[AND_X_Y:%.*]] = and i8 [[X]], 16
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_NEG_Y]])
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_Y]])
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[X]], 31
; CHECK-NEXT:    ret i1 [[R]]
;
  %and_x_neg_y = and i8 %x, -16
  %and_x_y = and i8 %x, 16
  call void @use.i8(i8 %and_x_neg_y)
  call void @use.i8(i8 %and_x_y)
  %r = icmp ne i8 %and_x_neg_y, %and_x_y
  ret i1 %r
}

define i1 @test_ne_cp2_2(i8 %x, i8 %yy) {
; CHECK-LABEL: @test_ne_cp2_2(
; CHECK-NEXT:    [[AND_X_NEG_Y:%.*]] = and i8 [[X:%.*]], -4
; CHECK-NEXT:    [[AND_X_Y:%.*]] = and i8 [[X]], 4
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_NEG_Y]])
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_Y]])
; CHECK-NEXT:    [[R:%.*]] = icmp ult i8 [[X]], 8
; CHECK-NEXT:    ret i1 [[R]]
;
  %and_x_neg_y = and i8 %x, -4
  %and_x_y = and i8 %x, 4
  call void @use.i8(i8 %and_x_neg_y)
  call void @use.i8(i8 %and_x_y)
  %r = icmp eq i8 %and_x_y, %and_x_neg_y
  ret i1 %r
}

define i1 @test_ne_cp2_other_okay_all_ones(i8 %x, i8 %yy) {
; CHECK-LABEL: @test_ne_cp2_other_okay_all_ones(
; CHECK-NEXT:    [[AND_X_NEG_Y:%.*]] = and i8 [[X:%.*]], -17
; CHECK-NEXT:    [[AND_X_Y:%.*]] = and i8 [[X]], 16
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_NEG_Y]])
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_Y]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %and_x_neg_y = and i8 %x, -17
  %and_x_y = and i8 %x, 16
  call void @use.i8(i8 %and_x_neg_y)
  call void @use.i8(i8 %and_x_y)
  %r = icmp ne i8 %and_x_neg_y, %and_x_y
  ret i1 %r
}

define i1 @test_ne_cp2_other_fail2(i8 %x, i8 %yy) {
; CHECK-LABEL: @test_ne_cp2_other_fail2(
; CHECK-NEXT:    [[AND_X_NEG_Y:%.*]] = and i8 [[X:%.*]], -16
; CHECK-NEXT:    [[AND_X_Y:%.*]] = and i8 [[X]], 17
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_NEG_Y]])
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_Y]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[AND_X_NEG_Y]], [[AND_X_Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %and_x_neg_y = and i8 %x, -16
  %and_x_y = and i8 %x, 17
  call void @use.i8(i8 %and_x_neg_y)
  call void @use.i8(i8 %and_x_y)
  %r = icmp ne i8 %and_x_neg_y, %and_x_y
  ret i1 %r
}

define i1 @test_ne_cp2_other_okay(i8 %x, i8 %yy) {
; CHECK-LABEL: @test_ne_cp2_other_okay(
; CHECK-NEXT:    [[AND_X_Y:%.*]] = and i8 [[X:%.*]], 16
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_Y]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %and_x_neg_y = and i8 %x, -17
  %and_x_y = and i8 %x, 16
  call void @use.i8(i8 %and_x_y)
  %r = icmp ne i8 %and_x_neg_y, %and_x_y
  ret i1 %r
}

define i1 @test_ne_cp2_other_okay2(i8 %x, i8 %yy) {
; CHECK-LABEL: @test_ne_cp2_other_okay2(
; CHECK-NEXT:    [[AND_X_Y:%.*]] = and i8 [[X:%.*]], 16
; CHECK-NEXT:    call void @use.i8(i8 [[AND_X_Y]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %and_x_neg_y = and i8 %x, -17
  %and_x_y = and i8 %x, 16
  call void @use.i8(i8 %and_x_y)
  %r = icmp ne i8 %and_x_y, %and_x_neg_y
  ret i1 %r
}

define i1 @test_eq_0_and_15_add_1(i8 %a) {
; CHECK-LABEL: @test_eq_0_and_15_add_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP0]], 15
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %add = add i8 %a, 1
  %and = and i8 %add, 15
  %cmp = icmp eq i8 %and, 0
  ret i1 %cmp
}

define i1 @test_ne_0_and_15_add_1(i8 %a) {
; CHECK-LABEL: @test_ne_0_and_15_add_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[TMP0]], 15
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %add = add i8 %a, 1
  %and = and i8 %add, 15
  %cmp = icmp ne i8 %and, 0
  ret i1 %cmp
}

define i1 @test_eq_0_and_15_add_3(i8 %a) {
; CHECK-LABEL: @test_eq_0_and_15_add_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP0]], 13
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %add = add i8 %a, 3
  %and = and i8 %add, 15
  %cmp = icmp eq i8 %and, 0
  ret i1 %cmp
}

define i1 @test_ne_0_and_15_add_3(i8 %a) {
; CHECK-LABEL: @test_ne_0_and_15_add_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[TMP0]], 13
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %add = add i8 %a, 3
  %and = and i8 %add, 15
  %cmp = icmp ne i8 %and, 0
  ret i1 %cmp
}

define i1 @test_eq_11_and_15_add_10(i8 %a) {
; CHECK-LABEL: @test_eq_11_and_15_add_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP0]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %add = add i8 %a, 10
  %and = and i8 %add, 15
  %cmp = icmp eq i8 %and, 11
  ret i1 %cmp
}

define i1 @test_ne_11_and_15_add_10(i8 %a) {
; CHECK-LABEL: @test_ne_11_and_15_add_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[TMP0]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %add = add i8 %a, 10
  %and = and i8 %add, 15
  %cmp = icmp ne i8 %and, 11
  ret i1 %cmp
}
