{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 2.6 (Begin/End Paradigm) of the
OpenGL 1.2.1 specs.
-}

module GL_BeginEnd (
   VertexMode(..),
   marshalVertexMode, unmarshalVertexMode,   -- internal use only
   begin, end,                               -- deprecated, use beginEnd
   beginEnd,
   edgeFlag,
   edgeFlagv                                 -- dangerous
) where

import Prelude          hiding ( lines )
import Foreign          ( Ptr )

import GL_Constants     ( gl_POINTS, gl_LINE_STRIP, gl_LINE_LOOP, gl_LINES,
                          gl_POLYGON, gl_TRIANGLE_STRIP, gl_TRIANGLE_FAN,
                          gl_TRIANGLES, gl_QUAD_STRIP, gl_QUADS )
import GL_BasicTypes    ( GLboolean, GLboolean_, marshalGLboolean, GLenum )

---------------------------------------------------------------------------
-- Section 2.6.1 (Begin and End Objects)

data VertexMode =
     Points
   | LineStrip
   | LineLoop
   | Lines
   | Polygon
   | TriangleStrip
   | TriangleFan
   | Triangles
   | QuadStrip
   | Quads
   deriving (Eq,Ord)

marshalVertexMode :: VertexMode -> GLenum
marshalVertexMode Points        = gl_POINTS
marshalVertexMode LineStrip     = gl_LINE_STRIP
marshalVertexMode LineLoop      = gl_LINE_LOOP
marshalVertexMode Lines         = gl_LINES
marshalVertexMode Polygon       = gl_POLYGON
marshalVertexMode TriangleStrip = gl_TRIANGLE_STRIP
marshalVertexMode TriangleFan   = gl_TRIANGLE_FAN
marshalVertexMode Triangles     = gl_TRIANGLES
marshalVertexMode QuadStrip     = gl_QUAD_STRIP
marshalVertexMode Quads         = gl_QUADS

unmarshalVertexMode :: GLenum -> VertexMode
unmarshalVertexMode mode
   | mode == gl_POINTS         = Points
   | mode == gl_LINE_STRIP     = LineStrip
   | mode == gl_LINE_LOOP      = LineLoop
   | mode == gl_LINES          = Lines
   | mode == gl_POLYGON        = Polygon
   | mode == gl_TRIANGLE_STRIP = TriangleStrip
   | mode == gl_TRIANGLE_FAN   = TriangleFan
   | mode == gl_QUAD_STRIP     = QuadStrip
   | mode == gl_QUADS          = Quads
   | otherwise                 = error "unmarshalVertexMode"

{-# DEPRECATED begin, end "use beginEnd instead" #-}
begin :: VertexMode -> IO ()
begin = glBegin . marshalVertexMode

foreign import "glBegin" unsafe glBegin :: GLenum -> IO ()
foreign import "glEnd" unsafe end :: IO ()

beginEnd :: VertexMode -> IO a -> IO a
beginEnd vertexMode command = do
   begin vertexMode
   val <- command
   end
   return val

---------------------------------------------------------------------------
-- Section 2.6.2 (Polygon Edges)

edgeFlag :: GLboolean -> IO ()
edgeFlag = glEdgeFlag . marshalGLboolean

foreign import "glEdgeFlag" unsafe glEdgeFlag :: GLboolean_ -> IO ()

-- dangerous
foreign import "glEdgeFlagv" unsafe edgeFlagv :: Ptr GLboolean_ -> IO ()
