{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 3.7 (Bitmaps) of the OpenGL 1.2.1 specs.
-}

module GL_Bitmaps (
   bitmap
) where

import Foreign          (Ptr)

import GL_BasicTypes    (GLsizei, GLfloat, GLubyte, WindowSize(..))
import GL_VertexSpec    (Vertex2(..))
import GL_CoordTrans    (Vector2(..))

---------------------------------------------------------------------------

bitmap :: WindowSize -> Vertex2 GLfloat -> Vector2 GLfloat -> Ptr GLubyte -> IO ()
bitmap (WindowSize width height) (Vertex2 xOrig yOrig) (Vector2 xMove yMove) ptr =
   glBitmap width height xOrig yOrig xMove yMove ptr

foreign import "glBitmap" unsafe glBitmap :: GLsizei -> GLsizei
                                          -> GLfloat -> GLfloat
                                          -> GLfloat -> GLfloat
                                          -> Ptr GLubyte -> IO ()
