{-
   Hello.hs (adapted from hello.c which is (c) Silicon Graphics, Inc)
   This file is part of HOpenGL - a binding of OpenGL and GLUT for Haskell.
   Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

   This is a simple, introductory OpenGL program.
-}

import GL
import GLUT

display :: DisplayAction
display = do
   -- clear all pixels
   clear [ColorBufferBit]

   -- draw white polygon (rectangle) with corners at
   -- (0.25, 0.25, 0.0) and (0.75, 0.75, 0.0)
   color (Color3 1.0 1.0 (1.0 :: GLfloat))
   beginEnd Polygon $ mapM_ vertex [
      Vertex3 0.25 0.25 0.0,
      Vertex3 0.75 0.25 0.0,
      Vertex3 0.75 0.75 0.0,
      Vertex3 0.25 0.75 (0.0 :: GLfloat)]

   -- don't wait!
   -- start processing buffered OpenGL routines
   flush

myInit :: IO () 
myInit = do
   -- select clearing color
   clearColor (Color4 0.0 0.0 0.0 0.0)

   -- initialize viewing values
   matrixMode Projection
   loadIdentity
   ortho 0.0 1.0 0.0 1.0 (-1.0) 1.0

{-
   Declare initial window size, position, and display mode
   (single buffer and RGBA).  Open window with "hello"
   in its title bar.  Call initialization routines.
   Register callback function to display graphics.
   Enter main loop and process events.
-}
main :: IO ()
main = do
   GLUT.init Nothing
   createWindow "hello" display [ Single, GLUT.Rgb ]
                (Just (WindowPosition 100 100))
                (Just (WindowSize     250 250))
   myInit
   mainLoop
