{-
   Unproject.hs (adapted from unproject.c which is (c) Silicon Graphics, Inc)
   This file is part of HOpenGL - a binding of OpenGL and GLUT for Haskell.
   Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

   When the left mouse button is pressed, this program 
   reads the mouse position and determines two 3D points 
   from which it was transformed. Very little is displayed.
-}

import System   ( ExitCode(..), exitWith )

import GL
import GLU
import GLUT

display :: DisplayAction
display = do
   clear [ColorBufferBit]
   flush

-- Change these values for a different transformation
reshape :: ReshapeAction
reshape screenSize@(WindowSize w h) = do
   viewport (Viewport (WindowPosition 0 0) screenSize)
   matrixMode Projection
   loadIdentity
   perspective 45.0 (fromIntegral w / fromIntegral h) 1.0 100.0
   matrixMode Modelview
   loadIdentity

mouse :: MouseAction
mouse LeftButton  Down (WindowPosition x y) = do
   vp@(Viewport _ (WindowSize _ height)) <- get VarViewport
   mvMatrix   <- get VarModelviewMatrix
   projMatrix <- get VarProjectionMatrix
   let realX = fromIntegral x
       realY = fromIntegral (height - y - 1)
   putStrLn ("Coordinates at cursor are " ++ show (realX, realY))
   Just (Vertex3 wx1 wy1 wz1) <- unProject (Vertex3 realX realY 0) mvMatrix projMatrix vp
   putStrLn ("World coords at z=0.0 are " ++ show (wx1,wy1,wz1))
   Just (Vertex3 wx2 wy2 wz2) <- unProject (Vertex3 realX realY 1) mvMatrix projMatrix vp
   putStrLn ("World coords at z=1.0 are " ++ show (wx2,wy2,wz2))
mouse RightButton Down _ = exitWith ExitSuccess
mouse _           _    _ = return ()

keyboard :: KeyboardAction
keyboard '\27' _ = exitWith ExitSuccess
keyboard _     _ = return ()

-- Open window, register input callback functions
main :: IO ()
main = do
   (progName, _args) <- GLUT.init Nothing
   createWindow progName display [ Single, GLUT.Rgb ]
                (Just (WindowPosition 100 100))
                (Just (WindowSize     500 500))
   reshapeFunc (Just reshape)
   keyboardFunc (Just keyboard)
   mouseFunc (Just mouse)
   mainLoop
