module SOEGraphics
	( module SOEGraphics
        -- Sigh, Hugs does not implement hiding accurately so the only way
        -- to export everything from GraphicsUtils except "Time" is to
        -- copy the (very long) export list from GraphicsUtils and delete
        -- one line.

        -- GraphicsUtils
        , openWindow        
        , clearWindow       
        , drawInWindow      

        , getWindowSize     
        , getLBP            
        , getRBP            
        , getButton         
        , getKey            
        , getKeyEx          

        , emptyGraphic      
        , overGraphic       
        , overGraphics      

        , withFont          
        , withTextColor     
        , withTextAlignment 
        , withBkColor       
        , withBkMode        
        , withPen           
        , withBrush         
        , withRGB           

        , Color(..)
        , colorList  
        , colorTable 
        , withColor  

        , par               
        , par_              
        , parMany           

        -- GraphicsDC
        , Point                      
        , Size                       
        , Angle                      
--        , Time                       
        , RGB                        
        , Alignment                  
        , HAlign(Left',Center,Right')
        , VAlign(Top,Baseline,Bottom)
        , BkMode(Opaque,Transparent)
        , Brush
        , Draw
        , mkBrush             
        , Pen
        , createPen           
        , mkPen               
        , Style(Solid,Dash,Dot,DashDot,DashDotDot,Null,InsideFrame)

        , selectFont          
        , setTextColor        
        , setTextAlignment    
        , setBkColor          
        , setBkMode           
        , selectPen           
        , selectBrush         
                              
        , bracket             
        , bracket_            
                              
        -- GraphicsFont       
        , Font                
        , createFont          
        , deleteFont          
                              
        -- GraphicsWindow     
        , runGraphics         
        , Title               
        , Window
        , RedrawMode(Unbuffered,DoubleBuffered)
        , openWindowEx        
                              
        , closeWindow         
        , getWindowRect       
        , getWindowEvent      
        , getWindowTick  
        , maybeGetWindowEvent 
                              
        , Graphic             
        , setGraphic          
        , getGraphic          
        , modGraphic          
        , directDraw          
        , getTime             

        -- GraphicsPicture
        , arc             
        , ellipse         
        , shearEllipse    
        , line            
        , polyline        
        , polygon         
        , polyBezier -- warning: not in X11
        , text            

        -- GraphicsRegion
        , Region
--        , emptyRegion     
        , rectangleRegion 
        , ellipseRegion   
        , polygonRegion   
        , intersectRegion 
        , unionRegion     
        , subtractRegion  
        , xorRegion    	  
--        , regionToGraphic 

        -- GraphicsEvent
        , Event(Key,Button,MouseMove,Resize,Closed)
        , char            
        , isDown          
        , pt              
        , isLeft          
	) where

import GraphicsUtils

----------------------------------------------------------------
-- Interface
----------------------------------------------------------------

createRectangle     :: Point -> Point -> Region
createPolygon       :: [Point] -> Region
createEllipse       :: Point -> Point -> Region
orRegion            :: Region -> Region -> Region
andRegion           :: Region -> Region -> Region
diffRegion          :: Region -> Region -> Region
drawRegion          :: Region -> Graphic
                    
drawGraphic         :: RedrawMode
drawBufferedGraphic :: RedrawMode

drawInWindowNow     :: Window -> Graphic -> IO ()
getEvent            :: Window -> IO Event

----------------------------------------------------------------
-- Implementation
----------------------------------------------------------------

createRectangle = rectangleRegion
createEllipse   = ellipseRegion
createPolygon   = polygonRegion
orRegion        = unionRegion
andRegion       = intersectRegion
diffRegion      = subtractRegion
drawRegion      = regionToGraphic

-- backwards compatability:
drawGraphic           = Unbuffered
drawBufferedGraphic   = DoubleBuffered

-- should have a different way to specify background color
-- drawBufferedGraphicBC :: RGB -> RedrawMode

drawInWindowNow = drawInWindow

getEvent = getWindowEvent

----------------------------------------------------------------
-- End
----------------------------------------------------------------
