module GraphicsFont
	( createFont
	, deleteFont
	) where

import qualified Xlib as X
import GraphicsDC
import Concurrent( readMVar )

----------------------------------------------------------------
-- Interface
----------------------------------------------------------------

createFont :: Point -> Angle -> Bool -> Bool -> String -> IO Font
deleteFont :: Font -> IO ()

----------------------------------------------------------------
-- Implementation
----------------------------------------------------------------

createFont (width, height) escapement bold italic family = do
  display <- readMVar displayRef
--  print fontName
  X.loadQueryFont display fontName
 where
  fontName = concatMap ('-':) fontParts
  fontParts = [ foundry
              , family
              , weight
              , slant
              , sWdth
              , adstyl
              , pxlsz
              , ptSz
              , resx
              , resy
              , spc
              , avgWidth
              , registry
              , encoding
              ]
  foundry  = "*" -- eg "adobe"
  -- family   = "*" -- eg "courier"
  weight   = if bold then "bold" else "medium"
  slant    = if italic then "i" else "r"
  sWdth    = "normal"
  adstyl   = "*"
  pxlsz    = show height
  ptSz     = "*"
  resx     = "75"
  resy     = "75"
  spc      = "*"
  avgWidth = show (width*10) -- not sure what unit they use
  registry = "*"
  encoding = "*"
  
  
deleteFont f = do
  display <- readMVar displayRef
  X.freeFont display f

----------------------------------------------------------------
-- End
----------------------------------------------------------------
