% -----------------------------------------------------------------------------
% $Id: Foreign.lhs,v 1.17 2001/03/22 03:51:12 hwloidl Exp $
%
% (c) The FFI task force, 2000
%

A collection of data types, classes, and functions for interfacing
with another programming language. This is only a convenience module
in the future, but currently it has the additional task of hiding
those entities exported from other modules, which are not part of the
FFI proposal.

\begin{code}
module Foreign
        ( module Int
	, module Word
	, module Ptr
	, module ForeignPtr
	, module StablePtr
        , module Storable
	, module MarshalAlloc
	, module MarshalArray
	, module MarshalError
	, module MarshalUtils

	-- DEPRECATED:
	, module Addr
	, module ForeignObj
        , module IOExts
        ) where
\end{code}

\begin{code}
import Int        	( Int8,  Int16,  Int32,  Int64 )
import Word		( Word8, Word16, Word32, Word64 )
import Ptr
import ForeignPtr
import StablePtr
import Storable
import MarshalAlloc
import MarshalArray
import MarshalError
import MarshalUtils

-- imports for deprecated features
--
import Addr		( Addr, nullAddr, alignAddr, plusAddr, minusAddr )
import ForeignObj       ( ForeignObj, newForeignObj, addForeignFinalizer
			, withForeignObj, touchForeignObj
			, makeForeignObj, foreignObjToPtr, foreignObjToAddr
			)
import IOExts		( freeHaskellFunctionPtr )
\end{code}
