% -----------------------------------------------------------------------------
% $Id: MarshalArray.lhs,v 1.5 2001/03/15 20:35:49 qrczak Exp $
%
% (c) The FFI task force, 2000
%

Marshalling support: routines allocating, storing, and retrieving Haskell
lists that are represented as arrays in the foreign language

\begin{code}
module MarshalArray (

  -- allocation
  --
  mallocArray,    -- :: Storable a => Int -> IO (Ptr a)
  mallocArray0,   -- :: Storable a => Int -> IO (Ptr a)

  allocaArray,    -- :: Storable a => Int -> (Ptr a -> IO b) -> IO b
  allocaArray0,   -- :: Storable a => Int -> (Ptr a -> IO b) -> IO b

  reallocArray,   -- :: Storable a => Ptr a -> Int -> IO (Ptr a)
  reallocArray0,  -- :: Storable a => Ptr a -> Int -> IO (Ptr a)

  -- marshalling
  --
  peekArray,      -- :: Storable a =>         Int -> Ptr a -> IO [a]
  peekArray0,     -- :: (Storable a, Eq a) => a   -> Ptr a -> IO [a]

  pokeArray,      -- :: Storable a =>      Ptr a -> [a] -> IO ()
  pokeArray0,     -- :: Storable a => a -> Ptr a -> [a] -> IO ()

  -- combined allocation and marshalling
  --
  newArray,       -- :: Storable a =>      [a] -> IO (Ptr a)
  newArray0,      -- :: Storable a => a -> [a] -> IO (Ptr a)

  withArray,      -- :: Storable a =>      [a] -> (Ptr a -> IO b) -> IO b
  withArray0,     -- :: Storable a => a -> [a] -> (Ptr a -> IO b) -> IO b

  -- destruction
  --
  destructArray,  -- :: Storable a =>         Int -> Ptr a -> IO ()
  destructArray0, -- :: (Storable a, Eq a) => a   -> Ptr a -> IO ()

  -- copying (argument order: destination, source)
  --
  copyArray,      -- :: Storable a => Ptr a -> Ptr a -> Int -> IO ()
  moveArray,      -- :: Storable a => Ptr a -> Ptr a -> Int -> IO ()

  -- finding the length
  --
  lengthArray0,   -- :: (Storable a, Eq a) => a -> Ptr a -> IO Int

  -- indexing
  --
  advancePtr      -- :: Storable a => Ptr a -> Int -> Ptr a
) where

import PrelMarshalArray
\end{code}
