module CleanStdFunc where


--	********************************************************************************
--	Clean to Haskell Standard Env library.
--	
--	CleanStdFunc defines all functions in Clean StdFunc (StdEnv) that are
--	not member of the Haskell Prelude. 
--	********************************************************************************


twice :: (a -> a) -> a -> a
twice f x = f (f x)

while :: (a -> Bool) -> (a -> a) -> a -> a
while p f x
	| p x       = while p f (f x)
	| otherwise = x

iter :: Int -> (a -> a) -> a -> a
iter 0 f x = x
iter n f x
	| n>0       = iter (n-1) f (f x)
	| otherwise = error "Error: Negative index given to iter."

{-	seq is reserved in Haskell Prelude for strict evaluation. Renamed to seq'
-}
seq' :: [s -> s] -> s -> s
seq' (f:fs) arg = seq' fs (f arg)
seq' [] arg     = arg

seqList :: [St s a] -> s -> ([a],s)
seqList (f:fs) s
	= (a:as,u)
	where
		(as,u) = seqList fs t 
		(a,t)  = f s
seqList [] s
	= ([],s)

type	St s a = s -> (a,s)
