module Osevent ( OSEvents, OSEvent, ClCrossCall_12.CrossCallInfo(..)
               , SchedulerEvent(..), MsgEvent(..), Receivertable.RecLoc(..)
               , osAppendEvents, osInsertEvents, osIsEmptyEvents, osRemoveEvent, osNewEvents
               , osNullEvent
               , osLongSleep, osNoSleep
               , osHandleEvents
               , setReplyInOSEvent
               , osEventIsUrgent
               , createOSActivateWindowEvent, createOSDeactivateWindowEvent
               , createOSActivateControlEvent, createOSDeactivateControlEvent
               , createOSLooseMouseEvent, createOSLooseKeyEvent
               ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Osevent contains all type definitions for OS dependent events.
--	********************************************************************************


import ClCrossCall_12
import Commondef
import Cutil_12 (btoi)
import Ostoolbox
import Ostypes
import Receivertable (RecLoc(..))
import Trace_12


oseventFatalError :: String -> String -> x
oseventFatalError function error
	= dumpFatalError function "Osevent" error


{-	The OSEvents environment keeps track of delayed events. 
-}
type	OSEvents
	= [SchedulerEvent]
--	SchedulerEvent and MsgEvent moved from Deviceevents
data	SchedulerEvent				-- A scheduler event is either:
 =	ScheduleOSEvent  !OSEvent ![Int]	-- a genuine OS event
 |	ScheduleMsgEvent !MsgEvent		-- a msg passing event
data	MsgEvent
 =	ASyncMessage
		{ asmRecLoc :: !RecLoc		-- The location of the intended receiver
		}
{- synchronous messages not yet incorporated
 |	SyncMessage      !SyncMessage
-}

instance Show SchedulerEvent where
	show (ScheduleOSEvent e _)  = "(ScheduleOSEvent " ++ showCcWm (ccMsg e) ++ ")"
	show (ScheduleMsgEvent m)   = "ScheduleMsgEvent"


osAppendEvents :: [SchedulerEvent] -> OSEvents -> OSEvents
osAppendEvents newEvents osEvents
	= osEvents ++ newEvents

osInsertEvents :: [SchedulerEvent] -> OSEvents -> OSEvents
osInsertEvents newEvents osEvents
	= newEvents ++ osEvents

osIsEmptyEvents :: OSEvents -> (Bool,OSEvents)
osIsEmptyEvents []
	= (True, [])
osIsEmptyEvents osEvents
	= (False,osEvents)

osRemoveEvent :: OSEvents -> (SchedulerEvent,OSEvents)
osRemoveEvent (osEvent:osEvents)
	= (osEvent,osEvents)
osRemoveEvent []
	= oseventFatalError "osRemoveEvent" "OSEvents argument is empty"

osNewEvents :: OSEvents
osNewEvents = []


type	OSEvent
	= CrossCallInfo
type	OSSleepTime	-- The max time the process allows multi-tasking
	= Int

osNullEvent :: OSEvent
osNullEvent = rq0Cci 0


osLongSleep :: OSSleepTime
osLongSleep = 2^15-1
osNoSleep :: OSSleepTime
osNoSleep = 0

osHandleEvents :: (s -> IO (Bool,s))
               -> (s -> IO (OSEvents,s))
               -> ((OSEvents,s) -> IO s)
--             -> (s -> IO (Int,s))		currently we don't try to be nice
               -> (SchedulerEvent -> s -> IO ([Int],s))
               -> s
               -> IO s
osHandleEvents isFinalState getOSEvents setOSEvents {-getSleepTime-} handleOSEvent state
	= do {
	--	trace "osHandleEvents: > isFinalState";
		(terminate,state1) <- isFinalState state;
		if	terminate
		then	{- trace "osHandleEvents: isFinalState --> True >" >> -} return state1
		else
		do {
	--		trace "osHandleEvents: isFinalState --> False >";
			(osEvents,state2)                  <- getOSEvents state1;
			let     (noDelayEvents,osEvents1)   = osIsEmptyEvents osEvents
			in
			if	noDelayEvents
			then	do {
					state3             <- setOSEvents (osEvents1,state2);
				--	(sleep,state4)      = getSleepTime state3
					let getEventCci     = rq2Cci ccRqDOMESSAGE (btoi False) osLongSleep	--(btoi (sleep\=osLongSleep)) sleep
					in
					do {
	--					trace "osHandleEvents: > issueCleanRequest (ccRqDOMESSAGE)";
						(_,state5) <- issueCleanRequest (rccitoevent handleOSEvent) getEventCci state3; --state4;
	--					trace ("osHandleEvents: issueCleanRequest (ccRqDOMESSAGE) >");
						osHandleEvents isFinalState getOSEvents setOSEvents {-getSleepTime-} handleOSEvent state5
					}
				}
			else	let	(osEvent,osEvents2) = osRemoveEvent osEvents1
				in
				do {
					state3             <- setOSEvents (osEvents2,state2);
	--				trace ("osHandleEvents: > handleOSEvent (delayed = "++show osEvent++")");
					(_,state4)         <- handleOSEvent osEvent state3;
	--				trace ("osHandleEvents: handleOSEvent (delayed = "++show osEvent++") >");
					osHandleEvents isFinalState getOSEvents setOSEvents {-getSleepTime-} handleOSEvent state4
				}
		}
	  }
	where
		rccitoevent :: (SchedulerEvent -> s -> IO ([Int],s)) -> OSEvent -> s -> IO (OSEvent,s)
		rccitoevent handleOSEvent osEvent state
			= do {
	--			trace ("osHandleEvents: > handleOSEvent ("++showCcWm (ccMsg osEvent)++")");
				(reply,state1) <- handleOSEvent (ScheduleOSEvent osEvent []) state;
	--			trace ("osHandleEvents: handleOSEvent ("++showCcWm (ccMsg osEvent)++") >");
				return (setReplyInOSEvent reply,state1)
			  }

setReplyInOSEvent :: [Int] -> CrossCallInfo
setReplyInOSEvent [] = return0Cci
setReplyInOSEvent [e1] = return1Cci e1
setReplyInOSEvent [e1,e2] = return2Cci e1 e2
setReplyInOSEvent [e1,e2,e3] = return3Cci e1 e2 e3
setReplyInOSEvent [e1,e2,e3,e4] = return4Cci e1 e2 e3 e4
setReplyInOSEvent [e1,e2,e3,e4,e5] = return5Cci e1 e2 e3 e4 e5
setReplyInOSEvent [e1,e2,e3,e4,e5,e6] = return6Cci e1 e2 e3 e4 e5 e6
setReplyInOSEvent otherwise             = oseventFatalError "setReplyInOSEvent" "number of reply codes > 6"

osEventIsUrgent :: SchedulerEvent -> Bool
osEventIsUrgent _ = True


{- createOS(Dea/A)ctivateWindowEvent creates the event the platform would generate for a genuine (de)activate event. -}
createOSActivateWindowEvent :: OSWindowPtr -> IO SchedulerEvent
createOSActivateWindowEvent wPtr = return (ScheduleOSEvent (rq1Cci ccWmACTIVATE wPtr) [])

createOSDeactivateWindowEvent :: OSWindowPtr -> IO SchedulerEvent
createOSDeactivateWindowEvent wPtr = return (ScheduleOSEvent (rq1Cci ccWmDEACTIVATE wPtr) [])

{- createOS(Dea/A)ctivateControlEvent creates the event the platform would generate for a genuine (de)activate event. -}
createOSActivateControlEvent :: OSWindowPtr -> OSWindowPtr -> IO SchedulerEvent
createOSActivateControlEvent wPtr cPtr = return (ScheduleOSEvent (rq2Cci ccWmSETFOCUS wPtr cPtr) [])

createOSDeactivateControlEvent :: OSWindowPtr -> OSWindowPtr -> IO SchedulerEvent
createOSDeactivateControlEvent wPtr cPtr = return (ScheduleOSEvent (rq2Cci ccWmKILLFOCUS wPtr cPtr) [])

{- createOSLoose(Mouse/Key)Event creates the event for reporting loss of mouse/keyboard input (virtual event). -}
createOSLooseMouseEvent :: OSWindowPtr -> OSWindowPtr -> IO SchedulerEvent
createOSLooseMouseEvent wPtr cPtr = return (ScheduleOSEvent (rq2Cci ccWmLOSTMOUSE wPtr cPtr) [])

createOSLooseKeyEvent :: OSWindowPtr -> OSWindowPtr -> IO SchedulerEvent
createOSLooseKeyEvent wPtr cPtr = return (ScheduleOSEvent (rq2Cci ccWmLOSTKEY wPtr cPtr) [])
