module Osrgn ( OSRgnHandle
             , osnewrgn, osnewrectrgn, osdisposergn, osrectrgn, ospolyrgn
             , ossectrgn, osunionrgn, osdiffrgn
             , osgetrgnbox, osisemptyrgn
             ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Osrgn contains OS operations to manage regions.
--	********************************************************************************


import Ostypes
import PictCCall_12
import RgnCCall_12


type	OSRgnHandle
	= Int
type	OSPointH
	= Int

--	Region creation and disposal operations.
osnewrgn :: IO OSRgnHandle
osnewrgn
	= winCreateRectRgn 0 0 1 1

osnewrectrgn :: Rect -> IO OSRgnHandle
osnewrectrgn (Rect {rleft=rleft,rtop=rtop,rright=rright,rbottom=rbottom})
	= winCreateRectRgn rleft rtop rright rbottom

osdisposergn :: OSRgnHandle -> IO ()
osdisposergn osrgn
	= winDeleteObject osrgn


--	Setting the shape of a Region.
osrectrgn :: Rect -> OSRgnHandle -> IO OSRgnHandle
osrectrgn (Rect {rleft=rleft,rtop=rtop,rright=rright,rbottom=rbottom}) osrgn
	= winSetRgnToRect rleft rtop rright rbottom osrgn

ospolyrgn :: (Int,Int) -> [(Int,Int)] -> OSRgnHandle -> IO OSRgnHandle
ospolyrgn base shape osrgn
	= do {
		osrgn1 <- winCombineRgn osrgn osrgn osrgn rgn_DIFF;
		if   len==0
		then return osrgn1
		else 
		do {
			shapeH <- winAllocPolyShape len;
			setpolyshape shapeH 0 base shape;
			prgn   <- winCreatePolygonRgn shapeH len winding;
			osrgn2 <- winCombineRgn osrgn1 prgn prgn rgn_COPY;
			winDeleteObject prgn;
			winFreePolyShape shapeH;
			return osrgn2
		}
	  }
	where
		len = length shape
		
		setpolyshape :: OSPointH -> Int -> (Int,Int) -> [(Int,Int)] -> IO ()
		setpolyshape shapeH i (x,y) ((vx,vy):vs)
			= winSetPolyPoint i x y shapeH >> setpolyshape shapeH (i+1) (x+vx,y+vy) vs
		setpolyshape _ _ _ _
			= return ()


--	Combining the shapes of two Regions into a new Region.
ossectrgn :: OSRgnHandle -> OSRgnHandle -> IO OSRgnHandle
ossectrgn rgn1 rgn2
	= do {
		rrgn  <- winCreateRectRgn 0 0 1 1;
		rrgn1 <- winCombineRgn rrgn rgn1 rgn2 rgn_AND;
		return rrgn1
	  }

osunionrgn :: OSRgnHandle -> OSRgnHandle -> IO OSRgnHandle
osunionrgn rgn1 rgn2
	= do {
		rrgn  <- winCreateRectRgn 0 0 1 1;
		rrgn1 <- winCombineRgn rrgn rgn1 rgn2 rgn_OR;
		return rrgn1
	  }

osdiffrgn :: OSRgnHandle -> OSRgnHandle -> IO OSRgnHandle
osdiffrgn rgn1 rgn2
	= do {
		rrgn  <- winCreateRectRgn 0 0 1 1;
		rrgn1 <- winCombineRgn rrgn rgn1 rgn2 rgn_DIFF;
		return rrgn1
	  }


--	Region property access functions.
osgetrgnbox :: OSRgnHandle -> IO (Bool,Rect)
osgetrgnbox rgn
	= do {
		(l,t, r,b, isRect,_) <- winGetRgnBox rgn;
		return (isRect,Rect {rleft=l,rtop=t,rright=r,rbottom=b})
	  }

osisemptyrgn :: OSRgnHandle -> IO Bool
osisemptyrgn rgn
	= do {
		(_,_,_,_,_,isempty) <- winGetRgnBox rgn;
		return isempty
	  }
