module Processevent (processEvent) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Processevent defines the DeviceEventFunction for the process device.
--	This function is placed in a separate module because it is platform dependent.
--	********************************************************************************


import ClCrossCall_12
import Commondef (dumpFatalError)
import Deviceevents
import IOstate
import Osevent
import Ostypes (osNoWindowPtr, OSWindowPtr)
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


processeventFatalError :: String -> String -> x
processeventFatalError function error
	= dumpFatalError function "Processevent" error


{-	processEvent filters the scheduler events that can be handled by this process device.
	processEvent assumes that it is not applied to an empty IOSt.
-}
processEvent :: IOSt IF_MVAR(,ps) -> SchedulerEvent -> IO (Bool,Maybe DeviceEvent,SchedulerEvent)

processEvent ioState schedulerEvent@(ScheduleOSEvent osEvent@(CrossCallInfo {ccMsg=msg}) _)
	| isProcessOSEvent msg
		= let
			(ioId,   ioState1) = ioStGetIOId    ioState
			(osdInfo,ioState2) = ioStGetOSDInfo ioState1
		  in
		  do {
			(myEvent,replyToOS,deviceEvent)
			        <- filterOSEvent osEvent osdInfo;
			let schedulerEvent1
			         = if   isJust replyToOS
			           then ScheduleOSEvent osEvent (fromJust replyToOS)
			           else schedulerEvent
			in  return (myEvent,deviceEvent,schedulerEvent1)
		     }
	| otherwise
		= return (False,Nothing,schedulerEvent)
	where
		isProcessOSEvent :: Int -> Bool
		isProcessOSEvent msg = msg==ccWmPROCESSCLOSE	-- ccWmDDEEXECUTE and ccWmPROCESSDROPFILES skipped

processEvent ioState schedulerEvent@(ScheduleMsgEvent _)
	= return (False,Nothing,schedulerEvent)


{-	filterOSEvent filters the OSEvents that can be handled by this process device.
		This implementation only handles the ccWmPROCESSCLOSE event (ccWmDDEEXECUTE and ccWmPROCESSDROPFILES skipped).
-}
filterOSEvent :: OSEvent -> OSDInfo -> IO (Bool,Maybe [Int],Maybe DeviceEvent)

filterOSEvent (CrossCallInfo {ccMsg=msg,p1=framePtr}) osdInfo
	| msg==ccWmPROCESSCLOSE
		= if   framePtr==getOSDInfoFramePtr osdInfo
		  then return (True, Nothing,Just ProcessRequestClose)
		  else return (False,Nothing,Nothing)
	
	| otherwise
		= processeventFatalError "filterOSEvent" "unmatched OSEvent"


getOSDInfoFramePtr :: OSDInfo -> OSWindowPtr
getOSDInfoFramePtr osdInfo
	= case getOSDInfoOSInfo osdInfo of
		Just info -> osFrame info
		_         -> osNoWindowPtr
