module Receiverevent where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Receiverevent defines the DeviceEventFunction for the receiver device.
--	This function is placed in a separate module because it is platform dependent.
--	********************************************************************************


import Deviceevents
import IOstate
import Osevent
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


{-	receiverEvent filters the appropriate events for the receiver device.
	These are only the message events (as long as receivers do not contain timers).
	receiverEvent assumes that it is not applied to an empty IOSt.
	
	Currently, in this implementation only asynchronous message events are supported.
-}
receiverEvent :: IOSt IF_MVAR(,ps) -> SchedulerEvent -> IO (Bool,Maybe DeviceEvent,SchedulerEvent)

receiverEvent ioState schedulerEvent@(ScheduleMsgEvent msgEvent)
	| ioid==rlIOId recloc && ReceiverDevice==rlDevice recloc
		= return (True,Just (ReceiverEvent msgEvent),schedulerEvent)
	| otherwise
		= return (False,Nothing,schedulerEvent)
	where
		(ioid,ioState1) = ioStGetIOId ioState
		recloc          = case msgEvent of
		                      (ASyncMessage _) -> asmRecLoc msgEvent
	--	                      (SyncMessage  _) -> smRecLoc  msgEvent

{-	TCP not yet incorporated
receiverEvent ioState schedulerEvent@(ScheduleOSEvent {ccMsg=CcWmINETEVENT,p1,p2,p3,p4} _)
	= (True, Just (InternetEvent (p1,p2,p3,p4)), schedulerEvent)
-}
receiverEvent ioState schedulerEvent
	= return (False,Nothing,schedulerEvent)
