/********************************************************************************************
	Clean OS Windows library module version 1.2.1.
	This module is part of the Clean Object I/O library, version 1.2.1, 
	for the Windows platform.
********************************************************************************************/

/********************************************************************************************
	About this module:
	Routines related to clipboard handling.
********************************************************************************************/
#include "cCrossCallClipboard_121.h"
#include "cCrossCall_121.h"


/*	Cross call procedure implementations.
	Eval<nr> corresponds with a CrossCallEntry generated by NewCrossCallEntry (nr,Eval<nr>).
*/
/*	CcRqCLIPBOARDHASTEXT had no implementation. It checks if the clipboard has a CF_TEXT item.
*/
void EvalCcRqCLIPBOARDHASTEXT (CrossCallInfo *pcci)		/* no arguments; bool result. */
{
	BOOL ok = IsClipboardFormatAvailable (CF_TEXT);
	MakeReturn1Cci (pcci,(int) ok);
}

void EvalCcRqSETCLIPBOARDTEXT (CrossCallInfo *pcci)		/* textptr; no result. */
{
	HANDLE hClipText;
	char *pClipText;
	int len;
	char *txt;

	txt = (char *) pcci->p1;

	len = lstrlen (txt);
	hClipText = GlobalAlloc (GMEM_MOVEABLE | GMEM_DDESHARE, len + 1);

	if (hClipText != NULL)
	{
		pClipText = GlobalLock (hClipText);
		lstrcpyn (pClipText, txt, len + 1);
		GlobalUnlock (hClipText);

		OpenClipboard (ghMainWindow);
		EmptyClipboard ();
		SetClipboardData (CF_TEXT, hClipText);
		CloseClipboard ();
	}
	MakeReturn0Cci (pcci);
}

void EvalCcRqGETCLIPBOARDTEXT (CrossCallInfo *pcci)			/* no params; string result. */
{
	HANDLE hClipText;
	char *pClipText;
	char *result;
	int len;

	OpenClipboard (ghMainWindow);
	hClipText = GetClipboardData (CF_TEXT);

	if (hClipText == NULL)
	{
		result = rmalloc (1);
		result[0] = '\0';
	}
	else
	{
		len = GlobalSize (hClipText) - 1;
		result = rmalloc (len + 1);

		pClipText = GlobalLock (hClipText);
		len = lstrlen (pClipText);

		lstrcpyn (result, pClipText, len + 1);
		GlobalUnlock (hClipText);
	}
	CloseClipboard ();

	MakeReturn1Cci (pcci, (int) result);
}

/*	CcRqGETCLIPBOARDCOUNT is used by Clean to retrieve current clipboard count.
*/
void EvalCcRqGETCLIPBOARDCOUNT (CrossCallInfo *pcci)	/* no arguments; gClipboardCount result. */
{
	MakeReturn1Cci (pcci, gClipboardCount);
};


/*	Install the cross call procedures in the gCrossCallProcedureTable of cCrossCall_121.
*/
int InstallCrossCallClipboard (int ios)
{
	CrossCallProcedureTable newTable;

	newTable = EmptyCrossCallProcedureTable ();
	AddCrossCallEntry (newTable, CcRqCLIPBOARDHASTEXT, EvalCcRqCLIPBOARDHASTEXT);
	AddCrossCallEntry (newTable, CcRqSETCLIPBOARDTEXT, EvalCcRqSETCLIPBOARDTEXT);
	AddCrossCallEntry (newTable, CcRqGETCLIPBOARDTEXT, EvalCcRqGETCLIPBOARDTEXT);
	AddCrossCallEntry (newTable, CcRqGETCLIPBOARDCOUNT,EvalCcRqGETCLIPBOARDCOUNT);
	AddCrossCallEntries (gCrossCallProcedureTable, newTable);

	return ios;
}
