module Controlaccess ( getcontrolstexts ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Controlaccess contains all read functions on controls.
--	********************************************************************************


import CleanStdList
import Commondef
import Id
import StdMaybe
import Windowaccess
import Wstateaccess


eqfst3id :: Id -> (Id,x,y) -> Bool
eqfst3id id1 (id2,_,_)
	= id1==id2


{-	Higher order access on [WElementHandle'].
	Although these functions have (... WElementHandle' ...) function arguments,
	these will only be applied to WItemHandle' alternatives.
-}

mapWElementHandles' :: (WElementHandle' -> [x]) -> [WElementHandle'] -> [x]
mapWElementHandles' f itemHs
	| isEmpty itemHs
		= []
	| otherwise
		= mapWElementHandle' f itemH ++ mapWElementHandles' f itemHs1
	where
		(itemH,itemHs1) = hdtl itemHs
		
		mapWElementHandle' :: (WElementHandle' -> [x]) -> WElementHandle' -> [x]
		mapWElementHandle' f (WRecursiveHandle' itemHs _)
			= mapWElementHandles' f itemHs
		mapWElementHandle' f itemH
			= f itemH

seekmapWElementHandle' :: (WElementHandle' -> (Bool,x)) -> x -> [WElementHandle'] -> (Bool,x)
seekmapWElementHandle' f x itemHs
	| isEmpty itemHs	= (False,x)
	| found			= (found,x1)
	| otherwise		= seekmapWElementHandle' f x1 itemHs1
	where
		(itemH,itemHs1)	= hdtl itemHs
		(found,x1)	= seekmapWItemHandle' f x itemH
		
		seekmapWItemHandle' :: (WElementHandle' -> (Bool,x)) -> x -> WElementHandle' -> (Bool,x)
		seekmapWItemHandle' f x (WRecursiveHandle' itemHs _)
			= seekmapWElementHandle' f x itemHs
		seekmapWItemHandle' f x itemH
			= f itemH

statemapWElementHandles' :: Cond x -> (WElementHandle' -> x -> x) -> x -> [WElementHandle'] -> x
statemapWElementHandles' cond f s itemHs
	| cond s         = s
	| isEmpty itemHs = s
	| otherwise      = statemapWElementHandles' cond f (statemapWElementHandle' cond f s itemH) itemHs1
	where
		(itemH,itemHs1) = hdtl itemHs
		
		statemapWElementHandle' :: Cond x -> (WElementHandle' -> x -> x) -> x -> WElementHandle' -> x
		statemapWElementHandle' cond f s (WRecursiveHandle' itemHs _)
			= statemapWElementHandles' cond f s itemHs
		statemapWElementHandle' _ f s itemH
			= f itemH s


{-	Access operations on WElementHandle'.
	Currently only getcontrolstexts is incorporated.
-}

getcontrolstexts :: [WElementHandle'] -> ([Id],[(Id,Bool,Maybe String)]) -> ([Id],[(Id,Bool,Maybe String)])
getcontrolstexts itemHs ids_texts
	= statemapWElementHandles' (isEmpty . fst) gettext ids_texts itemHs
	where
		gettext :: WElementHandle' -> ([Id],[(Id,Bool,Maybe String)]) -> ([Id],[(Id,Bool,Maybe String)])
		gettext itemH@(WItemHandle' _ _ _ _ _ _ _ _ _) ids_texts@(ids,texts)
			| isNothing (wItemId' itemH) = {-getcontrolstexts wItems'-} ids_texts
			| not hadId                  = {-getcontrolstexts wItems'-} ids_texts
			| not hastext                = {-getcontrolstexts wItems'-} (ids1,texts )
			| otherwise                  = {-getcontrolstexts wItems'-} (ids1,snd (creplace (eqfst3id itemId) (itemId,True,Just textline) texts))
			where
				info                 = wItemInfo' itemH
				itemId               = fromJust (wItemId' itemH)
				(hadId,ids1)         = removeCheck itemId ids
				(hastext,textline)   = case wItemKind' itemH of
				                       --  IsPopUpControl  -> (True,getPopUpText   (getWItemPopUpInfo'  info))
				                           IsTextControl   -> (True,textInfoText   (getWItemTextInfo'   info))
				                           IsEditControl   -> (True,editInfoText   (getWItemEditInfo'   info))
				                           IsButtonControl -> (True,buttonInfoText (getWItemButtonInfo' info))
				                       --  _               -> (False,undef)
				
			{-	getPopUpText :: PopUpInfo' -> String
				getPopUpText popUpInfo@(PopUpInfo {popUpInfoEdit',popUpInfoItems'})
					| isNothing popUpInfoEdit'
						= if   isEmpty popUpInfoItems'
						  then ""
						  else popUpInfoItems'!!(max 0 (popUpInfoIndex' popUpInfo - 1))
					| otherwise
						= popUpEditText (fromJust popUpInfoEdit')
			-}
