module Controlcreate ( createControls ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Controlcreate contains all control creation functions.
--	********************************************************************************


import Commondef
import Controllayout
import Controlvalidate
--import Ostooltip
import Oswindow
import StdControlAttribute
import Windowaccess
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


{-	createControls generates the proper system resources for all given WElementHandles of the window.
-}
createControls :: OSWindowMetrics -> Maybe Id -> Maybe Id -> Bool -> OSWindowPtr -> [WElementHandle IF_MVAR(,ls ps)]
                                                                              -> IO [WElementHandle IF_MVAR(,ls ps)]
createControls wMetrics okId cancelId ableContext wPtr itemHs
	= sequenceMap (createWElementHandle wMetrics okId cancelId True ableContext zero wPtr) itemHs


{-	toOKorCANCEL okId cancelId controlId
		checks if the optional Id of a control (controlId) is the OK control (OK), the CANCEL control (CANCEL), or a normal button (NORMAL).
-}
toOKorCANCEL :: Maybe Id -> Maybe Id -> Maybe Id -> OKorCANCEL
toOKorCANCEL okId cancelId maybeControlId
	= case maybeControlId of
		Just id -> if      isJust okId     && fromJust okId    ==id then OK
		           else if isJust cancelId && fromJust cancelId==id then CANCEL
		                                                            else NORMAL
		nothing -> NORMAL


{-	createWElementHandle generates the proper system resources.
-}
createWElementHandle :: OSWindowMetrics -> Maybe Id -> Maybe Id -> Bool -> Bool -> Point2 -> OSWindowPtr -> WElementHandle IF_MVAR(,ls ps)
                                                                                                     -> IO (WElementHandle IF_MVAR(,ls ps))

createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr (WListLSHandle itemHs)
	= do {	itemHs1 <- sequenceMap (createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr) itemHs;
	  	return (WListLSHandle itemHs1)
	  }

#if MVAR
#else
createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr (WExtendLSHandle addLS itemHs)
	= do {	itemHs1 <- sequenceMap (createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr) itemHs;
		return (WExtendLSHandle addLS itemHs1)
	  }

createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr (WChangeLSHandle newLS itemHs)
	= do {	itemHs1 <- sequenceMap (createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr) itemHs;
	  	return (WChangeLSHandle newLS itemHs1)
	  }
#endif

createWElementHandle wMetrics okId cancelId showContext ableContext parentPos wPtr itemH@(WItemHandle {wItemKind=wItemKind})
{-	| wItemKind==IsRadioControl
		= do {
			(items,_) <- stateMapM (createRadioItem show able (toTuple parentPos) wPtr (radioIndex radioInfo)) (radioItems radioInfo) 1;
			return itemH {wItemInfo=radioInfo {radioItems=items}}
		  }
		where
			radioInfo = getWItemRadioInfo (wItemInfo itemH)
			
			createRadioItem :: Bool -> Bool -> (Int,Int) -> OSWindowPtr -> Index -> RadioItemInfo IF_MVAR(,ls ps) -> Index
			                                                                 -> IO (RadioItemInfo IF_MVAR(,ls ps),   Index)
			createRadioItem show able parentPos wPtr index item@(RadioItemInfo {radioItem=(title,_,_),radioItemPos=pos,radioItemSize=size} itemNr
				= do {
					radioPtr <- osCreateRadioControl wPtr parentPos title show able (toTuple pos) (toTuple size) (index==itemNr) (itemNr==1);
					let itemH1 = itemH {radioItemPtr=radioPtr}
					in  if   hasTip
					    then {- osAddControlToolTip wPtr radioPtr tip >> -} return (itemH1,itemNr+1)
					    else return (itemH1,itemNr+1)
				  }
-}	
{-	| wItemKind==IsCheckControl
		= do {
			(items,_) <- stateMapM (createCheckItem show able (toTuple parentPos) wPtr) (checkItems checkInfo) 1;
			return itemH {wItemInfo=checkInfo {checkItems=items}}
		  }
		where
			checkInfo = getWItemCheckInfo (wItemInfo itemH)
			
			createCheckItem :: Bool -> Bool -> (Int,Int) -> OSWindowPtr -> CheckItemInfo IF_MVAR(,ls ps) -> Index
			                                                        -> IO (CheckItemInfo IF_MVAR(,ls ps),   Index)
			createCheckItem show able parentPos wPtr item@(CheckItemInfo {checkItem=(title,_,mark,_),checkItemPos=pos,checkItemSize=size}) itemNr
				= do {
					checkPtr <- osCreateCheckControl wPtr parentPos title show able (toTuple pos) (toTuple size) (marked mark) (itemNr==1);
					let itemH1 = item {checkItemPtr=checkPtr}
					in  if   hasTip
					    then {- osAddControlToolTip wPtr checkPtr tip >> -} return (itemH1,itemNr+1)
					    else return (itemH1,itemNr+1)
				  }
-}	
{-	| wItemKind==IsPopUpControl
		= do {
			(popUpPtr,editPtr) <- osCreateEmptyPopUpControl wPtr (toTuple parentPos) show able pos' size' (length items) isEditable;
			stateMap2M (appendPopUp popUpPtr (popUpInfoIndex info)) items 1;
			let info1  = if isEditable then info {popUpInfoEdit=Just {popUpEditText="",popUpEditPtr=editPtr}} else info
			    itemH1 = itemH {wItemPtr=popUpPtr, wItemInfo=PopUpInfo info}
			in  if   hasTip
			    then {- osAddControlToolTip wPtr popUpPtr tip >> -} return itemH1
			    else return itemH1
		  }
		where
			info            = getWItemPopUpInfo wItemInfo itemH
			items           = popUpInfoItems info
			isEditable      = contains isControlKeyboard atts
			
			appendPopUp :: OSWindowPtr -> Index -> PopUpControlItem IF_MVAR(,ls ps) -> Int -> IO Int
			appendPopUp popUpPtr index (title,_) itemNr
				= osCreatePopUpControlItem popUpPtr (-1) ableContext title (index==itemNr) >> return itemNr+1
-}	
{-	| wItemKind==IsSliderControl
		= do {
			sliderPtr <- osCreateSliderControl wPtr (toTuple parentPos) show able (direction==Horizontal) pos' size' 
			                                   (osMin,osThumb,osMax,osThumbSize);
			let itemH1 = itemH {wItemPtr=sliderPtr}
			in  if   hasTip
			    then {- osAddControlToolTip wPtr sliderPtr tip >> -} return itemH1
			    else return itemH1
		  }
		where
			info                              = getWItemSliderInfo (wItemInfo itemH)
			direction                         = sliderInfoDir info
			sliderState                       = sliderInfoState info
			min                               = sliderMin sliderState
			max                               = sliderMax sliderState
			(osMin,osThumb,osMax,osThumbSize) = toOSscrollbarRange (min,sliderThumb sliderState,max) 0
-}	
	| wItemKind==IsTextControl
		= let	title = textInfoText $ getWItemTextInfo $ wItemInfo itemH
		  in	do {
				textPtr <- osCreateTextControl wPtr (toTuple parentPos) title show pos' size';
				let itemH1 = itemH {wItemPtr=textPtr}
				in  {-if   hasTip
				    then osAddControlToolTip wPtr textPtr tip >> return itemH1
				    else-} return itemH1
			}
	
	| wItemKind==IsEditControl
		= let	keySensitive = contains isControlKeyboard atts
			text         = editInfoText $ getWItemEditInfo $ wItemInfo itemH
		  in	do {
				editPtr <- osCreateEditControl wPtr (toTuple parentPos) text show able keySensitive pos' size';
				let itemH1 = itemH {wItemPtr=editPtr}
				in  {-if   hasTip
				    then osAddControlToolTip wPtr editPtr tip >> return itemH1
				    else-} return itemH1
			}
	
	| wItemKind==IsButtonControl
		= let	itemId     = wItemId   itemH
			okOrCancel = toOKorCANCEL okId cancelId itemId
			title      = buttonInfoText $ getWItemButtonInfo $ wItemInfo itemH
		  in	do {
				buttonPtr <- osCreateButtonControl wPtr (toTuple parentPos) title show able pos' size' okOrCancel;
				let itemH1 = itemH {wItemPtr=buttonPtr}
				in  {-if   hasTip
				    then osAddControlToolTip wPtr buttonPtr tip >> return itemH1
				    else-} return itemH1
			}
	
{-	| wItemKind==IsCustomButtonControl
		= do {
			buttonPtr <- osCreateCustomButtonControl wPtr (toTuple parentPos) show able pos' size' okOrCancel;
			let itemH1 = itemH {wItemPtr=buttonPtr}
			in  if   hasTip
			    then {- osAddControlToolTip wPtr buttonPtr tip >> -} return itemH1
			    else return itemH1
		  }
		where
			itemId     = wItemId itemH
			okOrCancel = toOKorCANCEL okId cancelId itemId
-}	
{-	| wItemKind==IsCustomControl
		= do {
			customPtr <- osCreateCustomControl wPtr (toTuple parentPos) show able pos' size';
			let itemH1 = itemH {wItemPtr=customPtr}
			in  if   hasTip
			    then {- osAddControlToolTip wPtr customPtr tip >> -} return itemH1
			    else return itemH1
		  }
-}	
{-	| wItemKind==IsCompoundControl
		= do {
			(compoundPtr,hPtr,vPtr) <- osCreateCompoundControl wMetrics wPtr (toTuple parentPos) show able False pos' size' hScroll vScroll;
			itemHs                  <- stateMapM (createWElementHandle wMetrics okId cancelId show able pos compoundPtr) (wItems itemH);
			let compoundInfo = info { compoundHScroll=fmap (setScrollbarPtr hPtr) (compoundHScroll info)
			                        , compoundVScroll=fmap (setScrollbarPtr vPtr) (compoundVScroll info)
			                        }
			    itemH1       = itemH {wItemInfo=compoundInfo,wItemPtr=compoundPtr,wItems=itemHs}
			in  if   hasTip
			    then {- osAddControlToolTip wPtr compoundPtr tip >> -} return itemH1
			    else return itemH1
		  }
		where
			info                    = getWItemCompoundInfo (wItemInfo itemH)
			domainRect              = compoundDomain info
			origin                  = compoundOrigin info
			(hasHScroll,hasVScroll) = (isJust (compoundHScroll info),isJust (compoundVScroll info))
			visScrolls              = osScrollbarsAreVisible wMetrics domainRect size' (hasHScroll,hasVScroll)
			(Size {w=w',h=h'})      = rectSize (getCompoundContentRect wMetrics visScrolls (sizeToRect size))
			
			hScroll :: ScrollbarInfo
			hScroll
				| hasHScroll    = ScrollbarInfo {cbiHasScroll=True, cbiPos=toTuple (scrollItemPos hInfo),cbiSize=toTuple hSize,cbiState=hState}
				| otherwise     = ScrollbarInfo {cbiHasScroll=False,cbiPos=undef,cbiSize=undef,cbiState=undef}
				where
					hInfo   = fromJust (compoundHScroll info)
					hSize   = scrollItemSize hInfo
					hState  = toOSscrollbarRange (rleft domainRect,x origin,rright domainRect) w'
			
			vScroll :: ScrollbarInfo
			vScroll
				| hasVScroll    = ScrollbarInfo {cbiHasScroll=True, cbiPos=toTuple (scrollItemPos vInfo),cbiSize=toTuple vSize,cbiState=vState}
				| otherwise     = ScrollbarInfo {cbiHasScroll=False,cbiPos=undef,cbiSize=undef,cbiState=undef}
				where
					vInfo   = fromJust (compoundVScroll info)
					vSize   = scrollItemSize vInfo
					vState  = toOSscrollbarRange (rtop domainRect,y origin,rbottom domainRect) h'
	
			setScrollbarPtr :: OSWindowPtr -> ScrollInfo -> ScrollInfo
			setScrollbarPtr scrollPtr info
				= info {scrollItemPtr=scrollPtr}
-}
{-	| wItemKind==IsLayoutControl
		= do {
			itemHs <- stateMapM (createWElementHandle wMetrics okId cancelId show able parentPos wPtr) wItems;
			return itemH {wItems=itemHs}
		  }
-}
	| otherwise
		= return itemH
	where
		show            = showContext -- && wItemShow   itemH
		able            = ableContext -- && wItemSelect itemH
		pos             = wItemPos itemH
		size            = wItemSize itemH
		pos'            = toTuple pos
		size'           = toTuple size
		atts            = wItemAtts itemH
	--	(hasTip,tipAtt) = cselect isControlTip undef atts
	--	tip             = getControlTipAtt tipAtt
