module Controlinternal (setcontroltexts) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Controlinternal contains all control update functions.
--	********************************************************************************


import CleanStdMisc
import Commondef
import Oswindow
import Wstateaccess
import StdControlAttribute
import Controlvalidate
import Windowaccess (getCompoundContentRect, getWindowContentRect)


--	General occurrence tests on Id.

maybeRemoveCheck :: (Eq x) => Maybe x -> [x] -> (Bool,[x])
maybeRemoveCheck (Just id) ids
	= removeCheck id ids
maybeRemoveCheck nothing ids
	= (False,ids)

removeOnIdOfPair :: Maybe Id -> [(Id,x)] -> (Bool,(Id,x),[(Id,x)])
removeOnIdOfPair (Just id) id_args
	= remove (\(id',_)->id'==id) undef id_args
removeOnIdOfPair nothing id_args
	= (False,undef,id_args)

removeOnIdOfTriple :: Maybe Id -> [(Id,x,y)] -> (Bool,(Id,x,y),[(Id,x,y)])
removeOnIdOfTriple (Just id) id_args
	= remove (\(id',_,_)->id'==id) undef id_args
removeOnIdOfTriple nothing id_args
	= (False,undef,id_args)


{-	getContentRect returns the content rect of the window. 
	Because WindowInfo is not yet incorporated it boils down to the second alternative.
-}
getContentRect :: OSWindowMetrics -> {-WindowInfo -> -} Size -> Rect
{-
getContentRect wMetrics (WindowInfo wInfo) size
	= getWindowContentRect wMetrics visScrolls (sizeToRect size)
	where
		domainRect = windowDomain wInfo
		hasScrolls = (isJust (windowHScroll wInfo),isJust (windowVScroll wInfo))
		visScrolls = osScrollbarsAreVisible wMetrics domainRect (toTuple size) hasScrolls
-}
getContentRect _ {-NoWindowInfo-} size
	= sizeToRect size

{-	Calculate the intersection of the given Rect with the content of a CompoundControl.
-}
{-
intersectRectContent :: OSWindowMetrics -> Rect -> CompoundInfo -> Point2 -> Size -> Rect
intersectRectContent wMetrics clipRect info itemPos itemSize
	= intersectRects clipRect contentRect
	where
		hasScrolls  = (isJust (compoundHScroll info),isJust (compoundVScroll info))
		domainRect  = compoundDomain info
		itemRect    = posSizeToRect itemPos itemSize
		visScrolls  = osScrollbarsAreVisible wMetrics domainRect (toTuple itemSize) hasScrolls
		contentRect = getCompoundContentRect wMetrics visScrolls itemRect
-}


--	Set the text of the controls and provide proper feedback.

setcontroltexts :: [(Id,String)] -> OSWindowMetrics -> OSWindowPtr -> WindowHandle' -> IO WindowHandle'
setcontroltexts id_texts wMetrics wPtr wH'	-- whWindowInfo' not yet incorporated
	= do {
		(itemHs,_) <- setArgWElements (setControlText wMetrics wPtr True clipRect) (whItems' wH') id_texts;
		return wH' {whItems'=itemHs}
	  }
	where
		clipRect = getContentRect wMetrics {-whWindowInfo'-} (whSize' wH')
		
		setControlText :: OSWindowMetrics -> OSWindowPtr -> Bool -> Rect -> WElementHandle' -> [(Id,String)] -> IO (WElementHandle',[(Id,String)])
		
		setControlText wMetrics wPtr shownContext clipRect itemH@(WItemHandle' {wItemKind'=IsEditControl}) id_texts
			| not found
				= return (itemH,id_texts1)
			| otherwise
				= osSetEditControlText wPtr (wItemPtr' itemH) clipRect itemRect shownContext1 text >> return (itemH1,id_texts1)
			where
				(found,id_text,id_texts1) = removeOnIdOfPair (wItemId' itemH) id_texts
				shownContext1             = shownContext -- && wItemShow' itemH
				(_,text)                  = id_text
				editInfo                  = getWItemEditInfo' $ wItemInfo' itemH
				itemH1                    = itemH {wItemInfo'=EditInfo' editInfo {editInfoText=text}}
				itemRect                  = posSizeToRect (wItemPos' itemH) (wItemSize' itemH)
		
		setControlText wMetrics wPtr shownContext clipRect itemH@(WItemHandle' {wItemKind'=IsTextControl}) id_texts
			| not found
				= return (itemH,id_texts1)
			| otherwise
				= osSetTextControlText wPtr (wItemPtr' itemH) clipRect itemRect shownContext1 text >> return (itemH1,id_texts1)
			where
				(found,id_text,id_texts1) = removeOnIdOfPair (wItemId' itemH) id_texts
				(_,text)                  = id_text
				shownContext1             = shownContext -- && wItemShow' itemH
				textInfo                  = getWItemTextInfo' $ wItemInfo' itemH
				itemH1                    = itemH {wItemInfo'=TextInfo' textInfo {textInfoText=text}}
				itemRect                  = posSizeToRect (wItemPos' itemH) (wItemSize' itemH)
		
		setControlText wMetrics wPtr _ clipRect itemH@(WItemHandle' {wItemKind'=IsButtonControl}) id_texts
			| not found
				= return (itemH,id_texts1)
			| otherwise
				= osSetButtonControlText wPtr (wItemPtr' itemH) clipRect (validateControlTitle text) >> return (itemH1,id_texts1)
			where
				(found,id_text,id_texts1) = removeOnIdOfPair (wItemId' itemH) id_texts
				(_,text)                  = id_text
				buttonInfo                = getWItemButtonInfo' $ wItemInfo' itemH
				itemH1                    = itemH {wItemInfo'=ButtonInfo' buttonInfo {buttonInfoText=text}}
		
	{-	setControlText wMetrics wPtr shownContext clipRect itemH@(WItemHandle' {wItemKind'=IsCompoundControl}) id_texts
			= do {
				(itemHs,id_texts1) <- setArgWElements (setControlText wMetrics wPtr shownContext1 clipRect1) (wItems' itemH) id_texts;
				return (itemH {wItems'=itemHs},id_texts1)
			  }
			where
				info                      = getWItemCompoundInfo' $ wItemInfo' itemH
				clipRect1                 = intersectRectContent wMetrics clipRect info (wItemPos' itemH) (wItemSize' itemH)
				shownContext1             = shownContext -- && wItemShow' itemH
	-}	
	{-	setControlText wMetrics wPtr shownContext clipRect itemH@(WItemHandle' {wItemKind'=IsLayoutControl}) id_texts
			= do {
				(itemHs,id_texts1) <- setArgWElements (setControlText wMetrics wPtr shownContext1 clipRect1) (wItems' itemH) id_texts;
				return ({itemH & wItems'=itemHs},id_texts1)
			  }
			where
				clipRect1                 = intersectRects clipRect (posSizeToRect (wItemPos' itemH) (wItemSize' itemH))
				shownContext1             = shownContext -- && wItemShow' itemH
	-}	
	{-	setControlText _ _ _ _ itemH id_texts
			= return (itemH,id_texts)
	-}
