module Controlvalidate ( validateControlTitle, getWElementControlIds
                       , noDuplicateControlIds, disjointControlIds
                       , controlIdsAreConsistent
                       ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Controlvalidate contains control validation functions.
--	********************************************************************************


import Commondef
import Id
import Oswindow
import Windowhandle
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


controlvalidateFatalError :: String -> String -> x
controlvalidateFatalError function error
	= dumpFatalError function "Controlvalidate" error


--	Validate the title of a control.

validateControlTitle :: String -> String
validateControlTitle string
	= removeSpecialChars osControlTitleSpecialChars string


--	Collect all Ids of the given [WElementHandle].

#if MVAR
getWElementControlIds :: [WElementHandle] -> ([Id],[WElementHandle])
#else
getWElementControlIds :: [WElementHandle ls ps] -> ([Id],[WElementHandle ls ps])
#endif
getWElementControlIds (itemH:itemHs)
	= (ids1++ids2,itemH1:itemHs1)
	where
		(ids1,itemH1)  = getWElementIds itemH
		(ids2,itemHs1) = getWElementControlIds itemHs
		
#if MVAR
		getWElementIds :: WElementHandle -> ([Id],WElementHandle)
#else
		getWElementIds :: (WElementHandle ls ps) -> ([Id],WElementHandle ls ps)
#endif
		
		getWElementIds itemH@(WItemHandle {wItemId=id})
			| isJust id = ([fromJust id],itemH)
			| otherwise = ([],           itemH)
		
		getWElementIds (WListLSHandle itemHs)
			= let (ids,itemHs1) = getWElementControlIds itemHs
			  in  (ids,WListLSHandle itemHs1)
		
#if MVAR
#else
		getWElementIds (WExtendLSHandle addLS itemHs)
			= let (ids,itemHs1) = getWElementControlIds itemHs
			  in  (ids,WExtendLSHandle addLS itemHs1)
		
		getWElementIds (WChangeLSHandle newLS itemHs)
			= let (ids,itemHs1) = getWElementControlIds itemHs
			  in  (ids,WChangeLSHandle newLS itemHs1)
#endif
getWElementControlIds _
	= ([],[])


--	Id occurrence checks on [WElementHandle ls ps] and [WElementHandle`].

--	There are no duplicate (ControlId id) attributes:

#if MVAR
noDuplicateControlIds :: [WElementHandle] -> (Bool,[WElementHandle])
#else
noDuplicateControlIds :: [WElementHandle ls ps] -> (Bool,[WElementHandle ls ps])
#endif
noDuplicateControlIds itemHs
	= let (ids,itemHs1) = getWElementControlIds itemHs
	  in  (noDuplicates ids, itemHs1)

--	The list of Ids does not occur in any (ControlId id) attribute:

#if MVAR
disjointControlIds :: [Id] -> [WElementHandle] -> (Bool,[WElementHandle])
#else
disjointControlIds :: [Id] -> [WElementHandle ls ps] -> (Bool,[WElementHandle ls ps])
#endif
disjointControlIds ids itemHs
	= let (ids',itemHs1) = getWElementControlIds itemHs
	  in  (disjointLists ids ids',itemHs1)


{-	controlIdsAreConsistent checks whether the WElementHandles contain (R(2))Ids that have already been
	associated with open receivers or other I/O objects and if there are no duplicate Ids. 
	The ReceiverTable is not changed if there are duplicate (R(2))Ids; otherwise all (R(2))Ids have been bound.
-}
#if MVAR
controlIdsAreConsistent :: SystemId -> Id -> [WElementHandle] -> IdTable
                                    -> (Bool,[WElementHandle],IdTable)
#else
controlIdsAreConsistent :: SystemId -> Id -> [WElementHandle ls ps] -> IdTable
                                    -> (Bool,[WElementHandle ls ps],IdTable)
#endif
controlIdsAreConsistent ioId wId itemHs it
	| not (okMembersIdTable ids it)
		= (False,itemHs1,it)
	| not ok
		= controlvalidateFatalError "controlIdsAreConsistent" "could not add all Ids to IdTable"
	| otherwise
		= (True,itemHs1,it1)
	where
		(ids,itemHs1) = getWElementControlIds itemHs
		idParent      = IdParent {idpIOId=ioId,idpDevice=WindowDevice,idpId=wId}
		(ok,it1)      = addIdsToIdTable [(id,idParent) | id<-ids] it
