module Deviceevents (module Deviceevents, Osevent.MsgEvent(..)) where

--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Deviceevents contains all type definitions for OS independent events.
--	********************************************************************************


import Osevent
import Ostypes(Rect, OSWindowPtr)
import StdIOCommon
import Windowhandle(WIDS(..))


data	DeviceEvent
 --	Receiver events:
 =	ReceiverEvent           !MsgEvent			-- A (bi/uni)directional (a)synchronous message event
 --	Window/Dialog events:
 |	ControlKeyboardAction   !ControlKeyboardActionInfo	-- Keyboard action in a control
 |	ControlSelection        !ControlSelectInfo		-- Control has been selected
 |	WindowActivation        !WIDS				-- Window with id has been made activate
 |	WindowCreateControls    !WIDS				-- Window with id can create its controls
 |	WindowDeactivation      !WIDS				-- Window with id has been made inactivate
 |	WindowInitialise        !WIDS				-- Window with id can evaluate its initialisation action
 |	WindowRequestClose      !WIDS				-- Window with id should be closed
 |	WindowSizeAction        !WindowSizeActionInfo		-- Window has obtained a new size
 |	WindowUpdate            !UpdateInfo			-- Window and its controls should be updated
 --	Process events:
 |	ProcessInitialise					-- The initial event that allows process initialisation
 |	ProcessRequestClose					-- The process should be closed
data	ControlKeyboardActionInfo
 =	ControlKeyboardActionInfo
		{ ckWIDS          :: !WIDS			-- The Id/Ptr of the window/dialogue that contains the control
		, ckItemNr        :: !Int			-- The wItemNr  of the control
		, ckItemPtr       :: !OSWindowPtr		-- The wItemPtr of the control
		, ckKeyboardState :: !KeyboardState		-- The KeyboardState of the action
		}
data	ControlSelectInfo
 =	ControlSelectInfo
		{ csWIDS          :: !WIDS			-- The Id/Ptr of the window/dialogue that contains the control
		, csItemNr        :: !Int			-- The wItemNr  of the selected control
		, csItemPtr       :: !OSWindowPtr		-- The wItemPtr of the selected control
		, csMoreData      :: !Int			-- Additional data (index in case of PopUpControls; otherwise zero)
		, csModifiers     :: !Modifiers			-- The modifiers that were active when the control was selected
		}
data	WindowSizeActionInfo
 =	WindowSizeActionInfo
		{ wsWIDS          :: !WIDS			-- The Id/Ptr of the window
		, wsSize          :: !Size			-- The new size of the window (including scrollbars)
		, wsUpdateAll     :: !Bool			-- The complete content of the window must be redrawn
		}
data	UpdateInfo
 =	UpdateInfo
		{ updWIDS         :: !WIDS			-- The Id of the window/dialogue to be updated
		, updWindowArea   :: !Rect			-- The area of the window/dialogue to be updated (case zero, no update)
		, updControls     :: ![ControlUpdateInfo]	-- For each control to be updated: its item nr and area (in window coordinates)
	--	, updGContext     :: !Maybe OSPictContext	-- The graphics context to be used
		, updGContext     :: !(Maybe Int)		-- The graphics context to be used
		}
data	ControlUpdateInfo
 =	ControlUpdateInfo
		{ cuItemNr        :: !Int			-- The wItemNr of the control
		, cuItemPtr       :: !OSWindowPtr		-- The wItemPtr to the control (can be OSNoWindowPtr)
		, cuArea          :: !Rect			-- The update area of the control (in window coordinates)
		}
