module Devicesystemstate (module Devicesystemstate, module Device, module Windowhandle) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Devicesystemstate defines the device administration types and unwrapper 
--	functions.
--	********************************************************************************


import Device
import Receiverhandle
import Windowhandle
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


data	DeviceSystemState IF_MVAR(,ps)
	= ReceiverSystemState IF_MVAR(ReceiverHandles,(ReceiverHandles ps))
	| WindowSystemState   IF_MVAR(WindowHandles,(WindowHandles ps))

toDevice :: DeviceSystemState IF_MVAR(,ps) -> Device
toDevice (ReceiverSystemState _) = ReceiverDevice
toDevice (WindowSystemState   _) = WindowDevice


receiverSystemStateGetReceiverHandles :: DeviceSystemState IF_MVAR(,ps) -> ReceiverHandles IF_MVAR(,ps)
receiverSystemStateGetReceiverHandles (ReceiverSystemState rsHs)
	= rsHs

windowSystemStateGetWindowHandles :: DeviceSystemState IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps)
windowSystemStateGetWindowHandles (WindowSystemState wsHs)
	= wsHs
