module IOstate ( Context, IOContext, IOSt, GUI, toGUI, appIOEnv, accIOEnv, liftIO, fromGUI
#if MVAR
               , PSt
#else
               , PSt(..), doPSt
#endif
               , DeviceFunctions(..), dDevice, dEvent, EventFunction, dDoIO, DoIOFunction, dOpen, OpenFunction, dClose, CloseFunction
               , initialContext
               , emptyIOSt
               , ioStGetProcessAttributes, ioStSetProcessAttributes, StdGUI.ProcessAttribute(..)
               , ioStGetInitIO, ioStGetInitIO, StdIOBasic.IdFun
               , ioStClosed, ioStGetRuntimeState, ioStSetRuntimeState, RuntimeState(..)
               , ioStGetIdTable, ioStSetIdTable, Id.IdTable
               , ioStGetReceiverTable, ioStSetReceiverTable, Receivertable.ReceiverTable
               , ioStGetEvents, ioStSetEvents, Osevent.OSEvents
               , ioStGetDocumentInterface, ioStGetOSDInfo, ioStSetOSDInfo, module Osdocumentinterface
               , ioStGetIOId, SystemId(..)
               , ioStGetMaxIONr, ioStSetMaxIONr, ioStNewMaxIONr
               , ioStGetIdSeed, ioStSetIdSeed
               , ioStGetOSWindowMetrics, Ossystem.OSWindowMetrics(..)
               , ioStGetContext
               , ProcessEventHandler(..), ProcessEventFilter, DeviceEvents, Concurrent.Chan, Concurrent.MVar, DeviceEventInfo
               , ioStEmptyProcessEventHandlers, ioStSetProcessEventHandler, ioStRemoveProcessEventHandler
               , ioStGetDeviceEventChannel, newDeviceEvents, writeDeviceEvent, readDeviceEvent, freeDeviceEvent
               , ioStGetDeviceFunctions, ioStSetDeviceFunctions, ioStRemoveDeviceFunctions
               , ioStHasDevice, ioStGetDevices, ioStGetDevice, ioStRemoveDevice, ioStSetDevice, module Devicesystemstate
               , ioContextGetEvents, ioContextSetEvents
               , ioContextGetMaxIONr, ioContextSetMaxIONr, ioContextNewMaxIONr
               , ioContextGetIdSeed, ioContextSetIdSeed
               , ioContextGetIdTable, ioContextSetIdTable
               , ioContextGetReceiverTable, ioContextSetReceiverTable
               , ioContextEmptyProcessEventHandlers, ioContextGetProcessEventHandlers, ioContextSetProcessEventHandler, ioContextRemoveProcessEventHandler
               , module Concurrent, module Device, module Deviceevents
               ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	IOstate defines the GUI environment types and their access functions.
--	********************************************************************************


import CleanStdFunc
import CleanStdList
import CleanStdMisc
import Concurrent
import Device
import Deviceevents
import Devicesystemstate
import Id
import Osdocumentinterface
import Osevent
import Ossystem
import Ostoolbox
import Receivertable
import StdGUI (ProcessAttribute(..))
import StdIOBasic
import Systemid
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


{-	The GUI monad is an IO monad extended with IOSt.
	Note: GUI can't be defined as newtype because it's abstract.
	      Putting newtype GUI in the hi-boot kills GHC.
-}
#if MVAR
data	GUI a = GUI !(IOSt -> IO (a,IOSt))
#else
data	GUI ps a = GUI !(IOSt ps -> IO (a,IOSt ps))
#endif

instance Monad (GUI IF_MVAR(,ps)) where
	(>>=) envIOA to_envIOB
		= GUI (bind envIOA to_envIOB)
		where
			bind (GUI fA) to_envIOB ioState
				= fA ioState >>= (\(a,ioState)->case to_envIOB a of
				                            (GUI fB) -> fB ioState)
	
	(>>) envIOA envIOB
		= GUI (bind envIOA envIOB)
		where
			bind (GUI fA) envIOB ioState
				= fA ioState >>= (\(_,ioState)->case envIOB of
				                            (GUI fB) -> fB ioState)
	
	return a = GUI (\ioState -> return (a,ioState))

{-	liftIO transforms a `standard' Haskell IO monad to a GUI monad.
	Obviously, this function should be part of the Object I/O API.
-}
liftIO :: IF_MVAR(IO a -> GUI a,IO a -> GUI ps a)
liftIO m
	= GUI (\ioState->m>>=(\a->return (a,ioState)))


{-	The following functions useful for easy composition of IOSt transition functions
	and coercing purposes.
	Since they expose the IOSt type, they are not part of the API.
-}
appIOEnv :: IdFun IF_MVAR(IOSt,(IOSt ps)) -> GUI IF_MVAR(,ps) ()
appIOEnv f
	= GUI (\env->return ((),f env))

accIOEnv :: St IF_MVAR(IOSt,(IOSt ps)) x -> GUI IF_MVAR(,ps) x
accIOEnv f
	= GUI (\env->return (f env))

toGUI :: (IOSt IF_MVAR(,ps) -> IO (a,IOSt IF_MVAR(,ps))) -> GUI IF_MVAR(,ps) a
toGUI fun = GUI fun

fromGUI :: GUI IF_MVAR(,ps) a -> IOSt IF_MVAR(,ps) -> IO (a,IOSt IF_MVAR(,ps))
fromGUI (GUI fAction) = fAction

#if MVAR
#else
doPSt :: (ps -> GUI ps ps) -> PSt ps -> IO (PSt ps)
doPSt f (PSt {ls=ps,io=ioState})
	= fromGUI (f ps) ioState >>= (\(ps1,ioState1) -> return (PSt {ls=ps1,io=ioState1}))
#endif


{-	In this implementation the process administration collapses into
	one single process. This is either an IOSt (MVAR version), or the 
	good old (PSt ps) (in case of LS version).
-}
#if MVAR
type	PSt
	= IOSt
#else
data	PSt ps
	= PSt
		{ ls :: ps
		, io :: IOSt ps
		}
#endif

{-	IOSt always had all the components to construct a context. These components
	are now being shared by concurrent Haskell threads via a (MVar IOContext).
	So we define the IOContext type here instead of in Scheduler and have IOSt
	contain a (MVar IOContext).
-}
type	Context							-- A Context points to an IOContext
	= MVar IOContext
data	IOContext
	= IOContext
		{ ioevents          :: !OSEvents		-- The event stream environment
		, ionr              :: !SystemId		-- The max SystemId of all processes
		, ioidseed          :: !Int			-- The global id generating number (actually the World)
		, ioidtable         :: !IdTable			-- The table of all bound Ids
		, ioreceivertable   :: !ReceiverTable		-- The table of the current whereabouts of receivers
		, ioprocesshandlers :: ![ProcessEventHandler]	-- The list of all process event handlers
		}
data	ProcessEventHandler
	= ProcessEventHandler
		{ pehId             :: !SystemId		-- The Id of the process (equals IOSt.ioid)
		, pehEventFilter    :: !ProcessEventFilter	-- The process event filter function
		, pehDeviceEvents   :: !DeviceEvents		-- The DeviceEvents stream
		}
type	ProcessEventFilter					-- A process event filter (note that it equals (EventFunction _)):
	= SchedulerEvent					-- The SchedulerEvent that is to be inspected
	-> IO	( Bool						-- True iff handled by this process
	     	, Maybe DeviceEventInfo				-- Iff handled by this process then (Just deviceEvent)
	     	, SchedulerEvent				-- Optionally modified argument message
	     	)
data	DeviceEvents						-- The DeviceEvents stream is a synchronised Channel
	= DeviceEvents
		{ deChan            :: !(Chan DeviceEventInfo)	-- The Channel
		, deSync            :: !(MVar ())		-- The synchronisation token
		}
type	DeviceEventInfo						-- A DeviceEventInfo event
	=	( Device					-- The Device that accepted the DeviceEvent
		, DeviceEvent					-- The DeviceEvent to be handled
		)
data	IOSt IF_MVAR(,ps)
	= IOSt
		{ ioid              :: !SystemId		-- The Id of the process
		, ioruntime         :: !RuntimeState		-- The runtime state of the process
		, ioosdinfo         :: !OSDInfo			-- The OS document interface information of the process
		, iooswmetrics      :: !OSWindowMetrics		-- The window metrics
		, iocontext         :: !Context			-- The shared context
		, iodeviceevents    :: !DeviceEvents		-- The DeviceEvents stream
#if MVAR
		, ioinit            :: !(GUI ())		-- The initialisation functions of the process
		, iodevicefuncs     :: ![DeviceFunctions]	-- The currently active device functions
		, ioatts            :: ![ProcessAttribute]	-- The attributes of the process
		, iodevices         :: [DeviceSystemState]	-- The GUI device states of the process
#else
		, ioinit            :: !(ps -> GUI ps ps)	-- The initialisation functions of the process
		, iodevicefuncs     :: ![DeviceFunctions  ps]	-- The currently active device functions
		, ioatts            :: ![ProcessAttribute ps]	-- The attributes of the process
		, iodevices         :: [DeviceSystemState ps]	-- The GUI device states of the process
#endif
		}
data	RuntimeState
	= Running						-- The process is running
	| Closed						-- The process is closed
	deriving (Eq)
data	DeviceFunctions IF_MVAR(,ps)				-- The major device callback functions:
	= DeviceFunctions
		{ dDevice :: Device				-- The device kind
		, dEvent  :: EventFunction IF_MVAR(,ps)		-- Map an OSEvent to a DeviceEvent
		, dDoIO   :: DoIOFunction  IF_MVAR(,ps)		-- Handle a DeviceEvent for this device
		, dOpen   :: OpenFunction  IF_MVAR(,ps)		-- Open the initial device
		, dClose  :: CloseFunction IF_MVAR(,ps)		-- Close the device and its instances
		}
#if MVAR
type	OpenFunction     = GUI ()
type	CloseFunction    = GUI ()
type	EventFunction    = IOSt -> SchedulerEvent -> IO (Bool, Maybe DeviceEvent, SchedulerEvent)
type	DoIOFunction     = DeviceEvent -> GUI ()
#else
type	OpenFunction  ps = ps -> GUI ps ps
type	CloseFunction ps = ps -> GUI ps ps
type	EventFunction ps = IOSt ps -> SchedulerEvent -> IO (Bool, Maybe DeviceEvent, SchedulerEvent)
type	DoIOFunction  ps = DeviceEvent -> ps -> GUI ps ps
#endif


--	Creation of an initial context:

initialContext :: Int -> IO Context
initialContext initIdSeed
	= newMVar (IOContext
		      { ioevents          = osNewEvents
		      , ionr              = initSystemId
		      , ioidseed          = initIdSeed
		      , ioidtable         = initialIdTable
		      , ioreceivertable   = initialReceiverTable
		      , ioprocesshandlers = []
		      }
		  )


--	Creation of an initial, empty IOSt:

#if MVAR
emptyIOSt :: SystemId -> DocumentInterface -> [ProcessAttribute]    -> GUI ()            -> Context -> DeviceEvents -> IO IOSt
#else
emptyIOSt :: SystemId -> DocumentInterface -> [ProcessAttribute ps] -> (ps -> GUI ps ps) -> Context -> DeviceEvents -> IO (IOSt ps)
#endif
emptyIOSt ioId xDI attributes initIO context channel
	= do {
		wMetrics <- osDefaultWindowMetrics;
		return IOSt
			  { ioid           = ioId
			  , ioruntime      = Running
			  , ioosdinfo      = emptyOSDInfo xDI
			  , iooswmetrics   = wMetrics
			  , iocontext      = context
			  , iodeviceevents = channel
			  , ioinit         = initIO
			  , iodevicefuncs  = []
			  , ioatts         = attributes
			  , iodevices      = []
			  }
	  }

--	Access rules to the IOSt:

--	Access rules to process attributes:

ioStGetProcessAttributes :: IOSt IF_MVAR(,ps) -> ([ProcessAttribute IF_MVAR(,ps)],IOSt IF_MVAR(,ps))
ioStGetProcessAttributes ioState
	= (ioatts ioState, ioState)

ioStSetProcessAttributes :: [ProcessAttribute IF_MVAR(,ps)] -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStSetProcessAttributes atts ioState
	= ioState {ioatts=atts}


--	Access rules to the initial actions:

#if MVAR
ioStGetInitIO :: IOSt -> (GUI (), IOSt)
#else
ioStGetInitIO :: IOSt ps -> (ps -> GUI ps ps, IOSt ps)
#endif
ioStGetInitIO ioState
	= (ioinit ioState, ioState {ioinit=return IF_MVAR((),)})

#if MVAR
ioStSetInitIO :: GUI () -> IOSt -> IOSt
#else
ioStSetInitIO :: (ps -> GUI ps ps) -> IOSt ps -> IOSt ps
#endif
ioStSetInitIO initIO ioState
	= ioState {ioinit=initIO}


--	Access rules to RuntimeState:

ioStClosed :: IOSt IF_MVAR(,ps) -> (Bool,IOSt IF_MVAR(,ps))
ioStClosed ioState
	= (ioruntime ioState == Closed, ioState)

ioStGetRuntimeState :: IOSt IF_MVAR(,ps) -> (RuntimeState, IOSt IF_MVAR(,ps))
ioStGetRuntimeState ioState
	= (ioruntime ioState, ioState)

ioStSetRuntimeState :: RuntimeState -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStSetRuntimeState runtime ioState
	= ioState {ioruntime=runtime}


--	Access rules to IdTable:

ioStGetIdTable :: GUI IF_MVAR(,ps) IdTable
ioStGetIdTable = accIOStContext ioContextGetIdTable

ioStSetIdTable :: IdTable -> GUI IF_MVAR(,ps) ()
ioStSetIdTable idTable = appIOStContext (ioContextSetIdTable idTable)


--	Access rules to ReceiverTable:

ioStGetReceiverTable :: GUI IF_MVAR(,ps) ReceiverTable
ioStGetReceiverTable = accIOStContext ioContextGetReceiverTable

ioStSetReceiverTable :: ReceiverTable -> GUI IF_MVAR(,ps) ()
ioStSetReceiverTable ioreceivertable = appIOStContext (ioContextSetReceiverTable ioreceivertable)


--	Access rules to the OSEvents environment:

ioStGetEvents :: GUI IF_MVAR(,ps) OSEvents
ioStGetEvents = accIOStContext ioContextGetEvents

ioStSetEvents :: OSEvents -> GUI IF_MVAR(,ps) ()
ioStSetEvents es = appIOStContext (ioContextSetEvents es)


--	Access rules to DocumentInterface:

ioStGetDocumentInterface :: IOSt IF_MVAR(,ps) -> (DocumentInterface, IOSt IF_MVAR(,ps))
ioStGetDocumentInterface ioState@(IOSt {ioosdinfo=ioosdinfo})
	= (getOSDInfoDocumentInterface ioosdinfo, ioState)


--	Access rules to OSDInfo:

ioStGetOSDInfo :: IOSt IF_MVAR(,ps) -> (OSDInfo,IOSt IF_MVAR(,ps))
ioStGetOSDInfo ioState@(IOSt {ioosdinfo=ioosdinfo})
	= (ioosdinfo, ioState)

ioStSetOSDInfo :: OSDInfo -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStSetOSDInfo osdInfo ioState
	= ioState {ioosdinfo=osdInfo}


--	Access to the SystemId of the IOSt:

ioStGetIOId :: IOSt IF_MVAR(,ps) -> (SystemId,IOSt IF_MVAR(,ps))
ioStGetIOId ioState
	= (ioid ioState, ioState)


--	Access to the max SystemId of the IOSt:

ioStGetMaxIONr :: GUI IF_MVAR(,ps) SystemId
ioStGetMaxIONr = accIOStContext ioContextGetMaxIONr

ioStSetMaxIONr :: SystemId -> GUI IF_MVAR(,ps) ()
ioStSetMaxIONr maxId = appIOStContext (ioContextSetMaxIONr maxId)

ioStNewMaxIONr :: GUI IF_MVAR(,ps) SystemId
ioStNewMaxIONr = accIOStContext ioContextNewMaxIONr


--	Access to the global seed integer to generate all Ids (see StdId):

ioStGetIdSeed :: GUI IF_MVAR(,ps) Int
ioStGetIdSeed = accIOStContext ioContextGetIdSeed

ioStSetIdSeed :: Int -> GUI IF_MVAR(,ps) ()
ioStSetIdSeed seed = appIOStContext (ioContextSetIdSeed seed)


--	Access to the OSWindowMetrics of the IOSt:

ioStGetOSWindowMetrics :: IOSt IF_MVAR(,ps) -> (OSWindowMetrics,IOSt IF_MVAR(,ps))
ioStGetOSWindowMetrics ioState
	= (iooswmetrics ioState,ioState)


--	Access rules to the ProcessEventHandlers:

ioStEmptyProcessEventHandlers :: GUI IF_MVAR(,ps) Bool
ioStEmptyProcessEventHandlers = accIOStContext ioContextEmptyProcessEventHandlers

ioStGetProcessEventHandlers :: GUI IF_MVAR(,ps) [ProcessEventHandler]
ioStGetProcessEventHandlers = accIOStContext ioContextGetProcessEventHandlers

ioStSetProcessEventHandler :: ProcessEventHandler -> GUI IF_MVAR(,ps) ()
ioStSetProcessEventHandler peh = appIOStContext (ioContextSetProcessEventHandler peh)

ioStRemoveProcessEventHandler :: SystemId -> GUI IF_MVAR(,ps) (Maybe ProcessEventHandler)
ioStRemoveProcessEventHandler ioId = accIOStContext (ioContextRemoveProcessEventHandler ioId)


--	Access to the Context of the IOSt:

ioStGetContext :: IOSt IF_MVAR(,ps) -> (Context,IOSt IF_MVAR(,ps))
ioStGetContext ioState
	= (iocontext ioState,ioState)

accIOStContext :: St IOContext x -> GUI IF_MVAR(,ps) x
accIOStContext fun
	= do {
		context   <- accIOEnv ioStGetContext;
		iocontext <- liftIO (takeMVar context);
		let (x,iocontext1) = fun iocontext
		in  liftIO (putMVar context iocontext1) >> return x
	  }

appIOStContext :: IdFun IOContext -> GUI IF_MVAR(,ps) ()
appIOStContext fun
	= do {
		context   <- accIOEnv ioStGetContext;
		iocontext <- liftIO (takeMVar context);
		liftIO (putMVar context (fun iocontext))
	  }


--	Access to the DeviceEvents of the IOSt:

ioStGetDeviceEventChannel :: IOSt IF_MVAR(,ps) -> (DeviceEvents,IOSt IF_MVAR(,ps))
ioStGetDeviceEventChannel ioState
	= (iodeviceevents ioState,ioState)

newDeviceEvents :: IO DeviceEvents
newDeviceEvents
	= do {
		chan <- newChan;
		sync <- newEmptyMVar;
		return (DeviceEvents {deChan=chan,deSync=sync})
	  }

writeDeviceEvent :: DeviceEvents -> DeviceEventInfo -> IO ()
writeDeviceEvent de deinfo
	= writeChan (deChan de) deinfo >> takeMVar (deSync de)

readDeviceEvent :: DeviceEvents -> IO DeviceEventInfo
readDeviceEvent de = readChan (deChan de)

freeDeviceEvent :: DeviceEvents -> IO ()
freeDeviceEvent de = putMVar (deSync de) ()


--	Access to the DeviceFunctions:

ioStGetDeviceFunctions :: IOSt IF_MVAR(,ps) -> ([DeviceFunctions IF_MVAR(,ps)],IOSt IF_MVAR(,ps))
ioStGetDeviceFunctions ioState
	= (iodevicefuncs ioState, ioState)

ioStSetDeviceFunctions :: DeviceFunctions IF_MVAR(,ps) -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStSetDeviceFunctions funcs ioState
	= ioState {iodevicefuncs=setdevicefunctions (priorityDevice (dDevice funcs)) (dDevice funcs) funcs (iodevicefuncs ioState)}
	where
		setdevicefunctions :: Int -> Device -> DeviceFunctions IF_MVAR(,ps) -> [DeviceFunctions IF_MVAR(,ps)] -> [DeviceFunctions IF_MVAR(,ps)]
		setdevicefunctions p device funcs fs@(dfunc:dfuncs)
			| device==dDevice dfunc
				= funcs:dfuncs
			| p>priorityDevice (dDevice dfunc)
				= funcs:fs
			| otherwise
				= dfunc:setdevicefunctions p device funcs dfuncs
		setdevicefunctions _ _ funcs _
			= [funcs]

ioStRemoveDeviceFunctions :: Device -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStRemoveDeviceFunctions device ioState
	= ioState {iodevicefuncs=removedevicefunctions device (iodevicefuncs ioState)}
	where
		removedevicefunctions :: Device -> [DeviceFunctions IF_MVAR(,ps)] -> [DeviceFunctions IF_MVAR(,ps)]
		removedevicefunctions device (dfunc:dfuncs)
			| device==dDevice dfunc
				= dfuncs
			| otherwise
				= dfunc:removedevicefunctions device dfuncs
		removedevicefunctions _ empty
			= empty

--	Access to the DeviceSystemStates:

ioStHasDevice :: Device -> IOSt IF_MVAR(,ps) -> (Bool,IOSt IF_MVAR(,ps))
ioStHasDevice d ioState
	= (devicesHaveDevice d (iodevices ioState), ioState)
	where
		devicesHaveDevice :: Device -> [DeviceSystemState IF_MVAR(,ps)] -> Bool
		devicesHaveDevice d (dState:dStates) = toDevice dState==d || devicesHaveDevice d dStates
		devicesHaveDevice _ _                = False

ioStGetDevices :: IOSt IF_MVAR(,ps) -> ([Device],IOSt IF_MVAR(,ps))
ioStGetDevices ioState
	= (map toDevice (iodevices ioState), ioState)

ioStGetDevice :: Device -> IOSt IF_MVAR(,ps) -> ((Bool,DeviceSystemState IF_MVAR(,ps)),IOSt IF_MVAR(,ps))
ioStGetDevice d ioState
	= let (found,device,ds) = devicesGetDevice d (iodevices ioState)
	  in  ((found,device),ioState {iodevices=ds})
	where
		devicesGetDevice :: Device -> [DeviceSystemState IF_MVAR(,ps)] -> (Bool,DeviceSystemState IF_MVAR(,ps),[DeviceSystemState IF_MVAR(,ps)])
		devicesGetDevice d (dState:dStates)
			| toDevice dState==d
				= (True,dState,dState:dStates)
			| otherwise
				= let (found,device,dStates1) = devicesGetDevice d dStates
				  in  (found,device,dState:dStates1)
		devicesGetDevice _ empty
			= (False,undef,empty)

ioStRemoveDevice :: Device -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStRemoveDevice d ioState
	= ioState {iodevices=devicesRemoveDevice d (iodevices ioState)}
	where
		devicesRemoveDevice :: Device -> [DeviceSystemState IF_MVAR(,ps)] -> [DeviceSystemState IF_MVAR(,ps)]
		devicesRemoveDevice d (dState:dStates)
			| toDevice dState==d = dStates
			| otherwise          = dState:devicesRemoveDevice d dStates
		devicesRemoveDevice _ dStates
			= dStates

ioStSetDevice :: DeviceSystemState IF_MVAR(,ps) -> IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
ioStSetDevice d ioState
	= let
		device = toDevice d
		ds     = devicesSetDevice (priorityDevice device) device d (iodevices ioState)
	  in	ioState {iodevices=ds}
	where
		devicesSetDevice :: Int -> Device -> DeviceSystemState IF_MVAR(,ps) -> [DeviceSystemState IF_MVAR(,ps)] -> [DeviceSystemState IF_MVAR(,ps)]
		devicesSetDevice p device dState2 ds@(dState1:dStates)
			| device1==device
				= dState2:dStates
			| p>priorityDevice device1
				= dState2:ds
			| otherwise
				= dState1:devicesSetDevice p device dState2 dStates
			where
				device1 = toDevice dState1
		devicesSetDevice _ _ dState _
			= [dState]


--	Access to IOContext:

--	Access rules to the OSEvents environment:

ioContextGetEvents :: IOContext -> (OSEvents,IOContext)
ioContextGetEvents iocontext
	= (ioevents iocontext, iocontext {ioevents=osNewEvents})

ioContextSetEvents :: OSEvents -> IOContext -> IOContext
ioContextSetEvents es iocontext
	= iocontext {ioevents=es}


--	Access to the max SystemId of IOContext:

ioContextGetMaxIONr :: IOContext -> (SystemId,IOContext)
ioContextGetMaxIONr iocontext
	= (ionr iocontext,iocontext)

ioContextSetMaxIONr :: SystemId -> IOContext -> IOContext
ioContextSetMaxIONr maxId iocontext
	= iocontext {ionr=maxId}

ioContextNewMaxIONr :: IOContext -> (SystemId,IOContext)
ioContextNewMaxIONr iocontext
	= let (maxId1,newMaxId) = incrSystemId (ionr iocontext)
	  in  (newMaxId,iocontext {ionr=maxId1})


--	Access to the global seed integer to generate all Ids (see StdId):

ioContextGetIdSeed :: IOContext -> (Int,IOContext)
ioContextGetIdSeed iocontext
	= (ioidseed iocontext,iocontext)

ioContextSetIdSeed :: Int -> IOContext -> IOContext
ioContextSetIdSeed seed iocontext
	= iocontext {ioidseed=seed}


--	Access rules to IdTable:

ioContextGetIdTable :: IOContext -> (IdTable,IOContext)
ioContextGetIdTable iocontext
	= (ioidtable iocontext,iocontext)

ioContextSetIdTable :: IdTable -> IOContext -> IOContext
ioContextSetIdTable idTable iocontext
	= iocontext {ioidtable=idTable}


--	Access rules to ReceiverTable:

ioContextGetReceiverTable :: IOContext -> (ReceiverTable,IOContext)
ioContextGetReceiverTable iocontext
	= (ioreceivertable iocontext,iocontext)

ioContextSetReceiverTable :: ReceiverTable -> IOContext -> IOContext
ioContextSetReceiverTable ioreceivertable iocontext
	= iocontext {ioreceivertable=ioreceivertable}


--	Access rules to the ProcessEventHandlers:

ioContextEmptyProcessEventHandlers :: IOContext -> (Bool,IOContext)
ioContextEmptyProcessEventHandlers iocontext
	= (isEmpty (ioprocesshandlers iocontext),iocontext)

ioContextGetProcessEventHandlers :: IOContext -> ([ProcessEventHandler],IOContext)
ioContextGetProcessEventHandlers iocontext
	= (ioprocesshandlers iocontext,iocontext)

ioContextSetProcessEventHandler :: ProcessEventHandler -> IOContext -> IOContext
ioContextSetProcessEventHandler thePEH ioContext@(IOContext {ioprocesshandlers=ioprocesshandlers})
	| found
		= ioContext {ioprocesshandlers=ioprocesshandlers1}
	| otherwise
		= ioContext {ioprocesshandlers=thePEH : ioprocesshandlers1}
	where
		(found,ioprocesshandlers1) = setProcessEventHandler thePEH ioprocesshandlers
		
		setProcessEventHandler :: ProcessEventHandler -> [ProcessEventHandler] -> (Bool,[ProcessEventHandler])
		setProcessEventHandler thePEH (peh:pehs)
			| pehId peh == pehId thePEH
				= (True, thePEH : pehs)
			| otherwise
				= (found,peh : pehs1)
				where
					(found,pehs1) = setProcessEventHandler thePEH pehs
		setProcessEventHandler _ nil
			= (False,nil)

ioContextRemoveProcessEventHandler :: SystemId -> IOContext -> (Maybe ProcessEventHandler,IOContext)
ioContextRemoveProcessEventHandler ioId ioContext@(IOContext {ioprocesshandlers=ioprocesshandlers})
	= (maybePEH, ioContext {ioprocesshandlers=ioprocesseventhandlers1})
	where
		(maybePEH,ioprocesseventhandlers1) = removeProcessEventHandler ioId ioprocesshandlers
		
		removeProcessEventHandler :: SystemId -> [ProcessEventHandler] -> (Maybe ProcessEventHandler,[ProcessEventHandler])
		removeProcessEventHandler ioId (peh:pehs)
			| pehId peh == ioId
				= (Just peh,pehs)
			| otherwise
				= (peh1,peh : pehs1)
				where
					(peh1,pehs1) = removeProcessEventHandler ioId pehs
		removeProcessEventHandler _ nil
			= (Nothing,nil)
