module Processdevice (processFunctions) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Processdevice defines the window device event handlers.
--	********************************************************************************


import CleanStdMisc
import Commondef
import IOstate
import Osdocumentinterface
import Processevent
import StdProcessAttribute
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


processdeviceFatalError :: String -> String -> x
processdeviceFatalError rule error
	= dumpFatalError rule "Processdevice" error


processFunctions :: DeviceFunctions IF_MVAR(,ps)
processFunctions
	= DeviceFunctions
		{ dDevice = ProcessDevice
		, dEvent  = processEvent
		, dDoIO   = processIO
		, dOpen   = processOpen
		, dClose  = processClose
		}

processOpen :: IF_MVAR(GUI (),ps -> GUI ps ps)
processOpen IF_MVAR(,ps)
	= do {
		hasProcess <- accIOEnv (ioStHasDevice ProcessDevice);
		if   hasProcess
		then return IF_MVAR((),ps)
		else 
		do {
			liftIO osInitialiseDI;
			appIOEnv (ioStSetDeviceFunctions processFunctions);
			osdinfo <- accIOEnv ioStGetOSDInfo;
			createOSDInfo osdinfo;
			return IF_MVAR((),ps)
		   }
	     }
	where
		createOSDInfo :: OSDInfo -> GUI IF_MVAR(,ps) ()
		createOSDInfo emptyOSDInfo
			| di==NDI
				= appIOEnv (ioStSetOSDInfo emptyOSDInfo)
			| di==MDI
				= do {
					osdinfo <- liftIO (osOpenMDI True False);
					appIOEnv (ioStSetOSDInfo osdinfo)
				  }
			| di==SDI
				= do {
					osdinfo <- liftIO (osOpenSDI False);
					appIOEnv (ioStSetOSDInfo osdinfo)
				  }
			where
				di = getOSDInfoDocumentInterface emptyOSDInfo

processClose :: IF_MVAR(GUI (),ps -> GUI ps ps)
processClose IF_MVAR(,ps)
	= do {
		accIOEnv (ioStGetDevice ProcessDevice);
		appIOEnv (ioStRemoveDeviceFunctions ProcessDevice);
		return IF_MVAR((),ps)
	  }

{-	In this implementation only ProcessRequestClose events are handled.
	The following events have been skipped:
		ProcessRequestOpenFiles
	The following event has been introduced:
		ProcessInitialise
-}
processIO :: DeviceEvent -> IF_MVAR(,ps ->) GUI IF_MVAR((),ps ps)

{-	ProcessInitialise is the first event sent to an interactive process.
	This allows the system to evaluate its initialisation action. No further
	actions are required.
-}
processIO ProcessInitialise IF_MVAR(,ps)
	= return IF_MVAR((),ps)

processIO ProcessRequestClose IF_MVAR(,ps)
	= do {
		atts                 <- accIOEnv ioStGetProcessAttributes;
		let (hasCloseAtt,att) = cselect isProcessClose undef atts
		in
		if   not hasCloseAtt
		then return IF_MVAR((),ps)
		else getProcessCloseFun att IF_MVAR(,ps)
	  }

processIO _ IF_MVAR(,_)
	= processdeviceFatalError "processIO" "unexpected DeviceEvent"
