module Receiveraccess ( newReceiverStateHandle,  newReceiverHandle
--                    , newReceiverStateHandle2, newReceiverHandle2
                      ) where


--	********************************************************************************
--	Clean Standard Object I/O library, version 1.2
--	
--	Receiveraccess contains ReceiverHandle access.
--	********************************************************************************


import Id
import Receiverdefaccess
import Receiverhandle
import IOstate(GUI)
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


newReceiverStateHandle :: RId m -> IF_MVAR(,ls ->) SelectState -> [Id] -> ReceiverFunction m IF_MVAR(,ls ps) -> ReceiverStateHandle IF_MVAR(,ps)
newReceiverStateHandle rid IF_MVAR(,localState) select connectedIds f
#if MVAR
	= ReceiverStateHandle (newReceiverHandle rid select connectedIds f)
#else
	= ReceiverStateHandle localState (newReceiverHandle rid select connectedIds f)
#endif

newReceiverHandle :: RId m -> SelectState -> [Id] -> ReceiverFunction m IF_MVAR(,ls ps) -> ReceiverHandle m r IF_MVAR(,ls ps)
newReceiverHandle rid select connectedIds f
	= ReceiverHandle
		{ rId        = rIdtoId  rid
		, rASMQ      = getRIdIn rid
		, rSelect    = select
		, rOneWay    = True
		, rFun       = onewaytotriple f
	--	, rInetInfo  = Nothing
	--	, rConnected = connectedIds
		}

#if MVAR
onewaytotriple :: ReceiverFunction m -> m -> GUI [r]
onewaytotriple f m = f m >> return []
#else
onewaytotriple :: ReceiverFunction m ls ps -> m -> (ls,ps) -> GUI ps ([r],(ls,ps))
onewaytotriple f m (ls,ps)
	= f m (ls,ps) >>= (\(ls',ps') -> return ([],(ls',ps')))
#endif

{-	Bi-directional message passing not yet incorporated.
newReceiverStateHandle2 :: R2Id m r -> IF_MVAR(,ls ->) SelectState -> [Id] -> Receiver2Function m r IF_MVAR(,ls ps) -> ReceiverStateHandle IF_MVAR(,ps)
newReceiverStateHandle2 r2id IF_MVAR(,localState) select connectedIds f
#if MVAR
	= ReceiverStateHandle (newReceiverHandle2 r2id select connectedIds f)
#else
	= ReceiverStateHandle localState (newReceiverHandle2 r2id select connectedIds f)
#endif

newReceiverHandle2 :: R2Id m r -> SelectState -> [Id] -> Receiver2Function m r IF_MVAR(,ls ps) -> ReceiverHandle IF_MVAR(,ls ps)
newReceiverHandle2 r2id select connectedIds f
	= Receiver2Handle
		{ r2Id       = r2IdtoId   r2id
		, rSMQ       = getR2IdIn  r2id
		, rSRQ       = getR2IdOut r2id
		, rSelect    = select
		, rOneWay    = False
		, rFun       = twowaytotriple f
	--	, rInetInfo  = Nothing
	--	, rConnected = connectedIds
		}

#if MVAR
twowaytotriple :: Receiver2Function m r -> m -> GUI [r]
twowaytotriple f m = f m >>= (\r -> return [r])
#else
twowaytotriple :: Receiver2Function m r ls ps -> m -> (ls,ps) -> ([r],(ls,,ps))
twowaytotriple f m (ls,ps)
	= f m (ls,ps) >>= (\(r,(ls,ps)) -> return ([r],(ls,ps)))
#endif
-}
