module Receiverdefaccess ( receiverDefAttributes, receiver2DefAttributes
                         , receiverDefRId,        receiver2DefR2Id
                         , receiverDefSelectState,receiver2DefSelectState
                         , receiverDefFunction,   receiver2DefFunction
                         , receiverDefSetAbility, receiver2DefSetAbility
                         , receiverDefSetFunction,receiver2DefSetFunction
                         , module StdReceiverDef
                         ) where


--	********************************************************************************
--	Clean Standard Object I/O library, version 1.2
--	
--	Access functions to ReceiverDefinitions.
--	********************************************************************************


import Commondef
import StdReceiverAttribute
import StdReceiverDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


receiverDefAttributes :: Receiver m IF_MVAR(,ls ps) -> [ReceiverAttribute IF_MVAR(,ls ps)]
receiverDefAttributes (Receiver _ _ atts) = atts

receiver2DefAttributes :: Receiver2 m r IF_MVAR(,ls ps) -> [ReceiverAttribute IF_MVAR(,ls ps)]
receiver2DefAttributes (Receiver2 _ _ atts) = atts

receiverDefRId :: Receiver m IF_MVAR(,ls ps) -> RId m
receiverDefRId (Receiver rid _ _) = rid

receiver2DefR2Id :: Receiver2 m r IF_MVAR(,ls ps) -> R2Id m r
receiver2DefR2Id (Receiver2 r2id _ _) = r2id

receiverDefSelectState :: Receiver m IF_MVAR(,ls ps) -> SelectState
receiverDefSelectState (Receiver _ _ atts) = getSelectState atts

receiver2DefSelectState :: Receiver2 m r IF_MVAR(,ls ps) -> SelectState
receiver2DefSelectState (Receiver2 _ _ atts) = getSelectState atts

getSelectState :: [ReceiverAttribute IF_MVAR(,ls ps)] -> SelectState
getSelectState atts
	= getReceiverSelectStateAtt selectAtt
	where
		(_,selectAtt) = cselect isReceiverSelectState defSelect atts
		defSelect     = ReceiverSelectState Able

receiverDefFunction :: Receiver m IF_MVAR(,ls ps) -> ReceiverFunction m IF_MVAR(,ls ps)
receiverDefFunction (Receiver _ f _) = f

receiver2DefFunction :: Receiver2 m r IF_MVAR(,ls ps) -> Receiver2Function m r IF_MVAR(,ls ps)
receiver2DefFunction (Receiver2 _ f _) = f

receiverDefSetAbility :: SelectState -> Receiver m IF_MVAR(,ls ps) -> Receiver m IF_MVAR(,ls ps)
receiverDefSetAbility ability (Receiver rid f atts)
	= Receiver rid f (setSelectState ability atts)

receiver2DefSetAbility :: SelectState -> Receiver2 m r IF_MVAR(,ls ps) -> Receiver2 m r IF_MVAR(,ls ps)
receiver2DefSetAbility ability (Receiver2 r2id f atts)
	= Receiver2 r2id f (setSelectState ability atts)

setSelectState :: SelectState -> [ReceiverAttribute IF_MVAR(,ls ps)] -> [ReceiverAttribute IF_MVAR(,ls ps)]
setSelectState ability atts
	= snd (creplace isReceiverSelectState (ReceiverSelectState ability) atts)


receiverDefSetFunction :: ReceiverFunction m IF_MVAR(,ls ps) -> Receiver m IF_MVAR(,ls ps) -> Receiver m IF_MVAR(,ls ps)
receiverDefSetFunction f (Receiver rid _ atts)
	= Receiver rid f atts

receiver2DefSetFunction :: Receiver2Function m r IF_MVAR(,ls ps) -> Receiver2 m r IF_MVAR(,ls ps) -> Receiver2 m r IF_MVAR(,ls ps)
receiver2DefSetFunction f (Receiver2 r2id _ atts)
	= Receiver2 r2id f atts
