module Receiverdevice (receiverFunctions) where


--	********************************************************************************
--	Clean Standard Object I/O library, version 1.2
--	
--	Receiverdevice defines the receiver device event handlers.
--	********************************************************************************


import Commondef
import Id
import IOExts (fixIO)
import IOstate
import Receiverevent
import Receiverhandle
import Receiverid
import Receivertable
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


receiverdeviceFatalError :: String -> String -> x
receiverdeviceFatalError rule error
	= dumpFatalError rule "Receiverdevice" error

receiverFunctions :: DeviceFunctions IF_MVAR(,ps)
receiverFunctions
	= DeviceFunctions
		{ dDevice = ReceiverDevice
		, dEvent  = receiverEvent
		, dDoIO   = receiverIO
		, dOpen   = receiverOpen
		, dClose  = receiverClose
		}

receiverOpen :: IF_MVAR(GUI (),ps -> GUI ps ps)
receiverOpen IF_MVAR(,ps)
	= do {
		hasReceiver <- accIOEnv (ioStHasDevice ReceiverDevice);
		if   hasReceiver
		then return IF_MVAR((),ps)
		else do {
			appIOEnv (ioStSetDevice (ReceiverSystemState (ReceiverHandles {rReceivers=[]})));
			appIOEnv (ioStSetDeviceFunctions receiverFunctions);
			IF_MVAR(,return ps)
		     }
	  }

receiverClose :: IF_MVAR(GUI (),ps -> GUI ps ps)
receiverClose IF_MVAR(,ps)
	= do {
{-	TCP not handled yet
		callReceiverCloseFunctions;
		appIOEnv (ioStSetRcvDisabled True);
-}
		(found,rDevice) <- accIOEnv (ioStGetDevice ReceiverDevice);
		if   not found
		then return IF_MVAR((),ps)
		else 
		let  rHs  = rReceivers $ receiverSystemStateGetReceiverHandles rDevice
		     rIds = map (\(ReceiverStateHandle IF_MVAR(,_) rH) -> rId rH) rHs
		in
		do {
			idtable <- ioStGetIdTable;
			ioStSetIdTable (snd (removeIdsFromIdTable rIds idtable));
			unbindRIds rIds;
			appIOEnv (ioStRemoveDevice ReceiverDevice);
			appIOEnv (ioStRemoveDeviceFunctions ReceiverDevice);
			IF_MVAR(,return ps)
		}
	  }
{-	where
		callReceiverCloseFunctions :: GUI IF_MVAR(,ps) ()
		callReceiverCloseFunctions
			= do {
				(found,rDevice) <- accIOEnv (ioStGetDevice ReceiverDevice);
				if   not found
				then return ()
				else
				let  rHs = rReceivers $ receiverSystemStateGetReceiverHandles rDevice
				in   sequence_ (map callCloseFunc rHs)
			  }
			where
				callCloseFunc {rHandle={rInetInfo=Nothing, rConnected}}
					= sequence_ (map closeReceiver rConnected)
				callCloseFunc {rHandle={rInetInfo=Just (_,_,_,closeFun), rConnected}}
					= sequence_ (map closeReceiver rConnected) >> closeFun
-}

{-	The receiver handles one message event:
	- ASyncMessage:
		this is a request to handle the first asynchronous message available in the
		asynchronous message queue. Globally the size of the asynchronous message queue
		has already been decreased.
	The QASyncMessage has become superfluous as it is replaced by Channel operations.
	The SyncMessage is currently ignored as synchronous message passing is not yet implemented.
-}
receiverIO :: DeviceEvent -> IF_MVAR(GUI (),ps -> GUI ps ps)
receiverIO deviceEvent IF_MVAR(,ps)
	= do {
		(found,rDevice) <- accIOEnv (ioStGetDevice ReceiverDevice);
		if   not found		-- This condition should not occur: dDoIO function should be applied only iff dEvent filters message
		then receiverdeviceFatalError "receiverIO" "could not retrieve ReceiverSystemState from IOSt"
		else 
		let  rsHs = rReceivers $ receiverSystemStateGetReceiverHandles rDevice
		in   receiverIO deviceEvent rsHs IF_MVAR(,ps)
	  }
	where
		receiverIO :: DeviceEvent -> [ReceiverStateHandle IF_MVAR(,ps)] -> IF_MVAR(GUI (),ps -> GUI ps ps)
		
		receiverIO deviceEvent@(ReceiverEvent async@(ASyncMessage event)) rsHs IF_MVAR(,ps)
			= letOneReceiverDoIO (asmRecLoc async) rsHs IF_MVAR(,ps)
			where
#if MVAR
				letOneReceiverDoIO :: RecLoc -> [ReceiverStateHandle] -> GUI ()
				letOneReceiverDoIO recLoc rsHs
					= letReceiverDoIO rsH
					where
						dummy   = receiverdeviceFatalError "receiverIO (ReceiverEvent (ASyncMessage _))" "receiver could not be found"
						(_,rsH) = cselect (identifyReceiverStateHandle (rlParentId recLoc)) dummy rsHs
						
						letReceiverDoIO :: ReceiverStateHandle -> GUI ()
						letReceiverDoIO (ReceiverStateHandle (ReceiverHandle {rASMQ=channel,rFun=rFun}))
							= do {
								msg <- liftIO (readChan channel);
								rFun msg;
								return ()
							  }
#else
				letOneReceiverDoIO :: RecLoc -> [ReceiverStateHandle ps] -> ps -> GUI ps ps
				letOneReceiverDoIO recLoc rsHs ps
					= toGUI (letReceiverDoIO rsH rsHs1 ps)
					where
						dummy           = receiverdeviceFatalError "receiverIO (ReceiverEvent (ASyncMessage _))" "receiver could not be found"
						(_,rsH,rsHs1)   = uremove (uidentifyReceiverStateHandle (rlParentId recLoc)) dummy rsHs
						
						letReceiverDoIO :: ReceiverStateHandle ps -> [ReceiverStateHandle ps] -> ps -> IOSt ps -> IO (ps,IOSt ps)
						letReceiverDoIO (ReceiverStateHandle ls rH@(ReceiverHandle {rASMQ=channel,rFun=rFun})) rsHs ps ioState
							= do {
								msg <- readChan channel;
								r   <- fixIO (\st -> fromGUI (rFun msg (ls,ps))
								                             (ioStSetDevice 
								                                 (ReceiverSystemState
								                                     (ReceiverHandles 
								                                         {rReceivers=rsHs ++ [ReceiverStateHandle (fst (snd (fst st))) rH]}))
								                                 ioState));
								let ((_,(_,ps1)),ioState1) = r
								in  return (ps1,ioState1)
							  }
#endif
	{-	Synchronous message passing not yet handled
		receiverIO (ReceiverEvent (SyncMessage event)) rsHs pState
			# (lastProcess,pState)	= accPIO IOStLastInteraction pState
			# (event,pState)		= receiverSyncIO lastProcess event rsHs pState
			= (ReceiverEvent (SyncMessage event),pState)
		where
			receiverSyncIO :: !Bool !SyncMessage ![ReceiverStateHandle (PSt .l)] !(PSt .l) -> (!SyncMessage,!PSt .l)
			receiverSyncIO lastProcess event rsHs pState
				| not found
				= (event1,pState2)
				with
					event1	= if lastProcess {event & smError=[ReceiverUnknown]} event
				| isEmpty error
				= ({event & smResp=resp},  pState2)
				= ({event & smError=error},pState2)
			where
				pState1		= {pState & io=IOStSetDevice (ReceiverSystemState {rReceivers=rsHs1}) pState.io}
				(found,error,resp,rsHs1,pState2)
							= applyReceiverFunction event rsHs pState1
				
				applyReceiverFunction :: !SyncMessage ![ReceiverStateHandle .pst] .pst
					-> (!Bool,[MessageError],[SemiDynamic],[ReceiverStateHandle .pst],.pst)
				applyReceiverFunction event=:{smRecLoc={rlReceiverId}} [rsH=:{rState=ls,rHandle=rH}:rsHs] ps
					| not (receiverIdentified rlReceiverId rH)
					= (found,error,resp,[rsH:rsHs1],ps1)
					with
						(found,error,resp,rsHs1,ps1) = applyReceiverFunction event rsHs ps
					| enabled rH.rSelect
					= (True,[],resp,[{rState=ls1,rHandle=rH1}:rsHs],ps1)
					with
						(resp,rH1,(ls1,ps1))	= receiverHandleSyncMessage event rH (ls,ps)
					= (True,[ReceiverUnable],[],[rsH:rsHs],ps)
				applyReceiverFunction _ rsHs ps
					= (False,[],[],rsHs,ps)
	-}
	{-	TCP not yet handled
		receiverIO deviceEvent=:(InternetEvent event) rsHs pState
			= (deviceEvent,letOneReceiverDoInetEvent event rsHs pState)
	-}
		receiverIO _ _ IF_MVAR(,_)
			= receiverdeviceFatalError "receiverIO" "device event passed receiver event filter without handling"

{-	TCP not yet handled.
letOneReceiverDoInetEvent (eventCode,endpointRef,inetReceiverCategory,misc) rsHs pState
	# (opt_rsH,rsHs)		= selectReceiver (endpointRef,inetReceiverCategory) rsHs
	| isNothing opt_rsH
		= pState			// geen IOSetReceiverDevice nodig, omdat er geen veranderingen gebeurd zijn
	# eventInfo				= (eventCode,endpointRef,misc)
	# rsH = fromJust opt_rsH
	| rsH.rHandle.rSelect==Able && isEmpty rsH.rHandle.rASMQ
		 = applyInetEvent eventInfo rsH rsHs pState	// apply the event immediately
	// receiver is unable, so queue the event via asyncSend to handle it later
	# receivers			= ReceiverSystemState {rReceivers=[rsH:rsHs]} // left at the beginnig
	  pState			= appPIO (IOStSetDevice receivers) pState
	# (sR,pState)		= asyncSend (getInetReceiverRId rsH.rHandle) eventInfo pState
	| sR<>SendOk
		= abort "receiverdevice: I have a bug (78)"	
	= pState
where
	selectReceiver 	:: !(!EndpointRef`,!InetReceiverCategory`) ![ReceiverStateHandle .ps]
					-> (Maybe (ReceiverStateHandle .ps),![ReceiverStateHandle .ps])
	selectReceiver receiverId=:(endpointRef,type) [rsH=:{rHandle={rInetInfo=Just (epr,tp,_,_)}}:rsHs]
		| endpointRef==epr && type==tp
			= (Just rsH,rsHs)
		# (opt_rsH, rsHs) = selectReceiver receiverId rsHs
		= (opt_rsH,[rsH:rsHs])
	selectReceiver receiverId [rsH:rsHs]
		# (opt_rsH, rsHs) = selectReceiver receiverId rsHs
		= (opt_rsH,[rsH:rsHs])
	selectReceiver _ []
		= (Nothing,[])

applyInetEvent	::	!InetReceiverASMQType !.(ReceiverStateHandle *(PSt .l))
					[ReceiverStateHandle *(PSt .l)] !*(PSt .l)
				->	PSt .l
applyInetEvent eventInfo rsH=:{rState,rHandle} rsHs pState
	= pState2
	with
		pState1				= appPIO (IOStSetDevice receivers) pState
		(rState2,pState2)	= receiverApplyInetEvent eventInfo rHandle (rState,pState1)
		receivers			= ReceiverSystemState {rReceivers=[{rsH & rState=rState2}:rsHs]} // left at the beginnig
// ..MW11
-}

identifyReceiverStateHandle :: Id -> ReceiverStateHandle IF_MVAR(,ps) -> Bool
identifyReceiverStateHandle id (ReceiverStateHandle IF_MVAR(,_) (ReceiverHandle {rId=rId}))
	= id==rId

uidentifyReceiverStateHandle :: Id -> ReceiverStateHandle IF_MVAR(,ps) -> (Bool,ReceiverStateHandle IF_MVAR(,ps))
uidentifyReceiverStateHandle id rsH@(ReceiverStateHandle IF_MVAR(,_) (ReceiverHandle {rId=rId}))
	= (id==rId,rsH)
