module Receiverhandle where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Receiverhandle contains the internal data structures that represent the 
--	state of receivers. 
--	********************************************************************************


import Concurrent
import Id
import StdReceiverDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


data	ReceiverHandles IF_MVAR(,ps)
 =	ReceiverHandles
 		{ rReceivers :: [ReceiverStateHandle IF_MVAR(,ps)]
		}
#if MVAR
data	ReceiverStateHandle
 =	forall m r.
 	ReceiverStateHandle
 		(ReceiverHandle m r)
#else
data	ReceiverStateHandle ps
 =	forall ls m r.
	ReceiverStateHandle 
		ls						-- The local state of the receiver
		(ReceiverHandle m r ls ps)			-- The receiver handle
#endif
data	ReceiverHandle m r IF_MVAR(,ls ps)
 =	ReceiverHandle
		{ rId           :: Id				-- The id of the receiver
		, rASMQ         :: Chan m			-- The asynchronous message queue of the receiver
		, rSelect       :: SelectState			-- The current SelectState of the receiver
		, rOneWay       :: Bool				-- Flag: True iff receiver is uni-directional
		, rFun          :: RHandleFunction m r IF_MVAR(,ls ps)
								-- If rOneWay then [r]==[], otherwise [r]==[_]
	--	, rInetInfo     :: Maybe (EndpointRef',InetReceiverCategory',Int,IO ())
								-- For internet receivers
	--	, rConnected    :: [Id]				-- storing the argument of the ReceiverCloseAlsoReceivers attribute
		}
#if MVAR
type	RHandleFunction m r       = m ->            GUI [r]
#else
type	RHandleFunction m r ls ps = m -> (ls,ps) -> GUI ps ([r],(ls,ps))
#endif

{-	TCP not yet supported
type	InetReceiverASMQType  = (InetEvent',EndpointRef',Int)

type	InetEvent'            = Int
type	EndpointRef'          = Int
type	InetReceiverCategory' = Int
-}

receiverIdentified :: Id -> ReceiverHandle m r IF_MVAR(,ls ps) -> Bool
receiverIdentified id rH
	= id==rId rH

{-	TCP not yet supported.
inetReceiverIdentified :: (EndpointRef`,InetReceiverCategory`) !(ReceiverHandle .ls .ps) -> Bool
inetReceiverIdentified _ {rInetInfo=Nothing}
	= False
inetReceiverIdentified (epR1,type1) {rInetInfo=Just (epR2,type2,_,_)}
	= epR1==epR2 && type1==type2

inetReceiverIdentifiedWithId :: !(!Id, !InetReceiverCategory`) !(ReceiverHandle .ls .ps) -> Bool
inetReceiverIdentifiedWithId _ {rInetInfo=Nothing}
	= False
inetReceiverIdentifiedWithId (id,category) {rId, rInetInfo=Just (_,rCategory,_,_)}
	= id==rId && category==rCategory
-}

receiverSetSelectState :: SelectState -> ReceiverStateHandle IF_MVAR(,ps) -> ReceiverStateHandle IF_MVAR(,ps)
#if MVAR
receiverSetSelectState select (ReceiverStateHandle rH) = ReceiverStateHandle (rH {rSelect=select})
#else
receiverSetSelectState select rsH@(ReceiverStateHandle ls rH) = ReceiverStateHandle ls (rH {rSelect=select})
#endif

{-	Sync message passing not yet incorporated
receiverHandleSyncMessage :: SyncMessage -> ReceiverHandle ls ps -> (ls,ps) -> ([SemiDynamic],ReceiverHandle ls ps,(ls,ps))
receiverHandleSyncMessage {smRecLoc={rlReceiverId},smMsg} rH=:{rFun} context
	| not (receiverIdentified rlReceiverId rH)
		= ([],rH,context)
	# maybe_content	= getDynamic rlReceiverId smMsg
	| isNothing maybe_content
		= ([],rH,context)
	# (ls,resp,pst)	= rFun (Cast (fromJust maybe_content)) context
	| isEmpty resp
		= ([],rH,(ls,pst))
	| otherwise	
		= ([setDynamic rlReceiverId (hd resp) smMsg],rH,(ls,pst))
-}

{-	receiverAddASyncMessage not needed anymore, due to Channels.
receiverAddASyncMessage :: !Id !SemiDynamic !(ReceiverHandle .ls .pst) -> ReceiverHandle .ls .pst
receiverAddASyncMessage id sd rH=:{rASMQ}
	| receiverIdentified id rH
		# maybe_content	= getDynamic id sd
		| isNothing maybe_content
			= rH
		-- otherwise
			= {rH & rASMQ=rASMQ++[Cast (fromJust maybe_content)]}
	| otherwise
		= rH
-}

{-	TCP not yet incorporated
receiverApplyInetEvent :: InetReceiverASMQType !(ReceiverHandle .ls .ps) (.ls,.ps) -> (.ls,.ps)
receiverApplyInetEvent eventInfo rH=:{rFun,rInetInfo=Just _} context
	# (ls,_,ps)	= rFun (Cast eventInfo) context
	= (ls,ps)

getInetReceiverRId :: !(ReceiverHandle .ls .ps) -> (RId InetReceiverASMQType)
-- converts an Id into an RId
getInetReceiverRId {rId}
	= toRId (fromId rId)
-}
