module Receiverid where


--	********************************************************************************
--	Clean Standard Object I/O library, version 1.2
--	
--	Receiverid contains the operations to bind and unbind receivers in the 
--	ReceiverTable.
--	********************************************************************************


import IOstate
import Receivertable
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


bindRId :: Id -> SelectState -> Id -> Device -> GUI IF_MVAR(,ps) ()
bindRId rid select deviceid device
	= do {
		pid <- accIOEnv ioStGetIOId;
		rt  <- ioStGetReceiverTable;
		let rl = RecLoc
				{ rlIOId       = pid
				, rlDevice     = device
				, rlParentId   = deviceid
				, rlReceiverId = rid
				}
		in  ioStSetReceiverTable (snd (addReceiverToReceiverTable (ReceiverTableEntry {rteLoc=rl,rteSelectState=select}) rt))
	  }

unbindRId :: Id -> GUI IF_MVAR(,ps) ()
unbindRId rid
	= do {
		rt <- ioStGetReceiverTable;
		ioStSetReceiverTable (snd (removeReceiverFromReceiverTable rid rt))
	  }

unbindRIds :: [Id] -> GUI IF_MVAR(,ps) ()
unbindRIds ids
	= do {
		rt <- ioStGetReceiverTable;
		ioStSetReceiverTable (unbindRIds' ids rt)
	  }
	where
		unbindRIds' :: [Id] -> ReceiverTable -> ReceiverTable
		unbindRIds' (rid:rids) rt = unbindRIds' rids (snd (removeReceiverFromReceiverTable rid rt))
		unbindRIds' _          rt = rt
