module Roundrobin ( RR(..)
                  , emptyRR
                  , toRR, fromRR
                  , isEmptyRR, nodoneRR, notodoRR
                  , resetRR, adddoneRR, inserttodoRR, appendtodoRR, getcurrentRR
                  ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Roundrobin defines a data structure for easily traversing lists elementwise.
--	********************************************************************************


import Commondef (dumpFatalError)


roundrobinFatalError :: String -> String -> x
roundrobinFatalError rule error
	= dumpFatalError rule "Roundrobin" error

data	RR x
	= RR
		{ done :: ![x]		-- The elements that are done (in reverse order)
		, todo :: ![x]		-- The current element and the elements to do (in order)
		}

emptyRR :: RR x
emptyRR = RR {done=[],todo=[]}

toRR :: [x] -> [x] -> RR x
toRR d t = RR {done=d,todo=t}

fromRR :: RR x -> ([x],[x])
fromRR (RR {done=d,todo=t}) = (d,t)

isEmptyRR :: RR x -> (Bool,RR x)
isEmptyRR rr@(RR {done=[],todo=[]})
	= (True, rr)
isEmptyRR rr
	= (False,rr)

nodoneRR :: RR x -> (Bool,RR x)
nodoneRR rr@(RR {done=[]})
	= (True, rr)
nodoneRR rr
	= (False,rr)

notodoRR :: RR x -> (Bool,RR x)
notodoRR rr@(RR {todo=[]})
	= (True, rr)
notodoRR rr
	= (False,rr)

resetRR :: RR x -> RR x
resetRR (RR {done=d,todo=t})
	= RR {done=[],todo=resetRR' d t}
	where
		resetRR' :: [x] -> [x] -> [x]
		resetRR' (x:xs) t = resetRR' xs (x:t)
		resetRR' []     t = t

adddoneRR :: x -> RR x -> RR x
adddoneRR x rr@(RR {done=d})
	= rr {done=x:d}

inserttodoRR :: x -> RR x -> RR x
inserttodoRR x rr@(RR {todo=t})
	= rr {todo=x:t}

appendtodoRR :: x -> RR x -> RR x
appendtodoRR x rr@(RR {todo=t})
	= rr {todo=t++[x]}

getcurrentRR :: RR x -> (x,RR x)
getcurrentRR rr@(RR {todo=(current:t)})
	= (current,rr {todo=t})
getcurrentRR _
	= roundrobinFatalError "getcurrentRR" "todo field is empty"
