module StdIO ( module StdControl
             , module StdControlAttribute
             , module StdControlClass
             , module StdControlDef
             , module StdGUI
             , module StdId
             , module StdIOBasic
             , module StdIOCommon
             , module StdKey
             , module StdMaybe
             , module StdPictureDef
             , module StdProcess
             , module StdProcessAttribute
             , module StdProcessDef
             , module StdReceiver
             , module StdReceiverAttribute
             , module StdReceiverDef
             , module StdWindow
             , module StdWindowAttribute
             , module StdWindowDef
             , liftIO
             ) where

--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdIO contains all definition modules of the Object I/O library.
--	********************************************************************************

import StdId			-- The operations that generate identification values
import StdIOBasic		-- Function and type definitions used in the library
import StdIOCommon		-- Function and type definitions used in the library
import StdKey			-- Function and type definitions on keyboard
import StdMaybe			-- The Maybe data type
import StdGUI			-- Type definitions used in the library

import StdPictureDef		-- Type definitions for picture handling

import StdProcessDef		-- Type definitions for process handling
import StdProcessAttribute	-- ProcessAttribute access operations
import StdProcess		-- Process handling operations

import StdControlDef		-- Type definitions for controls
import StdControlAttribute	-- ControlAttribute access operations
import StdControlClass		-- Standard controls class instances
import StdControl		-- Control handling operations
	
import StdReceiverDef		-- Type definitions for receivers
import StdReceiverAttribute	-- ReceiverAttribute access operations
import StdReceiver		-- Receiver handling operations

import StdWindowDef		-- Type definitions for windows
import StdWindowAttribute	-- WindowAttribute access operations
import StdWindow		-- Window handling operations

import IOstate(liftIO)
