module StdMaybe where

--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdMaybe defines operations on the Maybe type (which is in the Prelude).
--	********************************************************************************

import CleanExtras
import CleanStdFunc(St)

isJust :: Maybe x -> Bool
isJust Nothing = False
isJust _       = True

isNothing :: Maybe x -> Bool
isNothing Nothing = True
isNothing _       = False

fromJust :: Maybe x -> x
fromJust (Just x) = x

accMaybe :: St x a -> Maybe x -> (Maybe a,Maybe x)
accMaybe f (Just x)
	= (Just a,Just x1)
	where
		(a,x1) = f x
accMaybe _ nothing
	= (Nothing,nothing)
