module StdProcessAttribute where


--	********************************************************************************
--	Clean Standard Object I/O library, version 1.2.1
--	
--	StdProcessAttribute specifies which ProcessAttributes are valid for each of the
--	standard interactive processes.
--	Basic comparison operations and retrieval functions are also included.
--	********************************************************************************


import StdProcessDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


isProcessKindAttribute :: DocumentInterface -> ProcessAttribute IF_MVAR(,ps) -> Bool 
--isProcessKindAttribute di (ProcessActivate     _) = True
isProcessKindAttribute   di (ProcessClose        _) = True
--isProcessKindAttribute di (ProcessDeactivate   _) = True
--isProcessKindAttribute di  ProcessNoWindowMenu    = di==MDI
--isProcessKindAttribute di (ProcessOpenFiles    _) = di\=NDI
--isProcessKindAttribute di (ProcessToolbar      _) = di\=NDI
--isProcessKindAttribute di (ProcessWindowPos    _) = di\=NDI
--isProcessKindAttribute di (ProcessWindowResize _) = di\=NDI
--isProcessKindAttribute di (ProcessWindowSize   _) = di\=NDI

{-
isProcessActivate :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessActivate (ProcessActivate _) = True
isProcessActivate _ = False
-}
isProcessClose :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessClose (ProcessClose _) = True
isProcessClose _ = False
{-
isProcessDeactivate :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessDeactivate (ProcessDeactivate _) = True
isProcessDeactivate _ = False

isProcessNoWindowMenu :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessNoWindowMenu ProcessNoWindowMenu = True
isProcessNoWindowMenu _ = False

isProcessOpenFiles :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessOpenFiles (ProcessOpenFiles _) = True
isProcessOpenFiles _ = False

isProcessToolbar :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessToolbar (ProcessToolbar _) = True
isProcessToolbar _ = False

isProcessWindowPos :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessWindowPos (ProcessWindowPos _) = True
isProcessWindowPos _ = False

isProcessWindowResize :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessWindowResize (ProcessWindowResize _) = True
isProcessWindowResize _ = False

isProcessWindowSize :: ProcessAttribute IF_MVAR(,ps) -> Bool 
isProcessWindowSize (ProcessWindowSize _) = True
isProcessWindowSize _ = False
-}
{-
getProcessActivateFun :: ProcessAttribute IF_MVAR(,ps) -> (ps -> GUI ps ps)
getProcessActivateFun (ProcessActivate f) = f
-}
getProcessCloseFun :: ProcessAttribute IF_MVAR(-> GUI (),ps -> ps -> GUI ps ps)
getProcessCloseFun (ProcessClose f) = f
{-
getProcessDeactivateFun :: ProcessAttribute IF_MVAR(,ps) -> (ps -> GUI ps ps)
getProcessDeactivateFun (ProcessDeactivate f) = f

getProcessOpenFilesFun :: ProcessAttribute IF_MVAR(,ps) -> ProcessOpenFilesFunction IF_MVAR(,ps)
getProcessOpenFilesFun (ProcessOpenFiles f) = f

getProcessToolbarAtt :: ProcessAttribute IF_MVAR(,ps) -> [ToolbarItem IF_MVAR(,ps)]
getProcessToolbarAtt (ProcessToolbar t) = t

getProcessWindowPosAtt :: ProcessAttribute IF_MVAR(,ps) -> ItemPos
getProcessWindowPosAtt (ProcessWindowPos pos) = pos

getProcessWindowResizeFun :: ProcessAttribute IF_MVAR(,ps) -> ProcessWindowResizeFunction IF_MVAR(,ps)
getProcessWindowResizeFun (ProcessWindowResize f) = f

getProcessWindowSizeAtt :: ProcessAttribute IF_MVAR(,ps) -> Size
getProcessWindowSizeAtt (ProcessWindowSize size) = size
-}
