module StdReceiverAttribute (module StdReceiverAttribute, module StdReceiverDef) where


--	********************************************************************************
--	Clean Standard Object I/O library, version 1.2
--	
--	StdReceiverAttribute specifies which ReceiverAttributes are valid for each of 
--	the standard receivers.
--	Basic comparison operations and retrieval functions are also included.
--	********************************************************************************


import StdGUI
import StdIOCommon
import StdReceiverDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


{-	The following functions specify the valid attributes for each standard receiver.
-}

isValidReceiverAttribute :: ReceiverAttribute IF_MVAR(,ls ps) -> Bool
isValidReceiverAttribute (ReceiverInit _)        = True
isValidReceiverAttribute (ReceiverSelectState _) = True
isValidReceiverAttribute _                       = False

isValidReceiver2Attribute :: ReceiverAttribute IF_MVAR(,ls ps) -> Bool
isValidReceiver2Attribute (ReceiverInit _)        = True
isValidReceiver2Attribute (ReceiverSelectState _) = True
isValidReceiver2Attribute _                       = False


isReceiverInit :: ReceiverAttribute IF_MVAR(,ls ps) -> Bool
isReceiverInit (ReceiverInit _) = True
isReceiverInit _                = False

isReceiverSelectState :: ReceiverAttribute IF_MVAR(,ls ps) -> Bool
isReceiverSelectState (ReceiverSelectState _) = True
isReceiverSelectState _                       = False

{-	TCP support not yet incorporated
isReceiverConnectedReceivers :: ReceiverAttribute IF_MVAR(,ls ps) -> Bool
isReceiverConnectedReceivers (ReceiverConnectedReceivers _) = True
isReceiverConnectedReceivers _                              = False
-}

getReceiverInitFun :: ReceiverAttribute IF_MVAR(,ls ps) -> GUIFun IF_MVAR((),ls ps)
getReceiverInitFun (ReceiverInit f) = f

getReceiverSelectStateAtt :: ReceiverAttribute IF_MVAR(,ls ps) -> SelectState
getReceiverSelectStateAtt (ReceiverSelectState s) = s

{-	TCP support not yet incorporated
getReceiverConnectedReceivers :: ReceiverAttribute IF_MVAR(,ls ps) -> [Id] -- MW11++
getReceiverConnectedReceivers (ReceiverConnectedReceivers ids) = ids
-}
