module Windowaccess ( module Windowaccess, module Windowhandle ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Windowaccess defines access operations to Window(State)Handle(s).
--	********************************************************************************


import CleanExtras
import CleanStdFunc
import CleanStdMisc
import Commondef
import Ossystem
import Windowhandle
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


windowaccessFatalError :: String -> String -> x
windowaccessFatalError function error
	= dumpFatalError function "Windowaccess" error


--	Dummy values for window handles.

dummyWindowHandles :: WindowHandles IF_MVAR(,ps)
dummyWindowHandles
	= WindowHandles
		{ whsWindows       = undef
		, whsNrWindowBound = Infinite
		}

dummyWindowStateHandle :: WindowStateHandle IF_MVAR(,ps)
dummyWindowStateHandle
	= WindowStateHandle undef undef

#if MVAR
#else
dummyWindowLSHandle :: WindowLSHandle ls ps
dummyWindowLSHandle
	= WindowLSHandle
		{ wlsState    = undef
		, wlsHandle   = undef
		}
#endif

dummyWindowHandle :: WindowHandle IF_MVAR(,ls ps)
dummyWindowHandle
	= WindowHandle
		{ whKind      = undef
		, whTitle     = undef
		, whItemNrs   = undef
		, whItems     = undef
		, whAtts      = undef
		, whSize      = undef
		, whClosing   = undef
		}

#if MVAR
initWindowHandle :: Title -> WindowKind -> [WElementHandle] -> [WindowAttribute] -> WindowHandle
#else
initWindowHandle :: Title -> WindowKind -> [WElementHandle ls ps] -> [WindowAttribute ls ps] -> WindowHandle ls ps
#endif
initWindowHandle title wKind itemHs atts
	= WindowHandle
		{ whKind      = wKind
		, whTitle     = title
		, whItemNrs   = [1..]
		, whItems     = itemHs
		, whAtts      = atts
		, whSize      = zero
		, whClosing   = False
		}

--	Access to the additional WItemInfo field of a WItemHandle (partial functions!).

getWItemTextInfo :: WItemInfo IF_MVAR(,ls ps) -> TextInfo
getWItemTextInfo (WTextInfo info) = info

getWItemEditInfo :: WItemInfo IF_MVAR(,ls ps) -> EditInfo
getWItemEditInfo (WEditInfo info) = info

getWItemButtonInfo :: WItemInfo IF_MVAR(,ls ps) -> ButtonInfo
getWItemButtonInfo (WButtonInfo info) = info


--	For internal identification of windows/dialogs Id and OSWindowPtr (Integer) can be used.

data	WID				-- Identify a window/dialog either
	= ById  !Id			-- by its Id, or
	| ByPtr !OSWindowPtr		-- by its OSWindowPtr

class ToWID x where
	toWID :: x -> WID

instance ToWID Id where
	toWID id = ById id
instance ToWID Int where
	toWID wPtr = ByPtr wPtr
instance ToWID WIDS where
	toWID wids = ByPtr (wPtr wids)

widbyId :: WID -> Bool
widbyId (ById _) = True
widbyId _        = False

widbyPtr :: WID -> Bool
widbyPtr (ByPtr _) = True
widbyPtr _         = False

widgetId :: WID -> Id
widgetId (ById id) = id

widgetPtr :: WID -> OSWindowPtr
widgetPtr (ByPtr ptr) = ptr

identifyWIDS :: WID -> WIDS -> Bool
identifyWIDS (ById  id)  (WIDS {wId=wId})   = id==wId
identifyWIDS (ByPtr ptr) (WIDS {wPtr=wPtr}) = ptr==wPtr

identifyMaybeId :: Id -> Maybe Id -> Bool
identifyMaybeId id (Just id') = id==id'
identifyMaybeId _ _ = False


--	Calculating the view frame of window/compound with visibility of scrollbars.

getCompoundContentRect :: OSWindowMetrics -> (Bool,Bool) -> Rect -> Rect
getCompoundContentRect wMetrics (visHScroll,visVScroll) itemRect
	| visHScroll && visVScroll = itemRect {rright=r',rbottom=b'}
	| visHScroll               = itemRect {          rbottom=b'}
	| visVScroll               = itemRect {rright=r'           }
	| otherwise                = itemRect
	where
		r'                 = rright  itemRect - osmVSliderWidth  wMetrics
		b'                 = rbottom itemRect - osmHSliderHeight wMetrics

getCompoundHScrollRect :: OSWindowMetrics -> (Bool,Bool) -> Rect -> Rect
getCompoundHScrollRect wMetrics (visHScroll,visVScroll) itemRect
	| not visHScroll = zero
	| visVScroll     = itemRect {rtop=b',rright=r'}
	| otherwise      = itemRect {rtop=b'}
	where
		r'       = rright  itemRect - osmVSliderWidth  wMetrics
		b'       = rbottom itemRect - osmHSliderHeight wMetrics

getCompoundVScrollRect :: OSWindowMetrics -> (Bool,Bool) -> Rect -> Rect
getCompoundVScrollRect wMetrics (visHScroll,visVScroll) itemRect
	| not visVScroll = zero
	| visHScroll     = itemRect {rleft=r',rbottom=b'}
	| otherwise      = itemRect {rleft=r'}
	where
		r'       = rright  itemRect - osmVSliderWidth  wMetrics
		b'       = rbottom itemRect - osmHSliderHeight wMetrics


getWindowContentRect :: OSWindowMetrics -> (Bool,Bool) -> Rect -> Rect
getWindowContentRect wMetrics (visHScroll,visVScroll) itemRect
	| visHScroll && visVScroll = itemRect {rright=r',rbottom=b'}
	| visHScroll               = itemRect {          rbottom=b'}
	| visVScroll               = itemRect {rright=r'           }
	| otherwise                = itemRect
	where
		r'                 = rright  itemRect - osmVSliderWidth  wMetrics
		b'                 = rbottom itemRect - osmHSliderHeight wMetrics

getWindowHScrollRect :: OSWindowMetrics -> (Bool,Bool) -> Rect -> Rect
getWindowHScrollRect wMetrics (visHScroll,visVScroll) (Rect {rleft=rleft,rtop=rtop,rright=rright,rbottom=rbottom})
	| not visHScroll = zero
	| otherwise      = Rect {rleft=rleft-1, rtop=b', rright=if visVScroll then r'+1 else rright+1, rbottom=rbottom+1}
	where
		r'       = rright  - osmVSliderWidth  wMetrics + 1
		b'       = rbottom - osmHSliderHeight wMetrics + 1

getWindowVScrollRect :: OSWindowMetrics -> (Bool,Bool) -> Rect -> Rect
getWindowVScrollRect wMetrics (visHScroll,visVScroll) (Rect {rleft=rleft,rtop=rtop,rright=rright,rbottom=rbottom})
	| not visVScroll = zero
	| otherwise      = Rect {rleft=r', rtop=rtop-1, rright=rright+1, rbottom=if visHScroll then b'+1 else rbottom+1}
	where
		r'       = rright  - osmVSliderWidth  wMetrics + 1
		b'       = rbottom - osmHSliderHeight wMetrics + 1


--	Access operations on WindowStateHandles:

getWindowStateHandleWIDS :: WindowStateHandle IF_MVAR(,ps) -> (WIDS,WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleWIDS wsH = (wshIds wsH,wsH)
#else
getWindowStateHandleWIDS wsH@(WindowStateHandle wshIds _) = (wshIds,wsH)
#endif

getWindowStateHandleWindowKind :: WindowStateHandle IF_MVAR(,ps) -> (WindowKind,WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleWindowKind wsH@(WindowStateHandle {wshHandle=Just (WindowHandle {whKind=whKind})}) = (whKind,wsH)
#else
getWindowStateHandleWindowKind wsH@(WindowStateHandle _ (Just (WindowLSHandle {wlsHandle=WindowHandle {whKind=whKind}}))) = (whKind,wsH)
#endif

getWindowStateHandleWindowTitle :: WindowStateHandle IF_MVAR(,ps) -> (Title,WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleWindowTitle wsH@(WindowStateHandle {wshHandle=Just (WindowHandle {whTitle=whTitle})}) = (whTitle,wsH)
#else
getWindowStateHandleWindowTitle wsH@(WindowStateHandle _ (Just (WindowLSHandle {wlsHandle=WindowHandle {whTitle=whTitle}}))) = (whTitle,wsH)
#endif

getWindowStateHandleItemNrs :: WindowStateHandle IF_MVAR(,ps) -> ([Int],WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleItemNrs wsH@(WindowStateHandle {wshHandle=Just (WindowHandle {whItemNrs=whItemNrs})}) = (whItemNrs,wsH)
#else
getWindowStateHandleItemNrs wsH@(WindowStateHandle _ (Just (WindowLSHandle {wlsHandle=WindowHandle {whItemNrs=whItemNrs}}))) = (whItemNrs,wsH)
#endif

getWindowStateHandleSelect :: WindowStateHandle IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps))
getWindowStateHandleSelect wsH = (True,wsH)
{-	SelectState currently always True. As soon as whSelect is added, replace code by:
#if MVAR
getWindowStateHandleSelect wsH@(WindowStateHandle {wshHandle=Just (WindowHandle {whSelect=whSelect})}) = (whSelect,wsH)
#else
getWindowStateHandleSelect wsH@(WindowStateHandle _ (Just (WindowLSHandle {wlsHandle=WindowHandle {whSelect=whSelect}}))) = (whSelect,wsH)
#endif
-}

getWindowStateHandleActive :: WindowStateHandle IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleActive wsH@(WindowStateHandle {wshIds=WIDS {wActive=wActive}}) = (wActive,wsH)
#else
getWindowStateHandleActive wsH@(WindowStateHandle (WIDS {wActive=wActive}) _) = (wActive,wsH)
#endif

getWindowStateHandleSize :: WindowStateHandle IF_MVAR(,ps) -> (Size,WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleSize wsH@(WindowStateHandle {wshHandle=Just (WindowHandle {whSize=whSize})}) = (whSize,wsH)
#else
getWindowStateHandleSize wsH@(WindowStateHandle _ (Just (WindowLSHandle {wlsHandle=WindowHandle {whSize=whSize}}))) = (whSize,wsH)
#endif

getWindowStateHandleClosing :: WindowStateHandle IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps))
#if MVAR
getWindowStateHandleClosing wsH@(WindowStateHandle {wshHandle=Just (WindowHandle {whClosing=whClosing})}) = (whClosing,wsH)
#else
getWindowStateHandleClosing wsH@(WindowStateHandle _ (Just (WindowLSHandle {wlsHandle=WindowHandle {whClosing=whClosing}}))) = (whClosing,wsH)
#endif

isWindowStateHandlePlaceHolder :: WindowStateHandle IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps))
#if MVAR
isWindowStateHandlePlaceHolder wsH@(WindowStateHandle {wshHandle=Nothing}) = (True,wsH)
#else
isWindowStateHandlePlaceHolder wsH@(WindowStateHandle _ Nothing) = (True,wsH)
#endif
isWindowStateHandlePlaceHolder wsH
	= (False,wsH)

identifyWindowStateHandle :: WID -> WindowStateHandle IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps))
identifyWindowStateHandle wid wsH
	= let (wids,wsH1) = getWindowStateHandleWIDS wsH
	  in  (identifyWIDS wid wids,wsH1)

setWindowStateHandleWIDS :: WIDS -> WindowStateHandle IF_MVAR(,ps) -> WindowStateHandle IF_MVAR(,ps)
#if MVAR
setWindowStateHandleWIDS wids wsH = wsH {wshIds=wids}
#else
setWindowStateHandleWIDS wids (WindowStateHandle _ wlsH) = WindowStateHandle wids wlsH
#endif

setWindowStateHandleWindowTitle :: Title -> WindowStateHandle IF_MVAR(,ps) -> WindowStateHandle IF_MVAR(,ps)
#if MVAR
setWindowStateHandleWindowTitle title wsH@(WindowStateHandle {wshHandle=Just wH})
	= wsH {wshHandle=Just (wH {whTitle=title})}
#else
setWindowStateHandleWindowTitle title (WindowStateHandle wids (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
	= WindowStateHandle wids (Just (wlsH {wlsHandle=wH {whTitle=title}}))
#endif

setWindowStateHandleItemNrs :: [Int] -> WindowStateHandle IF_MVAR(,ps) -> WindowStateHandle IF_MVAR(,ps)
#if MVAR
setWindowStateHandleItemNrs itemNrs wsH@(WindowStateHandle {wshHandle=Just wH})
	= wsH {wshHandle=Just (wH {whItemNrs=itemNrs})}
#else
setWindowStateHandleItemNrs itemNrs (WindowStateHandle wids (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
	= WindowStateHandle wids (Just (wlsH {wlsHandle=wH {whItemNrs=itemNrs}}))
#endif

setWindowStateHandleActive :: Bool -> WindowStateHandle IF_MVAR(,ps) -> WindowStateHandle IF_MVAR(,ps)
#if MVAR
setWindowStateHandleActive active wsH@(WindowStateHandle {wshIds=wids})
	= wsH {wshIds=wids {wActive=active}}
#else
setWindowStateHandleActive active (WindowStateHandle wids wlsH)
	= WindowStateHandle (wids {wActive=active}) wlsH
#endif

setWindowStateHandleSize :: Size -> WindowStateHandle IF_MVAR(,ps) -> WindowStateHandle IF_MVAR(,ps)
#if MVAR
setWindowStateHandleSize size wsH@(WindowStateHandle {wshHandle=Just wH})
	= wsH {wshHandle=Just (wH {whSize=size})}
#else
setWindowStateHandleSize size (WindowStateHandle wids (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
	= WindowStateHandle wids (Just (wlsH {wlsHandle=wH {whSize=size}}))
#endif

setWindowStateHandleClosing :: Bool -> WindowStateHandle IF_MVAR(,ps) -> WindowStateHandle IF_MVAR(,ps)
#if MVAR
setWindowStateHandleClosing closing wsH@(WindowStateHandle {wshHandle=Just wH})
	= wsH {wshHandle=Just (wH {whClosing=closing})}
#else
setWindowStateHandleClosing closing (WindowStateHandle wids (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
	= WindowStateHandle wids (Just (wlsH {wlsHandle=wH {whClosing=closing}}))
#endif


{-	Access operations on the margins and item space attributes of the window attributes.
	getWindow((H/V)Margin/ItemSpace)s type metrics atts
		retrieves the indicated attribute if present from the attribute list. If the attribute
		could not be found, the appropriate default value is returned. 
-}
getWindowHMargins :: WindowKind -> OSWindowMetrics -> [WindowAttribute IF_MVAR(,ls ps)] -> (Int,Int)
getWindowHMargins wKind wMetrics atts
	= (defaultLeft,defaultRight)
--	= getWindowHMarginAtt (snd (cselect isWindowHMargin (WindowHMargin defaultLeft defaultRight) atts))
	where
		(defaultLeft,defaultRight) = case wKind of
						IsDialog -> (osmHorMargin wMetrics,osmHorMargin wMetrics)
						other    -> (0,0)

getWindowVMargins :: WindowKind -> OSWindowMetrics -> [WindowAttribute IF_MVAR(,ls ps)] -> (Int,Int)
getWindowVMargins wKind wMetrics atts
	= (defaultTop,defaultBottom)
--	= getWindowVMarginAtt (snd (cselect isWindowVMargin (WindowVMargin defaultTop defaultBottom) atts))
	where
		(defaultTop,defaultBottom) = case wKind of
						IsDialog -> (osmVerMargin wMetrics,osmVerMargin wMetrics)
						other    -> (0,0)

getWindowItemSpaces :: WindowKind -> OSWindowMetrics -> [WindowAttribute IF_MVAR(,ls ps)] -> (Int,Int)
getWindowItemSpaces wKind wMetrics atts
	= (defaultHor,defaultVer)
--	= getWindowItemSpaceAtt (snd (cselect isWindowItemSpace (WindowItemSpace defaultHor defaultVer) atts))
	where
		(defaultHor,defaultVer) = case wKind of
						IsDialog -> (osmHorItemSpace wMetrics,osmVerItemSpace wMetrics)
						other    -> (0,0)


--	Search, get, and set WindowStateHandles.

getWindowHandlesActiveWindow :: WindowHandles IF_MVAR(,ps) -> (Maybe WIDS,WindowHandles IF_MVAR(,ps))
getWindowHandlesActiveWindow wHs@(WindowHandles {whsWindows=wsHs})
	= (if found then Just wids else Nothing,wHs {whsWindows=wsHs1})
	where
		(found,wids,wsHs1) = access get_active_wids undef wsHs
		
		get_active_wids :: WindowStateHandle IF_MVAR(,ps) -> ((Bool,WIDS),WindowStateHandle IF_MVAR(,ps))
		get_active_wids wsH
			= let (wids,wsH1) = getWindowStateHandleWIDS wsH
			  in  ((wActive wids,wids),wsH1)

--	getWindowHandlesActiveModalDialog assumes that all modal dialogues are at the front of the list
getWindowHandlesActiveModalDialog :: WindowHandles IF_MVAR(,ps) -> (Maybe WIDS,WindowHandles IF_MVAR(,ps))
getWindowHandlesActiveModalDialog wHs
	= (Nothing,wHs)
{-	When modal dialogues have been included, this should be the implementation:
getWindowHandlesActiveModalDialog wHs@(WindowHandles {whsWindows=[]})
	= (Nothing,wHs)
getWindowHandlesActiveModalDialog wHs@(WindowHandles {whsWindows=(wsH:wsHs)})
	| mode/=Modal
		= (Nothing,  wHs {whsWindows=(wsH1:wsHs)})
	| otherwise
		= (Just wids,wHs {whsWindows=(wsH2:wsHs)})
	where
		(mode,wsH1) = getWindowStateHandleWindowMode wsH
		(wids,wsH2) = getWindowStateHandleWIDS wsH1
-}

hasWindowHandlesWindow :: WID -> WindowHandles IF_MVAR(,ps) -> (Bool,WindowHandles IF_MVAR(,ps))
hasWindowHandlesWindow wid wHs@(WindowHandles {whsWindows=whsWindows})
	= (found,wHs {whsWindows=whsWindows1})
	where
		(found,whsWindows1) = haswindow wid whsWindows
		
		haswindow :: WID -> [WindowStateHandle IF_MVAR(,ps)] -> (Bool,[WindowStateHandle IF_MVAR(,ps)])
		haswindow wid (wsH:wsHs)
			| identifyWIDS wid wIds
				= (True, wsH1:wsHs)
			| otherwise
				= let (found,wsHs1) = haswindow wid wsHs
			          in  (found,wsH1:wsHs1)
			where
				(wIds,wsH1) = getWindowStateHandleWIDS wsH
		haswindow _ _
			= (False,[])

getWindowHandlesWindow :: WID -> WindowHandles IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps),WindowHandles IF_MVAR(,ps))
getWindowHandlesWindow wid wHs@(WindowHandles {whsWindows=whsWindows})
	= (ok,wsH,wHs {whsWindows=whsWindows1})
	where
		(ok,wsH,whsWindows1) = getwindow wid whsWindows
		
		getwindow :: WID -> [WindowStateHandle IF_MVAR(,ps)] -> (Bool,WindowStateHandle IF_MVAR(,ps),[WindowStateHandle IF_MVAR(,ps)])
		getwindow wid (wsH:wsHs)
			| identifyWIDS wid wIds
			      = (True,wsH1,(WindowStateHandle wIds Nothing):wsHs)
			| otherwise
			      = let (found,wsH',wsHs1) = getwindow wid wsHs
			        in  (found,wsH',wsH1:wsHs1)
			where
				(wIds,wsH1)            = getWindowStateHandleWIDS wsH
		getwindow _ _
			= (False,dummyWindowStateHandle,[])

removeWindowHandlesWindow :: WID -> WindowHandles IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps),WindowHandles IF_MVAR(,ps))
removeWindowHandlesWindow wid wHs@(WindowHandles {whsWindows=whsWindows})
	= (ok,wsH,wHs {whsWindows=whsWindows1})
	where
		(ok,wsH,whsWindows1) = uremove (identifyWindowStateHandle wid) dummyWindowStateHandle whsWindows
		
		identifyWindowStateHandle :: WID -> WindowStateHandle IF_MVAR(,ps) -> (Bool,WindowStateHandle IF_MVAR(,ps))
		identifyWindowStateHandle wid wsH
			= (identifyWIDS wid wIds,wsH1)
			where
				(wIds,wsH1) = getWindowStateHandleWIDS wsH

setWindowHandlesWindow :: WindowStateHandle IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps)
setWindowHandlesWindow wsH wHs@(WindowHandles {whsWindows=whsWindows})
	| isPlaceHolder
		= windowaccessFatalError "setWindowHandlesWindow" "WindowStateHandle argument should not be a place holder"
	| otherwise
		= let (wIds,wsH2) = getWindowStateHandleWIDS wsH1
	          in  wHs {whsWindows=setwindow wIds wsH2 whsWindows}
	where
		(isPlaceHolder,wsH1) = isWindowStateHandlePlaceHolder wsH
		
		setwindow :: WIDS -> WindowStateHandle IF_MVAR(,ps) -> [WindowStateHandle IF_MVAR(,ps)] -> [WindowStateHandle IF_MVAR(,ps)]
		setwindow wids' wsH' (wsH:wsHs)
			| wids/=wids'
				= wsH1:setwindow wids' wsH' wsHs
			| fst (isWindowStateHandlePlaceHolder wsH1)
				= wsH':wsHs
			| otherwise
				= windowaccessFatalError "setWindowHandlesWindow" "place holder expected instead of WindowStateHandle"
			where
				(wids,wsH1) = getWindowStateHandleWIDS wsH
		setwindow _ _ _
			= windowaccessFatalError "setWindowHandlesWindow" "place holder not found"

addBehindWindowHandlesWindow :: WID -> WindowStateHandle IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps) -> (WIDS,WindowHandles IF_MVAR(,ps))
addBehindWindowHandlesWindow behindWID wsH wHs@(WindowHandles {whsWindows=whsWindows})
	| isPlaceHolder
		= windowaccessFatalError "addBehindWindowHandlesWindow" "WindowStateHandle argument should not be a place holder"
	| otherwise
		= let (behindWIDS,whsWindows1) = stackBehind behindWID wsH1 whsWindows
	          in  (behindWIDS,wHs {whsWindows=whsWindows1})
	where
		(isPlaceHolder,wsH1)       = isWindowStateHandlePlaceHolder wsH
		
		stackBehind :: WID -> WindowStateHandle IF_MVAR(,ps) -> [WindowStateHandle IF_MVAR(,ps)] -> (WIDS,[WindowStateHandle IF_MVAR(,ps)])
		stackBehind behindWID wsH (wsH':wsHs)
			| not (identifyWIDS behindWID wids')
				= let (behindWIDS,wsHs1) = stackBehind behindWID wsH wsHs
			          in  (behindWIDS,wsH'':wsHs1)
			| otherwise
				= (wids',wsH'':wsH:wsHs)
			where
				(wids',wsH'') = getWindowStateHandleWIDS wsH'
		stackBehind _ _ _
			= windowaccessFatalError "addBehindWindowHandlesWindow" "behind window could not be found"

addWindowHandlesWindow :: Index -> WindowStateHandle IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps)
addWindowHandlesWindow index wsH wHs@(WindowHandles {whsWindows=whsWindows})
	= wHs {whsWindows=insert (max 0 index) wsH whsWindows}
	where
		insert :: Index -> x -> [x] -> [x]
		insert 0 x ys
			= x:ys
		insert i x (y:ys)
			= y:insert (i-1) x ys
		insert _ x _
			= [x]

addWindowHandlesActiveWindow :: WindowStateHandle IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps)
addWindowHandlesActiveWindow wsH wHs@(WindowHandles {whsWindows=whsWindows})
	= wHs {whsWindows=wsH:whsWindows}


{-	Checking WindowBounds:
-}
checkZeroWindowHandlesBound :: WindowHandles IF_MVAR(,ps) -> (Bool,WindowHandles IF_MVAR(,ps))
checkZeroWindowHandlesBound wHs@(WindowHandles {whsNrWindowBound=whsNrWindowBound})
	= (zeroBound whsNrWindowBound,wHs)

decreaseWindowHandlesBound :: WindowHandles IF_MVAR(,ps) -> WindowHandles IF_MVAR(,ps)
decreaseWindowHandlesBound wHs@(WindowHandles {whsNrWindowBound=whsNrWindowBound})
	= wHs {whsNrWindowBound=decBound whsNrWindowBound}


{-	getInitActiveControl retrieves the OSWindowPtr of the control that has the initial input focus.
	It is assumed that the control identified by the WindowInitActive attribute exists.
-}
getInitActiveControl :: WindowHandle IF_MVAR(,ls ps) -> (OSWindowPtr,WindowHandle IF_MVAR(,ls ps))
getInitActiveControl wH@(WindowHandle {whItems=itemHs,whAtts=whAtts})
	= (if isJust maybeItemPtr then fromJust maybeItemPtr else osNoWindowPtr,wH {whItems=itemHs1})
	where
	{-	(hasInitActiveAtt,initActiveAtt)= cselect isWindowInitActive undef whAtts
		initActiveId			= if hasInitActiveAtt (Just (getWindowInitActiveAtt initActiveAtt)) Nothing
	REPLACED BY:
	-}	initActiveId			= Nothing
		(maybeItemPtr,itemHs1)		= accessWElementHandles (condition initActiveId) (toSt wItemPtr) itemHs
		
		condition initActiveId@(Just _) itemH
			= initActiveId==wItemId itemH
		condition _ itemH
			= wItemKind itemH==IsEditControl


{-	Generate internal numbers for all WElementHandles which wItemNr==0.
-}
genWElementItemNrs :: [Int] -> [WElementHandle IF_MVAR(,ls ps)] -> ([Int],[WElementHandle IF_MVAR(,ls ps)])
genWElementItemNrs nrs (itemH:itemHs)
	= (nrs2,itemH1:itemHs1)
	where
		(nrs1,itemH1)  = genWElementNrs     nrs  itemH
		(nrs2,itemHs1) = genWElementItemNrs nrs1 itemHs
		
		genWElementNrs :: [Int] -> WElementHandle IF_MVAR(,ls ps) -> ([Int],WElementHandle IF_MVAR(,ls ps))
		genWElementNrs nrs wItemH@(WItemHandle {wItemNr=wItemNr})
			| wItemNr/=0
				= (nrs,wItemH)
			| otherwise
				= (tail nrs,wItemH {wItemNr=head nrs})
		
		genWElementNrs nrs (WListLSHandle itemHs)
			= let (nrs1,itemHs1)  = genWElementItemNrs nrs itemHs
			  in  (nrs1,WListLSHandle itemHs1)
		
#if MVAR
#else
		genWElementNrs nrs (WExtendLSHandle addLS itemHs)
			= let (nrs1,itemHs1) = genWElementItemNrs nrs itemHs
			  in  (nrs1,WExtendLSHandle addLS itemHs1)
		
		genWElementNrs nrs (WChangeLSHandle newLS itemHs)
			= let (nrs1,itemHs1) = genWElementItemNrs nrs itemHs
			  in  (nrs1,WChangeLSHandle newLS itemHs1)
#endif

genWElementItemNrs nrs _
	= (nrs,[])



{-	General access functions on WItemHandles in (WindowStateHandle IF_MVAR(,ps)) and [WElementHandle IF_MVAR(,ls ps)] respectively. 
	The (St   (WElementHandle IF_MVAR(,ls ps)) x) is applied to a WItemHandle iff
	the (Cond (WElementHandle IF_MVAR(,ls ps))) holds.
	Here we take advantage of the fact that GHC supports Rank2 polymorphism.
	accessWItemHandle     aborts if applied to a window placeholder.
	accessWElementHandles returns Nothing if no WItemHandle could be found.
-}
#if MVAR
accessWItemHandle :: String -> Cond WElementHandle -> St WElementHandle x -> WindowStateHandle -> (Maybe x,WindowStateHandle)
accessWItemHandle _ cond f wsH@(WindowStateHandle {wshHandle=Just wH})
#else
accessWItemHandle :: String
                  -> (forall ls. Cond (WElementHandle ls ps))
                  -> (forall ls. St   (WElementHandle ls ps) x)
                  -> WindowStateHandle ps
                  -> (Maybe x,WindowStateHandle ps)
accessWItemHandle _ cond f (WindowStateHandle wids (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
#endif
	= let (maybe,itemHs) = accessWElementHandles cond f (whItems wH)
#if MVAR
	  in  (maybe,wsH {wshHandle=Just (wH {whItems=itemHs})})
#else
	  in  (maybe,WindowStateHandle wids (Just (wlsH {wlsHandle=wH {whItems=itemHs}})))
#endif
	where
#if MVAR
		accessWElementHandles :: Cond WElementHandle -> St WElementHandle x -> [WElementHandle] -> (Maybe x,[WElementHandle])
#else
		accessWElementHandles :: (forall ls. Cond (WElementHandle ls ps)) -> (forall ls. St (WElementHandle ls ps) x) -> [WElementHandle ls ps]
		                      -> (Maybe x,[WElementHandle ls ps])
#endif
		accessWElementHandles cond f (itemH:itemHs)
			= let (maybe,itemH1) = accessWElementHandle cond f itemH
			  in  if   isJust maybe
			      then (maybe,itemH1:itemHs)
			      else let (maybe1,itemHs1) = accessWElementHandles cond f itemHs
			           in  (maybe1,itemH1:itemHs1)
			where
#if MVAR
				accessWElementHandle :: Cond WElementHandle -> St WElementHandle x -> WElementHandle -> (Maybe x,WElementHandle)
#else
				accessWElementHandle :: (forall ls. Cond (WElementHandle ls ps)) -> (forall ls. St (WElementHandle ls ps) x) -> WElementHandle ls ps
				                     -> (Maybe x,WElementHandle ls ps)
#endif
				accessWElementHandle cond f (WListLSHandle itemHs)
					= let (maybe,itemHs1) = accessWElementHandles cond f itemHs
					  in  (maybe,WListLSHandle itemHs1)
#if MVAR
#else
				accessWElementHandle cond f (WExtendLSHandle addLS itemHs)
					= let (maybe,itemHs1) = accessWElementHandles cond f itemHs
					  in  (maybe,WExtendLSHandle addLS itemHs1)
				
				accessWElementHandle cond f (WChangeLSHandle newLS itemHs)
					= let (maybe,itemHs1) = accessWElementHandles cond f itemHs
					  in  (maybe,WChangeLSHandle newLS itemHs1)
#endif
				accessWElementHandle cond f itemH
					| cond itemH
						= let (x,itemH1) = f itemH
						  in  (Just x,itemH1)
					| otherwise
						= (Nothing,itemH)
		accessWElementHandles _ _ []
			= (Nothing,[])

accessWItemHandle functionName _ _ _
	= windowaccessFatalError functionName "window placeholder not expected"

#if MVAR
accessWElementHandles :: Cond WElementHandle -> St WElementHandle x -> [WElementHandle] -> (Maybe x,[WElementHandle])
#else
accessWElementHandles :: (forall ls. Cond (WElementHandle ls ps))
                      -> (forall ls. St   (WElementHandle ls ps) x)
                      -> [WElementHandle ls ps]
                      -> (Maybe x,[WElementHandle ls ps])
#endif
accessWElementHandles cond f (itemH:itemHs)
	= let (maybe,itemH1) = accessWElementHandle cond f itemH
	  in  if   isJust maybe
	      then (maybe,itemH1:itemHs)
	      else let (maybe1,itemHs1) = accessWElementHandles cond f itemHs
	           in  (maybe1,itemH1:itemHs1)
	where
#if MVAR
		accessWElementHandle :: Cond WElementHandle -> St WElementHandle x -> WElementHandle -> (Maybe x,WElementHandle)
#else
		accessWElementHandle :: (forall ls. Cond (WElementHandle ls ps)) -> (forall ls. St (WElementHandle ls ps) x) -> WElementHandle ls ps
		                     -> (Maybe x,WElementHandle ls ps)
#endif
		accessWElementHandle cond f (WListLSHandle itemHs)
			= let (maybe,itemHs1) = accessWElementHandles cond f itemHs
			  in  (maybe,WListLSHandle itemHs1)
#if MVAR
#else
		accessWElementHandle cond f (WExtendLSHandle addLS itemHs)
			= let (maybe,itemHs1) = accessWElementHandles cond f itemHs
			  in  (maybe,WExtendLSHandle addLS itemHs1)
		
		accessWElementHandle cond f (WChangeLSHandle newLS itemHs)
			= let (maybe,itemHs1) = accessWElementHandles cond f itemHs
			  in  (maybe,WChangeLSHandle newLS itemHs1)
#endif
		accessWElementHandle cond f itemH
			| cond itemH
				= let (x,itemH1) = f itemH
				  in  (Just x,itemH1)
			| otherwise
				= (Nothing,itemH)
accessWElementHandles _ _ []
	= (Nothing,[])
