module Windowcreate ( openwindow
                    , bufferDelayedEvents
                    , checkZeroWindowBound
                    , decreaseWindowBound
                    ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Windowcreate contains the window creation functions.
--	********************************************************************************


import CleanStdFunc
import Commondef
import Controlcreate
import IOExts (fixIO)
import IOstate
import Osevent
import Ostoolbox
import Oswindow
import StdWindowAttribute
import Windowaccess
import Windowhandle
import Windowvalidate
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


windowcreateFatalError :: String -> String -> x
windowcreateFatalError function error
	= dumpFatalError function "Windowcreate" error


{-	Open a modeless window/dialogue.
-}
#if MVAR
openwindow :: Id -> WindowHandle -> GUI ()
openwindow wId wH
#else
openwindow :: Id -> WindowLSHandle ls ps -> ps -> GUI ps ps
openwindow wId (WindowLSHandle {wlsState=wlsState,wlsHandle=wH}) ps
#endif
	= do {
		(found,wDevice) <- accIOEnv (ioStGetDevice WindowDevice);
		if	not found      -- This condition should never occur: WindowDevice must have been 'installed'
		then	windowcreateFatalError "openwindow" "could not retrieve WindowSystemState from IOSt"
		else
		let	windows        = windowSystemStateGetWindowHandles wDevice
		in
		do {
			(delayinfo,wPtr,index,wH1,windows1) <- openAnyWindow wId wH windows;
			let
			    (windowInit,wH2) = getWindowHandleInit wH1
			    wIds       = WIDS {wId=wId,wPtr=wPtr,wActive=False}
#if MVAR
			    wsH        = WindowStateHandle {wshIds=wIds, wshHandle=Just wH2}
			    windows2   = addWindowHandlesWindow index wsH windows1
			in
			do {
				appIOEnv (ioStSetDevice (WindowSystemState windows2));
				bufferDelayedEvents delayinfo;
				windowInit
			}
#else
			in
			do {
				ps1 <- toGUI (doInitIO (windowInit (wlsState,ps))
				                       (\ls ioState -> ioStSetDevice
				                                           (WindowSystemState
				                                                (addWindowHandlesWindow index 
				                                                (WindowStateHandle wIds (Just (WindowLSHandle {wlsState=ls,wlsHandle=wH2})))
				                                                windows1))
				                                           ioState));
				bufferDelayedEvents delayinfo;
				return ps1
			}
#endif
		}
	  }
	where
#if MVAR
#else
		doInitIO :: GUI ps (ls,ps) -> (ls -> IOSt ps -> IOSt ps) -> IOSt ps -> IO (ps,IOSt ps)
		doInitIO initGUI setWindowLS ioState
			= do {
				r <- fixIO (\st -> fromGUI initGUI (setWindowLS (fst (fst st)) ioState));
				let ((_,ps1),ioState1) = r
				in  return (ps1,ioState1)
			  }
#endif
		
		getWindowHandleInit :: WindowHandle IF_MVAR(,ls ps) -> (GUIFun IF_MVAR((),ls ps),WindowHandle IF_MVAR(,ls ps))
		getWindowHandleInit wH
#if MVAR
			= (getWindowInitFun (snd (cselect isWindowInit (WindowInit (return ())) (whAtts wH))),wH)
#else
			= (getWindowInitFun (snd (cselect isWindowInit (WindowInit return) (whAtts wH))),wH)
#endif
	
	{-	openAnyWindow creates a window.
			After validating the window and its controls, the window and its controls are created.
			The return OSWindowPtr is the OSWindowPtr of the newly created window.
			The return Index is the proper insert position in the WindowHandles list.
	-}
#if MVAR
		openAnyWindow :: Id -> WindowHandle -> WindowHandles
		              -> GUI ([DelayActivationInfo],OSWindowPtr,Index,WindowHandle,WindowHandles)
#else
		openAnyWindow :: Id -> WindowHandle ls ps -> WindowHandles ps
		              -> GUI ps ([DelayActivationInfo],OSWindowPtr,Index,WindowHandle ls ps,WindowHandles ps)
#endif
		openAnyWindow wId wH windows
			= do {
				liftIO osInitialiseWindows;		-- initialise windows toolbox
				osdinfo  <- accIOEnv ioStGetOSDInfo;
				wMetrics <- accIOEnv ioStGetOSWindowMetrics;
				(index,pos,size,originv,wH1,windows1)
				         <- liftIO (validateWindow wMetrics osdinfo wH windows);
				let (behindPtr,windows2) = getStackBehindWindow index windows1
				in  do {
					(delayinfo,wPtr,osdinfo1,wH2) <- liftIO (createAnyWindow wMetrics behindPtr wId pos size originv osdinfo wH1);
				--	wH3                           <- validateWindowClipState wMetrics True wPtr wH2;
					appIOEnv (ioStSetOSDInfo osdinfo1);
					liftIO (osInvalidateWindow wPtr);
					return (delayinfo,wPtr,index,wH2,windows2)
				    }
			  }

{-	In this implementation, Windows are not taken into account. 
-}
createAnyWindow :: OSWindowMetrics -> OSWindowPtr -> Id -> Point2 -> Size -> Vector2 -> OSDInfo -> WindowHandle IF_MVAR(,ls ps)
                                                  -> IO ([DelayActivationInfo],OSWindowPtr,OSDInfo,WindowHandle IF_MVAR(,ls ps))
createAnyWindow wMetrics behindPtr wId (Point2 {x=x,y=y}) (Size {w=w,h=h}) originv osdinfo wH
	| whKind wH==IsWindow
		= windowcreateFatalError "createAnyWindow" "Windows can not be created in this version"
	| whKind wH==IsDialog
		= do {
			(delay_info,wPtr,wH1) <- osCreateDialog False isClosable (whTitle wH) pos size behindPtr
			                                        (\wH->(osNoWindowPtr,wH))	-- should become: getInitActiveControl
			                                        (createWindowControls wMetrics)
			                                        (\_ _ _ wH->return wH)		-- should become: (updateWindowControl wMetrics wId size)
			                                        osdinfo wH;
			return (delay_info,wPtr,osdinfo,wH1)
		  }
	where
		isClosable = contains isWindowClose (whAtts wH)
		pos        = (x,y)
		size       = (w,h)
		
	--	createWindowControls creates the controls.
		createWindowControls :: OSWindowMetrics -> OSWindowPtr -> WindowHandle IF_MVAR(,ls ps) -> IO (WindowHandle IF_MVAR(,ls ps))
		createWindowControls wMetrics wPtr wH
			= do {
				itemHs <- createControls wMetrics Nothing Nothing True wPtr (whItems wH);
				return wH {whItems=itemHs}
			  }
		
	--	updateWindowControl updates customised controls.
		updateWindowControl :: OSWindowMetrics -> Id -> (Int,Int) -> OSWindowPtr -> OSWindowPtr -> OSPictContext -> WindowHandle IF_MVAR(,ls ps)
	                                                                                                             -> IO (WindowHandle IF_MVAR(,ls ps))
		updateWindowControl wMetrics wId (w,h) wPtr cPtr osPict wH
			= return wH

getStackBehindWindow :: Index -> WindowHandles IF_MVAR(,ps) -> (OSWindowPtr,WindowHandles IF_MVAR(,ps))
getStackBehindWindow 0 wsHs
	= (osNoWindowPtr,wsHs)
getStackBehindWindow index wsHs@(WindowHandles {whsWindows=whsWindows})
	= (wPtr wids,wsHs {whsWindows=before++(wsH1:after)})
	where
		(before,(wsH:after)) = splitAt (index-1) whsWindows
		(wids,wsH1)          = getWindowStateHandleWIDS wsH


{-	bufferDelayedEvents buffers the events in the OSEvents environment.
-}
bufferDelayedEvents :: [DelayActivationInfo] -> GUI IF_MVAR(,ps) ()
bufferDelayedEvents delayinfo
	= do {
		osEvents    <- ioStGetEvents;
		delayEvents <- liftIO (sequence (map toOSEvent delayinfo));
		ioStSetEvents (osAppendEvents delayEvents osEvents)
	  }
	where
		toOSEvent :: DelayActivationInfo -> IO SchedulerEvent
		toOSEvent (DelayActivatedWindow wPtr)
			= createOSActivateWindowEvent wPtr
		toOSEvent (DelayDeactivatedWindow wPtr)
			= createOSDeactivateWindowEvent wPtr
		toOSEvent (DelayActivatedControl wPtr cPtr)
			= createOSActivateControlEvent wPtr cPtr
		toOSEvent (DelayDeactivatedControl wPtr cPtr)
			= createOSDeactivateControlEvent wPtr cPtr


{-	WindowBound-checks for normal windows.
-}
checkZeroWindowBound :: IOSt IF_MVAR(,ps) -> (Bool,IOSt IF_MVAR(,ps))
checkZeroWindowBound ioState
	| not found
		= (False,ioState1)
	| otherwise
		= (isZero,ioStSetDevice (WindowSystemState wHs1) ioState1)
	where
		((found,wDevice),ioState1) = ioStGetDevice WindowDevice ioState
		wHs                        = windowSystemStateGetWindowHandles wDevice
		(isZero,wHs1)              = checkZeroWindowHandlesBound wHs

decreaseWindowBound :: IOSt IF_MVAR(,ps) -> IOSt IF_MVAR(,ps)
decreaseWindowBound ioState
	| not found
		= ioState1
	| otherwise
		= ioStSetDevice (WindowSystemState wHs1) ioState1
	where
		((found,wDevice),ioState1) = ioStGetDevice WindowDevice ioState
		wHs                        = windowSystemStateGetWindowHandles wDevice
		wHs1                       = decreaseWindowHandlesBound wHs
