module Windowhandle ( ControlState, WindowHandles(..), Commondef.Bound(..), WindowStateHandle(..), WIDS(..)
#if MVAR
#else
                    , WindowLSHandle(..)
#endif
                    , WindowHandle(..), WindowKind(..)
                    , WElementHandle(..)
                    , LayoutInfo(..), WItemInfo(..), ButtonInfo(..), EditInfo(..), TextInfo(..)
                    , ControlKind(..)
                    , wElementHandleToControlState, controlStateToWElementHandle
                    , Ospicture.OSPictContext, Ospicture.Origin, Ospicture.Pen(..), Ospicture.Font, Ospicture.Colour(..)
                    , module StdControlDef, module StdWindowDef
                    , module Ostypes
                    ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Windowhandle contains the internal data structures that represent the 
--	state of windows. 
--	********************************************************************************


import Commondef
import Ospicture
import Ostypes
import StdControlDef
import StdWindowDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


type	ControlState IF_MVAR(,ls ps)
	= WElementHandle IF_MVAR(,ls ps)				-- is a WElementHandle

data	WindowHandles IF_MVAR(,ps)
	= WindowHandles
		{ whsWindows      :: [WindowStateHandle IF_MVAR(,ps)]	-- The windows and their controls of a process
		, whsNrWindowBound:: !Bound				-- The maximum number of windows that are allowed to be opened
		}
#if MVAR
data	WindowStateHandle
	= WindowStateHandle 
		{ wshIds          :: WIDS				-- A window is identified by an Id and an OSWindowPtr
		, wshHandle       :: Maybe WindowHandle			-- If used as placeholder, Nothing; otherwise window with local state
		}
#else
data	WindowStateHandle ps
	= forall ls . 
	  WindowStateHandle 
	        WIDS							-- A window is identified by an Id and an OSWindowPtr
		(Maybe (WindowLSHandle ls ps))				-- If used as placeholder, Nothing; otherwise window with local state
data	WindowLSHandle ls ps
	= WindowLSHandle
		{ wlsState        :: ls					-- The local state of this window
		, wlsHandle       :: WindowHandle ls ps			-- The window implementation
		}
#endif
data	WIDS
	= WIDS
		{ wId             :: Id					-- Id  of window
		, wPtr            :: !OSWindowPtr			-- Ptr of window
		, wActive         :: !Bool				-- The window is the active window (True) or not (False)
		}
data	WindowHandle IF_MVAR(,ls ps)
	= WindowHandle
		{ whKind          :: !WindowKind			-- The window kind (Window or Dialog)
		, whTitle         :: !Title				-- The window title
		, whItemNrs       :: [Int]				-- The list of free system item numbers for all controls
		, whItems         :: [WElementHandle   IF_MVAR(,ls ps)]	-- The window controls
		, whAtts          :: ![WindowAttribute IF_MVAR(,ls ps)]	-- The window attributes
		, whSize          :: !Size				-- The exact size of the window
		, whClosing       :: !Bool				-- Flag: the window is being closed (True)
		}
data	WindowKind
	= IsWindow							-- Window kind
	| IsDialog							-- Dialog kind
	deriving (Eq)
data	WElementHandle IF_MVAR(,ls ps)
#if MVAR
	= WListLSHandle [WElementHandle]
#else
	= WListLSHandle       [WElementHandle  ls      ps]
	| forall ls1 . 
	  WExtendLSHandle ls1 [WElementHandle (ls1,ls) ps]
	| forall ls1 . 
	  WChangeLSHandle ls1 [WElementHandle  ls1     ps]
#endif
	| WItemHandle
		{ wItemId         :: Maybe Id				-- If the control has a (ControlId id) attribute, then Just id; Nothing
		, wItemNr         :: Int				-- The internal nr of this control  (generated from whItemNrs)
		, wItemKind       :: ControlKind			-- The sort of control
		, wItemInfo       :: WItemInfo         IF_MVAR(,ls ps)	-- Additional information of the control
		, wItemAtts       :: [ControlAttribute IF_MVAR(,ls ps)]	-- The control attributes
		, wItemPos        :: Point2				-- The exact position of the item
		, wItemSize       :: Size				-- The exact size of the item
		, wItemPtr        :: OSWindowPtr			-- The ptr to the item (OSNoWindowPtr if no handle)
		, wItemLayoutInfo :: LayoutInfo				-- Additional information on layout
		}
data	LayoutInfo							-- The layout attribute of the layout root control is:
	= LayoutFix							-- ItemPos    = Fix
	| LayoutFrame							-- any other attribute
	deriving (Eq)
data	WItemInfo IF_MVAR(,ls ps)
	= WButtonInfo ButtonInfo
	| WEditInfo   EditInfo
	| WTextInfo   TextInfo
data	ButtonInfo
	= ButtonInfo
		{ buttonInfoText  :: String				-- The title of the button control
		}
data	EditInfo
	= EditInfo
		{ editInfoText    :: !String				-- The content of the edit control
		, editInfoWidth   :: Int				-- The width (in pixels) of the edit item
		, editInfoNrLines :: Int				-- The nr of complete visible lines of the edit item
		}
data	TextInfo
	= TextInfo
		{ textInfoText    :: String				-- The content of the text control
		}
data	ControlKind
	= IsButtonControl
	| IsEditControl
	| IsTextControl
	deriving (Eq,Show)


instance Eq WIDS where
	(==) wids wids' = wPtr wids==wPtr wids' && wId wids==wId wids'


--	Conversion functions from ControlState to WElementHandle, and vice versa:

wElementHandleToControlState :: WElementHandle IF_MVAR(,ls ps) -> ControlState IF_MVAR(,ls ps)
wElementHandleToControlState wH = wH

controlStateToWElementHandle :: ControlState IF_MVAR(,ls ps) -> WElementHandle IF_MVAR(,ls ps)
controlStateToWElementHandle wH = wH
