module Wstate ( WindowHandle'(..), WElementHandle'(..), WRecursiveKind(..), WItemInfo'(..), WindowAttribute'(..), ControlAttribute'(..)
              , retrieveWindowHandle', getWindowHandle', getWElementHandles', getWElementHandle'
              , insertWindowHandle',   setWindowHandle', setWElementHandles'
              , module Windowhandle
              ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Wstate defines the WindowHandle' data type.
--	This type is a derivative of (WindowHandle ls ps). It contains basically the 
--	same fields of (WindowHandle ls ps) but does not depend on ls and ps.
--	Note that in the MVAR version, WindowHandle' is actually equal to WindowHandle.
--	There's some redundancy here that could be removed.
--	********************************************************************************


import Commondef
import Oswindow
import Windowhandle
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


wstateFatalError :: String -> String -> x
wstateFatalError rule error
	= dumpFatalError rule "Wstate" error


data	WindowHandle'
	= WindowHandle'
		{ whKind'          :: WindowKind			-- The window kind (Window or Dialog)
		, whTitle'         :: Title				-- The window title
		, whItemNrs'       :: [Int]				-- The list of free system item numbers for all controls
		, whItems'         :: [WElementHandle']			-- The window controls
		, whAtts'          :: [WindowAttribute']		-- The window attributes
		, whSize'          :: Size				-- The exact size of the window
		, whClosing'       :: Bool				-- Flag: the window is being closed (True)
		}
data	WElementHandle'
	= WItemHandle'
		{ wItemId'         :: Maybe Id				-- If the control has a (ControlId id) attribute, then Just id; Nothing
		, wItemNr'         :: Int				-- The internal nr of this control  (generated from whIds)
		, wItemKind'       :: ControlKind			-- The sort of control
		, wItemInfo'       :: WItemInfo'			-- Additional information of the control
		, wItemAtts'       :: [ControlAttribute']		-- The control attributes
		, wItemPos'        :: !Point2				-- The exact position of the item
		, wItemSize'       :: Size				-- The exact size of the item
		, wItemPtr'        :: OSWindowPtr			-- The ptr to the item (OSNoWindowPtr if no handle)
		, wItemLayoutInfo' :: LayoutInfo			-- Additional information on layout
		}
	| WRecursiveHandle' [WElementHandle'] WRecursiveKind
data	WRecursiveKind
	= IsWListLSHandle
#if MVAR
#else
	| IsWExtendLSHandle
	| IsWChangeLSHandle
#endif
	deriving (Eq)
data	WItemInfo'
	= ButtonInfo' ButtonInfo					-- In case of ButtonControl: the button information
	| EditInfo'   EditInfo						-- In case of EditControl  : the edit text information
	| TextInfo'   TextInfo						-- In case of TextControl  : the text information
data	WindowAttribute'
	= WindowClose'
	| WindowId'            Id
	| WindowInit'
	| WindowViewSize'      Size
data	ControlAttribute'
	= ControlFunction'
	| ControlId'           Id
	| ControlKeyboard'     SelectState
	| ControlModsFunction'
	| ControlPos'          ItemPos
	| ControlWidth'        ControlWidth


#if MVAR
retrieveWindowHandle' :: WindowStateHandle -> IO (WindowHandle',WindowStateHandle)
retrieveWindowHandle' wsH@(WindowStateHandle {wshIds=wshIds,wshHandle=Just wH})
#else
retrieveWindowHandle' :: WindowStateHandle ps -> IO (WindowHandle',WindowStateHandle ps)
retrieveWindowHandle' (WindowStateHandle wshIds (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
#endif
	= do {
		(wH',wH1) <- getWindowHandle' (wPtr wshIds) wH;
#if MVAR
		return (wH',wsH {wshHandle=Just wH1})
#else
		return (wH',WindowStateHandle wshIds (Just (wlsH {wlsHandle=wH1})))
#endif
	  }
retrieveWindowHandle' _
	= wstateFatalError "retrieveWindowHandle'" "unexpected window placeholder argument"

#if MVAR
insertWindowHandle' :: WindowHandle' -> WindowStateHandle -> WindowStateHandle
insertWindowHandle' wH' wsH@(WindowStateHandle {wshHandle=Just wH})
#else
insertWindowHandle' :: WindowHandle' -> WindowStateHandle ps -> WindowStateHandle ps
insertWindowHandle' wH' (WindowStateHandle wshIds (Just wlsH@(WindowLSHandle {wlsHandle=wH})))
#endif
	= let wH1 = setWindowHandle' wH' wH
	  in
#if MVAR
	      wsH {wshHandle=Just wH1}
#else
	      WindowStateHandle wshIds (Just (wlsH {wlsHandle=wH1}))
#endif
insertWindowHandle' _ _
	= wstateFatalError "insertWindowHandle'" "unexpected window placeholder argument"

#if MVAR
getWindowHandle' :: OSWindowPtr -> WindowHandle -> IO (WindowHandle',WindowHandle)
#else
getWindowHandle' :: OSWindowPtr -> WindowHandle ls ps -> IO (WindowHandle',WindowHandle ls ps)
#endif
getWindowHandle' wptr wH
	= do {
		(items',items) <- getWElementHandles' wptr (whItems wH);
		return ( WindowHandle'
		            { whKind'    = whKind    wH
		            , whTitle'   = whTitle   wH
		            , whItemNrs' = whItemNrs wH
		            , whItems'   = items'
		            , whAtts'    = map getWAtt (whAtts wH)
		            , whSize'    = whSize    wH
		            , whClosing' = whClosing wH
		            }
		       , wH {whItems=items}
		       )
	  }
	where
		getWAtt :: WindowAttribute IF_MVAR(,ls ps) -> WindowAttribute'
		getWAtt (WindowClose    _)    = WindowClose'
		getWAtt (WindowId       id)   = WindowId'       id
		getWAtt (WindowInit     _)    = WindowInit'
		getWAtt (WindowViewSize size) = WindowViewSize' size

#if MVAR
getWElementHandles' :: OSWindowPtr -> [WElementHandle] -> IO ([WElementHandle'],[WElementHandle])
#else
getWElementHandles' :: OSWindowPtr -> [WElementHandle ls p] -> IO ([WElementHandle'],[WElementHandle ls p])
#endif
getWElementHandles' wptr (itemH:itemHs)
	= do {
		(itemH', itemH1)  <- getWElementHandle'  wptr itemH;
		(itemHs',itemHs1) <- getWElementHandles' wptr itemHs;
		return (itemH':itemHs',itemH1:itemHs1)
	  }
getWElementHandles' _ _
	= return ([],[])

#if MVAR
getWElementHandle' :: OSWindowPtr -> WElementHandle -> IO (WElementHandle',WElementHandle)
#else
getWElementHandle' :: OSWindowPtr -> WElementHandle ls ps -> IO (WElementHandle',WElementHandle ls ps)
getWElementHandle' wptr (WExtendLSHandle addLS itemHs)
	= do {
		(itemHs',itemHs1) <- getWElementHandles' wptr itemHs;
		return (WRecursiveHandle' itemHs' IsWExtendLSHandle,WExtendLSHandle addLS itemHs1)
	}

getWElementHandle' wptr (WChangeLSHandle newLS itemHs)
	= do {
		(itemHs',itemHs1) <- getWElementHandles' wptr itemHs;
		return (WRecursiveHandle' itemHs' IsWChangeLSHandle,WChangeLSHandle newLS itemHs1)
	  }
#endif
getWElementHandle' wptr (WListLSHandle itemHs)
	= do {
		(itemHs',itemHs1) <- getWElementHandles' wptr itemHs;
		return (WRecursiveHandle' itemHs' IsWListLSHandle,WListLSHandle itemHs1)
	  }

getWElementHandle' wptr itemH@(WItemHandle _ _ _ _ _ _ _ _ _)
	= do {
		(info',info1) <- getWItemInfo' wptr (wItemPtr itemH) (wItemInfo itemH);
		return ( WItemHandle'
		             { wItemId'         = wItemId   itemH
		             , wItemNr'         = wItemNr   itemH
		             , wItemKind'       = wItemKind itemH
		             , wItemInfo'       = info'
		             , wItemAtts'       = map getWItemAtt' (wItemAtts itemH)
		             , wItemPos'        = wItemPos  itemH
		             , wItemSize'       = wItemSize itemH
		             , wItemPtr'        = wItemPtr  itemH
		             , wItemLayoutInfo' = wItemLayoutInfo itemH
		             }
		        , itemH {wItemInfo=info1}
		        )
	  }
	where
#if MVAR
		getWItemAtt' :: ControlAttribute -> ControlAttribute'
#else
		getWItemAtt' :: ControlAttribute ls ps -> ControlAttribute'
#endif
		getWItemAtt' (ControlFunction     _)          = ControlFunction'
		getWItemAtt' (ControlId           id)         = ControlId'       id
		getWItemAtt' (ControlKeyboard     _ select _) = ControlKeyboard' select
		getWItemAtt' (ControlModsFunction _)          = ControlModsFunction'
		getWItemAtt' (ControlPos          pos)        = ControlPos'      pos
		getWItemAtt' (ControlWidth        width)      = ControlWidth'    width
		
#if MVAR
		getWItemInfo' :: OSWindowPtr -> OSWindowPtr -> WItemInfo -> IO (WItemInfo',WItemInfo)
#else
		getWItemInfo' :: OSWindowPtr -> OSWindowPtr -> WItemInfo ls ps -> IO (WItemInfo',WItemInfo ls ps)
#endif
		
	{-	getWItemInfo' wptr itemPtr info@(RadioInfo {radioItems=radioItems,radioLayout=radioLayout,radioIndex=radioIndex})
			= return ( RadioInfo'
			               { radioItems'  = map getRadioInfo' radioItems
			               , radioLayout' = radioLayout
			               , radioIndex'  = radioIndex
			               }
			         , info
			         )
			where
				getRadioInfo' :: RadioItemInfo IF_MVAR(,ls ps) -> RadioItemInfo'
				getRadioInfo' info@(RadioItemInfo {radioItem=(text,width,_)})
					= RadioItemInfo'
					     { radioItem'     = (text,width)
					     , radioItemPos'  = radioItemPos  info
					     , radioItemSize' = radioItemSize info
					     , radioItemPtr'  = radioItemPtr  info
					     }
	-}	
	{-	getWItemInfo' wptr itemPtr info@(CheckInfo {checkItems=checkItems,checkLayout=checkLayout})
			= return ( CheckInfo'
			               { checkItems'  = map getCheckInfo' checkItems
			               , checkLayout' = checkLayout
			               }
			         , info
			         )
			where
				getCheckInfo' :: CheckItemInfo IF_MVAR(,ls ps) -> CheckItemInfo'
				getCheckInfo' info@(CheckItemInfo {checkItem=(text,width,mark,_)})
					= { checkItem'     = (text,width,mark)
					  , checkItemPos'  = checkItemPos  info
					  , checkItemSize' = checkItemSize info
					  , checkItemPtr'  = checkItemPtr  info
					  }
	-}	
	{-	getWItemInfo' wptr itemPtr info@(PopUpInfo {popUpInfoItems=popUpInfoItems,popUpInfoIndex=popUpInfoIndex,popUpInfoEdit=popUpInfoEdit})
			= do {
				infoEdit <- getPopUpInfoEdit' popUpInfoEdit;
				return ( PopUpInfo'
				             { popUpInfoItems' = map fst popUpInfoItems
				             , popUpInfoIndex' = popUpInfoIndex
				             , popUpInfoEdit'  = infoEdit
				             }
				       , info
				       )
			  }
			where
				getPopUpInfoEdit' :: Maybe PopUpEditInfo -> IO (Maybe PopUpEditInfo)
				getPopUpInfoEdit' Nothing
					= return Nothing
				getPopUpInfoEdit' (Just info=:{popUpEditPtr})
					= do {
						content <- osGetEditControlText wptr popUpEditPtr;
						return Just info {popUpEditText=content}
					  }
	-}	
	{-	getWItemInfo' wptr itemPtr info@(SliderInfo {sliderInfoDir=sliderInfoDir,sliderInfoLength=sliderInfoLength,sliderInfoState=sliderInfoState})
			= return ( SliderInfo'
			               { sliderInfoDir'    = sliderInfoDir
			               , sliderInfoLength' = sliderInfoLength
			               , sliderInfoState'  = sliderInfoState
			               }
			         , info
			         )
	-}	
		getWItemInfo' wptr itemPtr info@(WTextInfo textInfo)
			= return (TextInfo' textInfo,info)
		
		getWItemInfo' wptr itemPtr info@(WEditInfo editInfo)
			= do {
				content <- osGetEditControlText wptr itemPtr;
				return (EditInfo' (editInfo {editInfoText=content}),info)
			  }
		
		getWItemInfo' wptr itemPtr info@(WButtonInfo buttonInfo)
			= return (ButtonInfo' buttonInfo,info)
		
	{-	getWItemInfo' wptr itemPtr info@(CustomButtonInfo customButtonInfo)
			= return (CustomButtonInfo' customButtonInfo,info)
	-}	
	{-	getWItemInfo' wptr itemPtr info@(CustomInfo customInfo)
			= return (CustomInfo' customInfo,info)
	-}	
	{-	getWItemInfo' wptr itemPtr info@(CompoundInfo compoundInfo)
			= return (CompoundInfo' compoundInfo,info)
	-}	
	{-	getWItemInfo' wptr itemPtr info@(ReceiverInfo _)
			= return (NoWItemInfo',info)
	-}	
	{-	getWItemInfo' wptr itemPtr info@NoWItemInfo
			= (NoWItemInfo',info)
	-}

#if MVAR
setWindowHandle' :: WindowHandle' -> WindowHandle -> WindowHandle
#else
setWindowHandle' :: WindowHandle' -> WindowHandle ls ps -> WindowHandle ls ps
#endif
setWindowHandle' wH' wH
	= wH { whTitle   = whTitle'   wH'
	     , whItemNrs = whItemNrs' wH'
	     , whItems   = itemHs
	     , whAtts    = atts
	     , whSize    = whSize'    wH'
	     , whClosing = whClosing' wH'
	     }
	where
		itemHs = setWElementHandles' (whItems' wH') (whItems wH)
		atts   = setWAtts (whAtts' wH') (whAtts wH)
		
#if MVAR
		setWAtts :: [WindowAttribute'] -> [WindowAttribute] -> [WindowAttribute]
#else
		setWAtts :: [WindowAttribute'] -> [WindowAttribute ls ps] -> [WindowAttribute ls ps]
#endif
		setWAtts (att':atts') (att:atts)
			= (setWAtt att' att):(setWAtts atts' atts)
		setWAtts [] []
			= []
		setWAtts _ _
			= wstateFatalError "setWindowHandle'" "incompatible number of WindowAttributes"
		
#if MVAR
		setWAtt :: WindowAttribute' -> WindowAttribute -> WindowAttribute
#else
		setWAtt :: WindowAttribute' -> WindowAttribute ls ps -> WindowAttribute ls ps
#endif
		setWAtt  WindowClose'          att@(WindowClose    _) = att
		setWAtt (WindowId'       _)    att@(WindowId       _) = att
		setWAtt  WindowInit'           att@(WindowInit     _) = att
		setWAtt (WindowViewSize' size) att@(WindowViewSize _) = WindowViewSize size
		setWAtt _ _
			= wstateFatalError "setWindowHandle'" "WindowAttributes do not match pairwise"


#if MVAR	
setWElementHandles' :: [WElementHandle'] -> [WElementHandle] -> [WElementHandle]
#else
setWElementHandles' :: [WElementHandle'] -> [WElementHandle ls ps] -> [WElementHandle ls ps]
#endif

setWElementHandles' (itemH':itemHs') (itemH:itemHs)
	= setWElementHandle' itemH' itemH : setWElementHandles' itemHs' itemHs

setWElementHandles' [] []
	= []

setWElementHandles' _ _
	= wstateFatalError "setWElementHandles'" "incompatible number of WElementHandles"


#if MVAR
setWElementHandle' :: WElementHandle' -> WElementHandle -> WElementHandle
#else
setWElementHandle' :: WElementHandle' -> WElementHandle ls ps -> WElementHandle ls ps
#endif

setWElementHandle' (WRecursiveHandle' itemHs' IsWListLSHandle) (WListLSHandle itemHs)
	= WListLSHandle (setWElementHandles' itemHs' itemHs)
#if MVAR
#else
setWElementHandle' (WRecursiveHandle' itemHs' IsWExtendLSHandle) (WExtendLSHandle addLS itemHs)
	=  WExtendLSHandle addLS (setWElementHandles' itemHs' itemHs)

setWElementHandle' (WRecursiveHandle' itemHs' IsWChangeLSHandle) (WChangeLSHandle newLS itemHs)
	=  WChangeLSHandle newLS (setWElementHandles' itemHs' itemHs)
#endif

setWElementHandle' itemH'@(WItemHandle' _ _ _ _ _ _ _ _ _) itemH@(WItemHandle _ _ _ _ _ _ _ _ _)
	= itemH { wItemNr         = wItemNr'         itemH'
	        , wItemInfo       = wItemInfo itemH--info1
	        , wItemAtts       = wItemAtts itemH--atts1
	        , wItemPos        = wItemPos'        itemH'
	        , wItemSize       = wItemSize'       itemH'
	        , wItemLayoutInfo = wItemLayoutInfo' itemH'
	        }
	where
		info1   = setWItemInfo' (wItemInfo' itemH') (wItemInfo itemH)
		atts1   = setWItemAtts' (wItemAtts' itemH') (wItemAtts itemH)
		
#if MVAR
		setWItemAtts' :: [ControlAttribute'] -> [ControlAttribute] -> [ControlAttribute]
#else
		setWItemAtts' :: [ControlAttribute'] -> [ControlAttribute ls ps] -> [ControlAttribute ls ps]
#endif
		setWItemAtts' (att':atts') (att:atts)
			= (setWItemAtt' att' att):(setWItemAtts' atts' atts)
		setWItemAtts' [] []
			= []
		setWItemAtts' _ _
			= wstateFatalError "setWElementHandle'" "incompatible number of ControlAttributes"
		
#if MVAR
		setWItemAtt' :: ControlAttribute' -> ControlAttribute -> ControlAttribute
#else
		setWItemAtt' :: ControlAttribute' -> ControlAttribute ls ps -> ControlAttribute ls ps
#endif
		setWItemAtt'  ControlFunction'             att@(ControlFunction     _) = att
		setWItemAtt' (ControlId'           _)      att@(ControlId           _) = att
		setWItemAtt' (ControlKeyboard'     select) att@(ControlKeyboard s _ f) = ControlKeyboard s select f
		setWItemAtt'  ControlModsFunction'         att@(ControlModsFunction _) = att
		setWItemAtt' (ControlPos'          pos)    att@(ControlPos          _) = ControlPos      pos
		setWItemAtt' (ControlWidth'        width)  att@(ControlWidth        _) = ControlWidth    width
		setWItemAtt' att' att
			= wstateFatalError "setWElementHandle'" "ControlAttributes do not match pairwise"
		
#if MVAR
		setWItemInfo' :: WItemInfo' -> WItemInfo -> WItemInfo
#else
		setWItemInfo' :: WItemInfo' -> WItemInfo ls ps -> WItemInfo ls ps
#endif
		
	{-	setWItemInfo' info'@(RadioInfo' _) info@(RadioInfo _)
			= info {radioItems=setRadioInfos (radioItems' info') (radioItems info),radioIndex=radioIndex' info'}
			where
				setRadioInfos :: [RadioItemInfo'] -> [RadioItemInfo IF_MVAR(,ls ps)] -> [RadioItemInfo IF_MVAR(,ls ps)]
				setRadioInfos (info':infos') (info:infos)
					= (setRadioInfo info' info):(setRadioInfos infos' infos)
					where
						setRadioInfo :: RadioItemInfo' -> RadioItemInfo IF_MVAR(,ls ps) -> RadioItemInfo IF_MVAR(,ls ps)
						setRadioInfo item'@(RadioItemInfo' {radioItem'=(item',s'),radioItemPos',radioItemSize'})
						             item@(RadioItemInfo {radioItem=(_,_,f)})
							= item {radioItem=(item',s',f),radioItemPos=radioItemPos',radioItemSize=radioItemSize'}
				setRadioInfos [] []
					= []
				setRadioInfos _ _
					= wstateFatalError "setWElementHandle'" "incompatible RadioInfo"
	-}	
	{-	setWItemInfo' info'@(CheckInfo' _) info@(CheckInfo _)
			= info {checkItems=setCheckInfos (checkItems' info') (checkItems info)}
			where
				setCheckInfos :: [CheckItemInfo'] -> [CheckItemInfo IF_MVAR(,ls ps)] -> [CheckItemInfo IF_MVAR(,ls ps)]
				setCheckInfos (info':infos') (info:infos)
					= (setCheckInfo info' info):(setCheckInfos infos' infos)
					where
						setCheckInfo :: CheckItemInfo' -> CheckItemInfo IF_MVAR(,ls ps) -> CheckItemInfo IF_MVAR(,ls ps)
						setCheckInfo item'@(CheckItemInfo' {checkItem'=(text',s',mark'),checkItemPos',checkItemSize'}
						             item@{checkItem=(_,_,_,f)}
							= item {checkItem=(text',s',mark',f),checkItemPos=checkItemPos',checkItemSize=checkItemSize'}
				setCheckInfos [] []
					= []
				setCheckInfos _ _
					= wstateFatalError "setWElementHandle'" "incompatible CheckInfo"
	-}	
	{-	setWItemInfo' info'@(PopUpInfo' {popUpInfoItems'=texts',popUpInfoIndex'=i,popUpInfoEdit'}) info@(PopUpInfo {popUpInfoItems=items})
			= info {popUpInfoItems=setpopuptexts texts' items,popUpInfoIndex=i,popUpInfoEdit=popUpInfoEdit'}
			where
				setpopuptexts :: [String] -> [PopUpControlItem IF_MVAR(,ls ps)] -> [PopUpControlItem IF_MVAR(,ls ps)]
				setpopuptexts (text:texts) ((_,f):items)
					= (text,f):setpopuptexts texts items
				setpopuptexts [] []
					= []
				setpopuptexts _ _
					= wstateFatalError "setWElementHandle'" "incompatible PopUpInfo"
	-}	
	{-	setWItemInfo' (SliderInfo' {sliderInfoDir'=dir,sliderInfoLength'=length,sliderInfoState'=state}) info@(SliderInfo _)
			= info {sliderInfoDir=dir,sliderInfoLength=length,sliderInfoState=state}
	-}	
		setWItemInfo' (TextInfo' textInfo) (WTextInfo _)
			= WTextInfo textInfo
		
		setWItemInfo' (EditInfo' editInfo) (WEditInfo _)
			= WEditInfo editInfo
		
		setWItemInfo' (ButtonInfo' buttonInfo) (WButtonInfo _)
			= WButtonInfo buttonInfo
		
	{-	setWItemInfo' (CustomButtonInfo' info) (CustomButtonInfo _)
			= CustomButtonInfo info
	-}	
	{-	setWItemInfo' (CustomInfo' info) (CustomInfo _)
			= CustomInfo info
	-}	
	{-	setWItemInfo' (CompoundInfo' info) (CompoundInfo _)
			= CompoundInfo info
	-}	
	{-	setWItemInfo' NoWItemInfo' info
			= info
	-}	
		setWItemInfo' _ _
			= wstateFatalError "setWElementHandle'" "incompatible WItemInfo"

setWElementHandle' _ _
	= wstateFatalError "setWElementHandle'" "WElementHandles do not match pairwise"
