module Wstateaccess ( setWElements
                    , setArgWElements
                    , setAllWElements
                    , setWElement
                    , setWItemHandle
                    , getWItemTextInfo', getWItemEditInfo', getWItemButtonInfo'
                    , iscontrolid',  iscontrolpos', iscontrolkeyboard'
                    , getcontrolid', getcontrolpos'
                    , module Wstate
                    ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Wstateaccess contains useful access operations on WItemHandle'.
--	********************************************************************************


import CleanStdList
import Commondef
import Id
import Wstate


{-	Higher order monadic access functions on [WElementHandle']
	Although all functions are parameterised with (... WElementHandle' ...) function, this function
	will only be applied to the WItemHandle' alternative of WElementHandle'.
-}

setWElements :: (WElementHandle' -> ([arg],s) -> IO (WElementHandle',([arg],s))) -> [WElementHandle'] -> ([arg],s) -> IO ([WElementHandle'],([arg],s))
setWElements f itemHs args_s@(args,s)
	| isEmpty args || isEmpty itemHs
		= return (itemHs,args_s)
	| otherwise
		= do {
			(itemH1, args_s1) <- setWElements' f itemH   args_s;
			(itemHs2,args_s2) <- setWElements  f itemHs1 args_s1;
			return (itemH1 : itemHs2, args_s2)
		  }
	where
		(itemH, itemHs1)  = hdtl itemHs
		
		setWElements' :: (WElementHandle' -> ([arg],s) -> IO (WElementHandle',([arg],s))) -> WElementHandle' -> ([arg],s) -> IO (WElementHandle',([arg],s))
		setWElements' f itemH@(WItemHandle' _ _ _ _ _ _ _ _ _) args_s
			= f itemH args_s
		setWElements' f (WRecursiveHandle' itemHs wRecKind) args_s
			= do {
				(itemHs1,args_s1) <- setWElements f itemHs args_s;
				return (WRecursiveHandle' itemHs1 wRecKind,args_s1)
			  }

setArgWElements :: (WElementHandle' -> [arg] -> IO (WElementHandle',[arg])) -> [WElementHandle'] -> [arg] -> IO ([WElementHandle'],[arg])
setArgWElements f itemHs args
	| isEmpty args || isEmpty itemHs
		= return (itemHs,args)
	| otherwise
		= do {
			(itemH1, args1) <- setArgWElements' f itemH   args;
			(itemHs2,args2) <- setArgWElements  f itemHs1 args1;
			return (itemH1 : itemHs2, args2)
		  }
	where
		(itemH, itemHs1)  = hdtl itemHs
		
		setArgWElements' :: (WElementHandle' -> [arg] -> IO (WElementHandle',[arg])) -> WElementHandle' -> [arg] -> IO (WElementHandle',[arg])
		setArgWElements' f itemH@(WItemHandle' _ _ _ _ _ _ _ _ _) args
			= f itemH args
		setArgWElements' f (WRecursiveHandle' itemHs wRecKind) args
			= do {
				(itemHs1,args1) <- setArgWElements f itemHs args;
				return (WRecursiveHandle' itemHs1 wRecKind,args1)
			  }

setAllWElements :: (WElementHandle' -> s -> IO (WElementHandle',s)) -> [WElementHandle'] -> s -> IO ([WElementHandle'],s)
setAllWElements f (itemH:itemHs) s
	= do {
		(itemH1, s1) <- setWElement     f itemH  s;
		(itemHs1,s2) <- setAllWElements f itemHs s1;
		return (itemH1:itemHs1,s2)
	  }
	where
		setWElement :: (WElementHandle' -> s -> IO (WElementHandle',s)) -> WElementHandle' -> s -> IO (WElementHandle',s)
		setWElement f itemH@(WItemHandle' _ _ _ _ _ _ _ _ _) s
			= f itemH s
		setWElement f (WRecursiveHandle' itemHs wRecKind) s
			= do {
				(itemHs1,s1) <- setAllWElements f itemHs s;
				return (WRecursiveHandle' itemHs1 wRecKind,s1)
			  }
setAllWElements _ _ s
	= return ([],s)

setWElement :: (Id -> WElementHandle' -> s -> IO (Bool,WElementHandle',s)) -> Id -> [WElementHandle'] -> s -> IO (Bool,[WElementHandle'],s)
setWElement f id itemHs s
	| isEmpty itemHs
		= return (False,itemHs,s)
	| otherwise
		= do {
			(done1,itemH1,s1) <- setWElement' f id itemH s;
			if   done1
			then return (done1,itemH1:itemHs1,s1)
			else do {
					(done2,itemHs2,s2) <- setWElement f id itemHs1 s1;
					return (done2,itemH1:itemHs2,s2);
			     }
		  }
	where
		(itemH,itemHs1)    = hdtl itemHs
		
		setWElement' :: (Id -> WElementHandle' -> s -> IO (Bool,WElementHandle',s)) -> Id -> WElementHandle' -> s -> IO (Bool,WElementHandle',s)
		setWElement' f id itemH@(WItemHandle' _ _ _ _ _ _ _ _ _) s
			= f id itemH s
		setWElement' f id (WRecursiveHandle' itemHs wRecKind) s
			= do {
				(done,itemHs1,s1) <- setWElement f id itemHs s;
				return (done,WRecursiveHandle' itemHs1 wRecKind,s1)
			  }

setWItemHandle :: (WElementHandle' -> s -> IO (Bool,WElementHandle',s)) -> [WElementHandle'] -> s -> IO (Bool,[WElementHandle'],s)
setWItemHandle f itemHs s
	| isEmpty itemHs
		= return (False,itemHs,s)
	| otherwise
		= do {
			(done1,itemH1,s1) <- setWItemHandle' f itemH s;
			if   done1
			then return (done1,itemH1:itemHs1,s1)
			else do {
					(done2,itemHs2,s2) <- setWItemHandle f itemHs1 s1;
					return (done2,itemH1:itemHs2,s2);
			     }
		  }
	where
		(itemH,itemHs1) = hdtl itemHs
		
		setWItemHandle' :: (WElementHandle' -> s -> IO (Bool,WElementHandle',s)) -> WElementHandle' -> s -> IO (Bool,WElementHandle',s)
		setWItemHandle' f itemH@(WItemHandle' _ _ _ _ _ _ _ _ _) s
			= f itemH s
		setWItemHandle' f (WRecursiveHandle' itemHs wRecKind) s
			= do {
				(done,itemHs1,s1) <- setWItemHandle f itemHs s;
				return (done,WRecursiveHandle' itemHs1 wRecKind,s1)
			  }


--	Access to the additional WItemInfo' field of a WItemHandle' (partial functions!).

getWItemTextInfo' :: WItemInfo' -> TextInfo
getWItemTextInfo' (TextInfo' info) = info

getWItemEditInfo' :: WItemInfo' -> EditInfo
getWItemEditInfo' (EditInfo' info) = info

getWItemButtonInfo' :: WItemInfo' -> ButtonInfo
getWItemButtonInfo' (ButtonInfo' info) = info


--	General access rules for ControlAttribute':

iscontrolid' :: ControlAttribute' -> Bool
iscontrolid' (ControlId' _) = True
iscontrolid' _              = False

iscontrolpos' :: ControlAttribute' -> Bool
iscontrolpos' (ControlPos' _) = True
iscontrolpos' _               = False

iscontrolkeyboard' :: ControlAttribute' -> Bool
iscontrolkeyboard' (ControlKeyboard' _ ) = True
iscontrolkeyboard' _                     = False


getcontrolid' :: ControlAttribute' -> Id
getcontrolid' (ControlId' id) = id

getcontrolpos' :: ControlAttribute' -> ItemPos
getcontrolpos' (ControlPos' pos) = pos
