module Scheduler ( Context
                 , initContext
                 , handleEvents, chandleEvents, handleContextOSEvent, handleOneEventForDevices
                 , closeContext
                 , quitProcess
                 ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Scheduler contains the process creation, termination, and handling functions.
--	********************************************************************************


import ClCrossCall_12 (osInitToolbox)	-- Should actually be in a Os... module, but not Ostoolbox
import CleanStdFunc
import Commondef
import Id
import IOstate
import Osevent
import StdProcessDef
import Roundrobin
import Trace_12
import World
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


type	Context IF_MVAR(,ps)
	= PSt IF_MVAR(,ps)

schedulerFatalError :: String -> String -> x
schedulerFatalError rule message
	= dumpFatalError rule "Scheduler" message


--	Access functions on RuntimeState:

rsIsClosed :: RuntimeState -> Bool
rsIsClosed Closed = True
rsIsClosed _      = False


--	Access functions on PSt:

#if MVAR
appPIO :: IdFun IOSt -> IdFun PSt
appPIO f = f

accPIO :: St IOSt x -> St PSt x
accPIO f = f
#else
appPIO :: IdFun (IOSt ps) -> IdFun (PSt ps)
appPIO f pState@(PSt {io=ioState})
	= let ioState1 = f ioState
	  in  pState {io=ioState1}

accPIO :: St (IOSt ps) x -> St (PSt ps) x
accPIO f pState@(PSt {io=ioState})
	= let (x,ioState1)= f ioState
	  in  (x,pState {io=ioState1})
#endif


--	Starting an interactive process.

initContext :: [ProcessAttribute IF_MVAR(,ps)] -> ProcessInit IF_MVAR(,ps -> ps) -> DocumentInterface
            -> IO IF_MVAR(Context,(Context ps))
initContext processAtts ioDefInit IF_MVAR(,ps) xDI
	= do {
		trace "initContext: > loadWorld";
		w <- loadWorld;
		trace "initContext: loadWorld >";
		trace "initContext: > storeWorld";
		storeWorld w;
		trace "initContext: storeWorld >";
		trace "initContext: > osInitToolbox";
		osInitToolbox;
		trace "initContext: osInitToolbox >";
		trace "initContext: > emptyIOSt";
		ioState <- emptyIOSt initSystemId xDI processAtts ioDefInit;
		trace "initContext: emptyIOSt >";
#if MVAR
		return (ioStSetIdSeed w (ioStSetMaxIONr initSystemId ioState))
#else
		return (PSt {ls=ps,io=ioStSetIdSeed w (ioStSetMaxIONr initSystemId ioState)})
#endif
	     }


--	Handling events until termination of all interactive processes.

handleEvents :: IF_MVAR(Context -> IO Context,Context ps -> IO (Context ps))
handleEvents context
	= do {
		trace "handleEvents: > handleContextOSEvent";
		(_,context1) <- handleContextOSEvent osNullEvent context;
		trace "handleEvents: handleContextOSEvent >";
		trace "handleEvents: > osHandleEvents";
		c <- osHandleEvents (accPIO ioStClosed)
		               (accPIO ioStGetEvents)
		               (\(es,cs)->appPIO (ioStSetEvents es) cs)
		               {-contextGetSleepTime-}
		               handleContextOSEvent
		               context1;
		trace "handleEvents: osHandleEvents >";
		return c
	     }


--	Closing a final context. 

closeContext :: Context IF_MVAR(,ps) -> IO ()
closeContext pState
	= let (closed,_) = accPIO ioStClosed pState
	  in  if   closed
	      then storeWorld 42
	      else schedulerFatalError "closeContext" "not a final Context"


--	Handling events while condition holds.

chandleEvents :: St IF_MVAR(Context,(Context ps)) Bool -> Context IF_MVAR(,ps) -> IO IF_MVAR(Context,(Context ps))
chandleEvents cond context
	= osHandleEvents (terminate cond)
	                 (accPIO ioStGetEvents)
	                 (\(es,cs)->appPIO (ioStSetEvents es) cs)
	                 {-contextGetSleepTime-}
	                 handleContextOSEvent
	                 context
	where
	--	terminate :: Context IF_MVAR(,ps) -> (Bool,Context IF_MVAR(,ps))
		terminate :: St IF_MVAR(Context,(Context ps)) Bool -> St IF_MVAR(Context,(Context ps)) Bool
		terminate cond context
			= let (continue,context1) = cond context
			  in  (not continue,context1)

handleContextOSEvent :: OSEvent -> Context IF_MVAR(,ps) -> IO ([Int],Context IF_MVAR(,ps))
handleContextOSEvent osEvent context
	= do {
		trace "handleContextOSEvent: > handleEventForLocalIO";
		(_,schedulerEvent1,context1) <- handleEventForLocalIO False (ScheduleOSEvent osEvent []) context;
		trace "handleContextOSEvent: handleEventForLocalIO >";
		let replyToOS = case schedulerEvent1 of
					(ScheduleOSEvent _ reply) -> reply
					_                         -> []
		in  return (replyToOS,context1)
	  }

handleEventForLocalIO :: Bool -> SchedulerEvent -> Context IF_MVAR(,ps) -> IO (Bool,SchedulerEvent,Context IF_MVAR(,ps))
#if MVAR
handleEventForLocalIO eventDone schedulerEvent ioState
#else
handleEventForLocalIO eventDone schedulerEvent (PSt {ls=ps,io=ioState})
#endif
	= let (initIO,ioState1)      = ioStGetInitIO ioState
	  in  do {
	              trace "handleEventForLocalIO: > initIO";
#if MVAR
	              (_,ioState2)   <- fromGUI initIO ioState1;
#else
	              (ps1,ioState2) <- fromGUI (initIO ps) ioState1;
#endif
	              trace "handleEventForLocalIO: initIO >";
	              let (closed,ioState3) = ioStClosed ioState2
#if MVAR
	                  context1          = ioState3
#else
	                  context1          = PSt {ls=ps1,io=ioState3}
#endif
	              in  if   closed
	                  then trace "handleEventForLocalIO: closed==True" >> return (eventDone,schedulerEvent,context1)
	                  else let (deviceFunctions,context2) = accPIO ioStGetDeviceFunctions context1
--	                           ioFunctions                = [(dEvent df,dDoIO df) | df<-deviceFunctions]
	                           ioFunctions                = [(dDevice df,dEvent df,dDoIO df) | df<-deviceFunctions]
--	                       in  handleEventForDevices ioFunctions eventDone schedulerEvent context2
	                       in  do {
	                       		trace "handleEventForLocalIO: > handleEventForDevices";
	                       		r <- handleEventForDevices ioFunctions eventDone schedulerEvent context2;
	                       		trace "handleEventForLocalIO: handleEventForDevices >";
	                       		return r
	                       	   }
	         }

{-	handleEventForDevices in sequence lets the devices handle the scheduler event until it is handled
	or the process is terminated (ioStClosed returns True).
	Before handing over the event to the device DoIOFunction, the device first maps the event to a
	device event if possible using its EventFunction. 
-}	
#if MVAR
handleEventForDevices :: [(Device,EventFunction,DoIOFunction)] -> Bool -> SchedulerEvent -> PSt -> IO (Bool,SchedulerEvent,PSt)
#else
handleEventForDevices :: [(Device,EventFunction ps,DoIOFunction ps)] -> Bool -> SchedulerEvent -> PSt ps -> IO (Bool,SchedulerEvent,PSt ps)
#endif
handleEventForDevices ((device,mapDeviceEvent,doDeviceIO):doIOs) eventDone schedulerEvent pState
	= if   eventDone
	  then trace ("handleEventForDevices: "++show device++"; done") >> return (eventDone,schedulerEvent,pState)
	  else
	  let (closed,pState1) = accPIO ioStClosed pState
	  in  if   closed
	      then trace ("handleEventForDevices: "++show device++"; closed") >> return (True,schedulerEvent,pState1)
	      else do {
#if MVAR
	                  (forThisDevice,okDeviceEvent,schedulerEvent1) <- mapDeviceEvent pState1 schedulerEvent;
#else
	                  (forThisDevice,okDeviceEvent,schedulerEvent1) <- mapDeviceEvent (io pState1) schedulerEvent;
#endif
	                  if   not forThisDevice
	                  then trace ("handleEventForDevices: "++show device++"; dEvent-->False") >> handleEventForDevices doIOs eventDone schedulerEvent1 pState1
	                  else 
	                  if   isNothing okDeviceEvent
	                  then trace ("handleEventForDevices: "++show device++"; dEvent-->True,Nothing") >> handleEventForDevices doIOs True schedulerEvent1 pState1
	                  else do {
#if MVAR
	                              trace ("handleEventForDevices: "++show device++"; > dEvent-->True,Just DeviceEvent");
	                              (_,ioState1) <- fromGUI (doDeviceIO (fromJust okDeviceEvent)) pState1;
	                              trace ("handleEventForDevices: "++show device++"; dEvent-->True,Just DeviceEvent >");
	                              handleEventForDevices doIOs True schedulerEvent1 ioState1;
#else
	                              trace ("handleEventForDevices: "++show device++"; > dEvent-->True,Just DeviceEvent");
	                              ((_,ps1),ioState1) <- fromGUI (doDeviceIO (fromJust okDeviceEvent) (ls pState1)) (io pState1);
	                              trace ("handleEventForDevices: "++show device++"; dEvent-->True,Just DeviceEvent >");
	                              handleEventForDevices doIOs True schedulerEvent1 (PSt {ls=ps1,io=ioState1});
#endif
	                       }
	              }
handleEventForDevices _ eventDone schedulerEvent pState
--	= return (eventDone,schedulerEvent,pState)
	= do {
		trace ("handleEventForDevices: []");
		return (eventDone,schedulerEvent,pState)
	  }


handleOneEventForDevices :: SchedulerEvent -> PSt IF_MVAR(,ps) -> IO (Bool,SchedulerEvent,PSt IF_MVAR(,ps))
handleOneEventForDevices schedulerEvent pState
	= let (deviceFunctions,pState1) = accPIO ioStGetDeviceFunctions pState
	      ioFunctions               = [(dDevice df,dEvent df,dDoIO df) | df<-deviceFunctions]
	  in  handleEventForDevices ioFunctions False schedulerEvent pState1


{-	Quit this interactive or virtual process.
	Quitting a process involves the following:
	- Set the RuntimeState to Closed (quitProcess is the only function that does this)
	- Close all devices
-}
quitProcess :: IF_MVAR(GUI (),ps -> GUI ps ps)
quitProcess IF_MVAR(,ps)
	= do {
		liftIO (trace "> quitProcess");
		rs <- accIOEnv ioStGetRuntimeState;
		if   rsIsClosed rs
		then liftIO (trace "quitProcess > (ioStGetRuntimeState --> CLOSED)") >> IF_MVAR(return (),return ps)
		else do {
		             deviceFunctions <- accIOEnv ioStGetDeviceFunctions;
#if MVAR
		             sequence [dClose df | df<-deviceFunctions];
#else
		             ps1 <- seqListM [dClose df | df<-deviceFunctions] ps;
#endif
		             liftIO (trace "quitProcess >");
		             appIOEnv (ioStSetRuntimeState Closed);
		             IF_MVAR(return (),return ps1);
		        }
	     }
#if MVAR
#else
	where
		seqListM :: [ps -> GUI ps ps] -> ps -> GUI ps ps
		seqListM (m:ms) ps
			= m ps >>= (\ps -> seqListM ms ps)
		seqListM _ ps
			= return ps
#endif
