module StdProcess (module StdProcess) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdProcess contains the process creation and manipulation functions.
--	********************************************************************************


import CleanStdMisc
import IOstate
import Processdevice
import Scheduler
import StdProcessDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


--	General process topology creation functions:

class Processes pdef where
	startProcesses :: pdef -> IO ()

instance Processes Process where
	startProcesses (Process xDI IF_MVAR(,ps_init) io_init atts)
		= do {
			initialContext  <- initContext atts io_init1 IF_MVAR(,ps_init) xDI;
			finalContext    <- handleEvents initialContext;
			closeContext finalContext;
		  }
		where
#if MVAR
			io_init1    = dOpen processFunctions >> io_init
#else
			io_init1 ps = dOpen processFunctions ps >>= io_init
#endif


--	Specialised process creation functions:

startIO :: DocumentInterface -> IF_MVAR(,ps ->) ProcessInit IF_MVAR(,ps) -> [ProcessAttribute IF_MVAR(,ps)] -> IO ()
startIO xDI IF_MVAR(,ps) io_init atts
	= startProcesses (Process xDI IF_MVAR(,ps) io_init atts)


--	Close this interactive process.

#if MVAR
closeProcess :: GUI ()
closeProcess = quitProcess
#else
closeProcess :: ps -> GUI ps ps
closeProcess ps = quitProcess ps
#endif
