-----------------------------------------------------------------------------
-- $Id: Unique.lhs,v 1.2 2001/05/18 16:54:10 simonmar Exp $
--
-- (c) The GHC Team 2000
--
-- An infinite supply of unique objects, supporting ordering and equality.
--
-----------------------------------------------------------------------------

\begin{code}
module Unique (
   Unique,		-- instance (Eq, Ord)
   newUnique, 		-- :: IO Unique
   hashUnique 		-- :: Unique -> Int
 ) where

import Concurrent
import IOExts (unsafePerformIO)

#ifdef __GLASGOW_HASKELL__
import PrelNum
import PrelBase
#endif

newtype Unique = Unique Integer deriving (Eq,Ord)

uniqSource :: MVar Integer
uniqSource = IOExts.unsafePerformIO (newMVar 0)
{-# NOINLINE uniqSource #-}

newUnique :: IO Unique
newUnique = do
   val <- takeMVar uniqSource
   let next = val+1
   putMVar uniqSource next
   return (Unique next)

hashUnique :: Unique -> Int
#ifdef __GLASGOW_HASKELL__ 
hashUnique (Unique (S# i))   = I# i
hashUnique (Unique (J# s d)) | s ==# 0#  = 0
			     | otherwise = I# (indexIntArray# d 0#)
#else
hashUnique (Unique u) = u `mod` (fromIntegral (maxBound :: Int) + 1)
#endif
\end{code}

