{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32MM_stub_ffi.h" #-}
module Win32MM where

import StdDIS
import Win32Types
import GDITypes


copyMemory :: Addr -> Addr -> DWORD -> IO ()
copyMemory arg1 arg2 arg3 =
  prim_copyMemory arg1 arg2 arg3
foreign import  ccall "prim_copyMemory" unsafe prim_copyMemory :: Addr -> Addr -> Word32 -> IO ()

fillMemory :: Addr -> DWORD -> BYTE -> IO ()
fillMemory arg1 arg2 gc_arg1 =
  case ( word8ToWord32   gc_arg1) of { arg3 ->
  prim_fillMemory arg1 arg2 arg3}
foreign import  ccall "prim_fillMemory" unsafe prim_fillMemory :: Addr -> Word32 -> Word32 -> IO ()

getProcessHeap :: IO HANDLE
getProcessHeap =
  prim_getProcessHeap
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_getProcessHeap" unsafe prim_getProcessHeap :: IO (Addr)

getProcessHeaps :: DWORD -> Addr -> IO DWORD
getProcessHeaps arg1 arg2 =
  prim_getProcessHeaps arg1 arg2
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_getProcessHeaps" unsafe prim_getProcessHeaps :: Word32 -> Addr -> IO (Word32)

type   HGLOBAL   = Addr

type GlobalAllocFlags = UINT


gMEM_FIXED :: GlobalAllocFlags
gMEM_FIXED =
  unsafePerformIO(
    prim_gMEM_FIXED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_FIXED" unsafe prim_gMEM_FIXED :: IO (Word32)
gMEM_MOVEABLE :: GlobalAllocFlags
gMEM_MOVEABLE =
  unsafePerformIO(
    prim_gMEM_MOVEABLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_MOVEABLE" unsafe prim_gMEM_MOVEABLE :: IO (Word32)
gPTR :: GlobalAllocFlags
gPTR =
  unsafePerformIO(
    prim_gPTR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gPTR" unsafe prim_gPTR :: IO (Word32)
gHND :: GlobalAllocFlags
gHND =
  unsafePerformIO(
    prim_gHND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gHND" unsafe prim_gHND :: IO (Word32)
gMEM_DDESHARE :: GlobalAllocFlags
gMEM_DDESHARE =
  unsafePerformIO(
    prim_gMEM_DDESHARE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_DDESHARE" unsafe prim_gMEM_DDESHARE :: IO (Word32)
gMEM_SHARE :: GlobalAllocFlags
gMEM_SHARE =
  unsafePerformIO(
    prim_gMEM_SHARE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_SHARE" unsafe prim_gMEM_SHARE :: IO (Word32)
gMEM_LOWER :: GlobalAllocFlags
gMEM_LOWER =
  unsafePerformIO(
    prim_gMEM_LOWER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_LOWER" unsafe prim_gMEM_LOWER :: IO (Word32)
gMEM_NOCOMPACT :: GlobalAllocFlags
gMEM_NOCOMPACT =
  unsafePerformIO(
    prim_gMEM_NOCOMPACT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_NOCOMPACT" unsafe prim_gMEM_NOCOMPACT :: IO (Word32)
gMEM_NODISCARD :: GlobalAllocFlags
gMEM_NODISCARD =
  unsafePerformIO(
    prim_gMEM_NODISCARD
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_NODISCARD" unsafe prim_gMEM_NODISCARD :: IO (Word32)
gMEM_NOT_BANKED :: GlobalAllocFlags
gMEM_NOT_BANKED =
  unsafePerformIO(
    prim_gMEM_NOT_BANKED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_NOT_BANKED" unsafe prim_gMEM_NOT_BANKED :: IO (Word32)
gMEM_NOTIFY :: GlobalAllocFlags
gMEM_NOTIFY =
  unsafePerformIO(
    prim_gMEM_NOTIFY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_NOTIFY" unsafe prim_gMEM_NOTIFY :: IO (Word32)
gMEM_ZEROINIT :: GlobalAllocFlags
gMEM_ZEROINIT =
  unsafePerformIO(
    prim_gMEM_ZEROINIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMEM_ZEROINIT" unsafe prim_gMEM_ZEROINIT :: IO (Word32)


globalAlloc :: GlobalAllocFlags -> DWORD -> IO HGLOBAL
globalAlloc arg1 arg2 =
  prim_globalAlloc arg1 arg2
  >>= \ gc_result ->
  access_prim_globalAlloc_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalAlloc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalAlloc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalAlloc" unsafe prim_globalAlloc :: Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_globalAlloc_res1" unsafe access_prim_globalAlloc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalAlloc_gc_failed" unsafe access_prim_globalAlloc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalAlloc_gc_failstring" unsafe access_prim_globalAlloc_gc_failstring :: Addr -> IO (Addr)

-- %fun GlobalDiscard :: HGLOBAL -> IO HGLOBAL
-- %fail {res1==NULL}{ErrorWin("GlobalDiscard")}

globalFlags :: HGLOBAL -> IO GlobalAllocFlags
globalFlags arg1 =
  prim_globalFlags arg1
  >>= \ gc_result ->
  access_prim_globalFlags_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalFlags_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalFlags_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalFlags" unsafe prim_globalFlags :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalFlags_res1" unsafe access_prim_globalFlags_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_globalFlags_gc_failed" unsafe access_prim_globalFlags_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalFlags_gc_failstring" unsafe access_prim_globalFlags_gc_failstring :: Addr -> IO (Addr)

globalFree :: HGLOBAL -> IO HGLOBAL
globalFree arg1 =
  prim_globalFree arg1
  >>= \ gc_result ->
  access_prim_globalFree_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalFree_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalFree_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalFree" unsafe prim_globalFree :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalFree_res1" unsafe access_prim_globalFree_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalFree_gc_failed" unsafe access_prim_globalFree_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalFree_gc_failstring" unsafe access_prim_globalFree_gc_failstring :: Addr -> IO (Addr)

globalHandle :: Addr -> IO HGLOBAL
globalHandle arg1 =
  prim_globalHandle arg1
  >>= \ gc_result ->
  access_prim_globalHandle_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalHandle_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalHandle_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalHandle" unsafe prim_globalHandle :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalHandle_res1" unsafe access_prim_globalHandle_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalHandle_gc_failed" unsafe access_prim_globalHandle_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalHandle_gc_failstring" unsafe access_prim_globalHandle_gc_failstring :: Addr -> IO (Addr)

globalLock :: HGLOBAL -> IO Addr
globalLock arg1 =
  prim_globalLock arg1
  >>= \ gc_result ->
  access_prim_globalLock_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalLock_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalLock_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalLock" unsafe prim_globalLock :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalLock_res1" unsafe access_prim_globalLock_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalLock_gc_failed" unsafe access_prim_globalLock_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalLock_gc_failstring" unsafe access_prim_globalLock_gc_failstring :: Addr -> IO (Addr)

-- %fun GlobalMemoryStatus :: IO MEMORYSTATUS

globalReAlloc :: HGLOBAL -> DWORD -> GlobalAllocFlags -> IO HGLOBAL
globalReAlloc arg1 arg2 arg3 =
  prim_globalReAlloc arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_globalReAlloc_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalReAlloc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalReAlloc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalReAlloc" unsafe prim_globalReAlloc :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_globalReAlloc_res1" unsafe access_prim_globalReAlloc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalReAlloc_gc_failed" unsafe access_prim_globalReAlloc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalReAlloc_gc_failstring" unsafe access_prim_globalReAlloc_gc_failstring :: Addr -> IO (Addr)

globalSize :: HGLOBAL -> IO DWORD
globalSize arg1 =
  prim_globalSize arg1
  >>= \ gc_result ->
  access_prim_globalSize_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_globalSize_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalSize_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_globalSize" unsafe prim_globalSize :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalSize_res1" unsafe access_prim_globalSize_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_globalSize_gc_failed" unsafe access_prim_globalSize_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalSize_gc_failstring" unsafe access_prim_globalSize_gc_failstring :: Addr -> IO (Addr)

globalUnlock :: HGLOBAL -> IO ()
globalUnlock arg1 =
  prim_globalUnlock arg1
  >>= \ gc_result ->
  access_prim_globalUnlock_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_globalUnlock_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_globalUnlock" unsafe prim_globalUnlock :: Addr -> IO (Addr)
foreign import ccall "access_prim_globalUnlock_gc_failed" unsafe access_prim_globalUnlock_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_globalUnlock_gc_failstring" unsafe access_prim_globalUnlock_gc_failstring :: Addr -> IO (Addr)

type HeapAllocFlags = DWORD

hEAP_GENERATE_EXCEPTIONS :: HeapAllocFlags
hEAP_GENERATE_EXCEPTIONS =
  unsafePerformIO(
    prim_hEAP_GENERATE_EXCEPTIONS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_hEAP_GENERATE_EXCEPTIONS" unsafe prim_hEAP_GENERATE_EXCEPTIONS :: IO (Word32)
hEAP_NO_SERIALIZE :: HeapAllocFlags
hEAP_NO_SERIALIZE =
  unsafePerformIO(
    prim_hEAP_NO_SERIALIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_hEAP_NO_SERIALIZE" unsafe prim_hEAP_NO_SERIALIZE :: IO (Word32)
hEAP_ZERO_MEMORY :: HeapAllocFlags
hEAP_ZERO_MEMORY =
  unsafePerformIO(
    prim_hEAP_ZERO_MEMORY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_hEAP_ZERO_MEMORY" unsafe prim_hEAP_ZERO_MEMORY :: IO (Word32)

heapAlloc :: HANDLE -> HeapAllocFlags -> DWORD -> IO Addr
heapAlloc arg1 arg2 arg3 =
  prim_heapAlloc arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_heapAlloc_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_heapAlloc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapAlloc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_heapAlloc" unsafe prim_heapAlloc :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_heapAlloc_res1" unsafe access_prim_heapAlloc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_heapAlloc_gc_failed" unsafe access_prim_heapAlloc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapAlloc_gc_failstring" unsafe access_prim_heapAlloc_gc_failstring :: Addr -> IO (Addr)

heapCompact :: HANDLE -> HeapAllocFlags -> IO UINT
heapCompact arg1 arg2 =
  prim_heapCompact arg1 arg2
  >>= \ gc_result ->
  access_prim_heapCompact_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_heapCompact_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapCompact_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_heapCompact" unsafe prim_heapCompact :: Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_heapCompact_res1" unsafe access_prim_heapCompact_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_heapCompact_gc_failed" unsafe access_prim_heapCompact_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapCompact_gc_failstring" unsafe access_prim_heapCompact_gc_failstring :: Addr -> IO (Addr)

heapCreate :: HeapAllocFlags -> DWORD -> DWORD -> IO HANDLE
heapCreate arg1 arg2 arg3 =
  prim_heapCreate arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_heapCreate_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_heapCreate_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapCreate_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_heapCreate" unsafe prim_heapCreate :: Word32 -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_heapCreate_res1" unsafe access_prim_heapCreate_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_heapCreate_gc_failed" unsafe access_prim_heapCreate_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapCreate_gc_failstring" unsafe access_prim_heapCreate_gc_failstring :: Addr -> IO (Addr)

heapDestroy :: HANDLE -> IO ()
heapDestroy arg1 =
  prim_heapDestroy arg1
  >>= \ gc_result ->
  access_prim_heapDestroy_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapDestroy_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_heapDestroy" unsafe prim_heapDestroy :: Addr -> IO (Addr)
foreign import ccall "access_prim_heapDestroy_gc_failed" unsafe access_prim_heapDestroy_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapDestroy_gc_failstring" unsafe access_prim_heapDestroy_gc_failstring :: Addr -> IO (Addr)

heapFree :: HANDLE -> HeapAllocFlags -> Addr -> IO ()
heapFree arg1 arg2 arg3 =
  prim_heapFree arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_heapFree_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapFree_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_heapFree" unsafe prim_heapFree :: Addr -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_heapFree_gc_failed" unsafe access_prim_heapFree_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapFree_gc_failstring" unsafe access_prim_heapFree_gc_failstring :: Addr -> IO (Addr)

heapLock :: HANDLE -> IO ()
heapLock arg1 =
  prim_heapLock arg1
  >>= \ gc_result ->
  access_prim_heapLock_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapLock_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_heapLock" unsafe prim_heapLock :: Addr -> IO (Addr)
foreign import ccall "access_prim_heapLock_gc_failed" unsafe access_prim_heapLock_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapLock_gc_failstring" unsafe access_prim_heapLock_gc_failstring :: Addr -> IO (Addr)

heapReAlloc :: HANDLE -> HeapAllocFlags -> Addr -> DWORD -> IO Addr
heapReAlloc arg1 arg2 arg3 arg4 =
  prim_heapReAlloc arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_heapReAlloc_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_heapReAlloc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapReAlloc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_heapReAlloc" unsafe prim_heapReAlloc :: Addr -> Word32 -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_heapReAlloc_res1" unsafe access_prim_heapReAlloc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_heapReAlloc_gc_failed" unsafe access_prim_heapReAlloc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapReAlloc_gc_failstring" unsafe access_prim_heapReAlloc_gc_failstring :: Addr -> IO (Addr)

heapSize :: HANDLE -> HeapAllocFlags -> Addr -> IO DWORD
heapSize arg1 arg2 arg3 =
  prim_heapSize arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_heapSize_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_heapSize_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapSize_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_heapSize" unsafe prim_heapSize :: Addr -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_heapSize_res1" unsafe access_prim_heapSize_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_heapSize_gc_failed" unsafe access_prim_heapSize_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapSize_gc_failstring" unsafe access_prim_heapSize_gc_failstring :: Addr -> IO (Addr)

heapUnlock :: HANDLE -> IO ()
heapUnlock arg1 =
  prim_heapUnlock arg1
  >>= \ gc_result ->
  access_prim_heapUnlock_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_heapUnlock_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_heapUnlock" unsafe prim_heapUnlock :: Addr -> IO (Addr)
foreign import ccall "access_prim_heapUnlock_gc_failed" unsafe access_prim_heapUnlock_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_heapUnlock_gc_failstring" unsafe access_prim_heapUnlock_gc_failstring :: Addr -> IO (Addr)

heapValidate :: HANDLE -> HeapAllocFlags -> Addr -> IO Bool
heapValidate arg1 arg2 arg3 =
  prim_heapValidate arg1 arg2 arg3
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_heapValidate" unsafe prim_heapValidate :: Addr -> Word32 -> Addr -> IO (Int)

moveMemory :: Addr -> Addr -> DWORD -> IO ()
moveMemory arg1 arg2 arg3 =
  prim_moveMemory arg1 arg2 arg3
foreign import  ccall "prim_moveMemory" unsafe prim_moveMemory :: Addr -> Addr -> Word32 -> IO ()

type VirtualAllocFlags = DWORD

mEM_COMMIT :: VirtualAllocFlags
mEM_COMMIT =
  unsafePerformIO(
    prim_mEM_COMMIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mEM_COMMIT" unsafe prim_mEM_COMMIT :: IO (Word32)
mEM_RESERVE :: VirtualAllocFlags
mEM_RESERVE =
  unsafePerformIO(
    prim_mEM_RESERVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mEM_RESERVE" unsafe prim_mEM_RESERVE :: IO (Word32)

-- % , MEM_TOP_DOWN (not in mingw-20001111 winnt.h)

type ProtectFlags = DWORD

pAGE_READONLY :: ProtectFlags
pAGE_READONLY =
  unsafePerformIO(
    prim_pAGE_READONLY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_READONLY" unsafe prim_pAGE_READONLY :: IO (Word32)
pAGE_READWRITE :: ProtectFlags
pAGE_READWRITE =
  unsafePerformIO(
    prim_pAGE_READWRITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_READWRITE" unsafe prim_pAGE_READWRITE :: IO (Word32)
pAGE_EXECUTE :: ProtectFlags
pAGE_EXECUTE =
  unsafePerformIO(
    prim_pAGE_EXECUTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_EXECUTE" unsafe prim_pAGE_EXECUTE :: IO (Word32)
pAGE_EXECUTE_READ :: ProtectFlags
pAGE_EXECUTE_READ =
  unsafePerformIO(
    prim_pAGE_EXECUTE_READ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_EXECUTE_READ" unsafe prim_pAGE_EXECUTE_READ :: IO (Word32)
pAGE_EXECUTE_READWRITE :: ProtectFlags
pAGE_EXECUTE_READWRITE =
  unsafePerformIO(
    prim_pAGE_EXECUTE_READWRITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_EXECUTE_READWRITE" unsafe prim_pAGE_EXECUTE_READWRITE :: IO (Word32)
pAGE_GUARD :: ProtectFlags
pAGE_GUARD =
  unsafePerformIO(
    prim_pAGE_GUARD
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_GUARD" unsafe prim_pAGE_GUARD :: IO (Word32)
pAGE_NOACCESS :: ProtectFlags
pAGE_NOACCESS =
  unsafePerformIO(
    prim_pAGE_NOACCESS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_NOACCESS" unsafe prim_pAGE_NOACCESS :: IO (Word32)
pAGE_NOCACHE :: ProtectFlags
pAGE_NOCACHE =
  unsafePerformIO(
    prim_pAGE_NOCACHE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pAGE_NOCACHE" unsafe prim_pAGE_NOCACHE :: IO (Word32)

type FreeFlags = DWORD

mEM_DECOMMIT :: FreeFlags
mEM_DECOMMIT =
  unsafePerformIO(
    prim_mEM_DECOMMIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mEM_DECOMMIT" unsafe prim_mEM_DECOMMIT :: IO (Word32)
mEM_RELEASE :: FreeFlags
mEM_RELEASE =
  unsafePerformIO(
    prim_mEM_RELEASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mEM_RELEASE" unsafe prim_mEM_RELEASE :: IO (Word32)

virtualAlloc :: Addr -> DWORD -> VirtualAllocFlags -> ProtectFlags -> IO Addr
virtualAlloc arg1 arg2 arg3 arg4 =
  prim_virtualAlloc arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_virtualAlloc_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_virtualAlloc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_virtualAlloc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_virtualAlloc" unsafe prim_virtualAlloc :: Addr -> Word32 -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_virtualAlloc_res1" unsafe access_prim_virtualAlloc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_virtualAlloc_gc_failed" unsafe access_prim_virtualAlloc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_virtualAlloc_gc_failstring" unsafe access_prim_virtualAlloc_gc_failstring :: Addr -> IO (Addr)


-- %fun VirtualAllocEx :: HANDLE -> Addr -> DWORD -> VirtualAllocFlags -> ProtectFlags ->IO Addr
-- %code extern LPVOID WINAPI VirtualAllocEx(HANDLE,LPVOID,DWORD,DWORD,DWORD);
-- %     LPVOID res1=VirtualAllocEx(arg1,arg2,arg3,arg4,arg5);
-- %fail {res1==NULL}{ErrorWin("VirtualAllocEx")}

virtualFree :: Addr -> DWORD -> FreeFlags -> IO ()
virtualFree arg1 arg2 arg3 =
  prim_virtualFree arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_virtualFree_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_virtualFree_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_virtualFree" unsafe prim_virtualFree :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_virtualFree_gc_failed" unsafe access_prim_virtualFree_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_virtualFree_gc_failstring" unsafe access_prim_virtualFree_gc_failstring :: Addr -> IO (Addr)

-- %fun VirtualFreeEx :: HANDLE -> Addr -> DWORD -> FreeFlags -> IO ()
-- %code extern BOOL WINAPI VirtualFreeEx(HANDLE,LPVOID,DWORD,DWORD);
-- %     BOOL res1=VirtualFreeEx(arg1,arg2,arg3,arg4);
-- %fail {res1=0}{ErrorWin("VirtualFreeEx")}

virtualLock :: Addr -> DWORD -> IO ()
virtualLock arg1 arg2 =
  prim_virtualLock arg1 arg2
  >>= \ gc_result ->
  access_prim_virtualLock_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_virtualLock_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_virtualLock" unsafe prim_virtualLock :: Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_virtualLock_gc_failed" unsafe access_prim_virtualLock_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_virtualLock_gc_failstring" unsafe access_prim_virtualLock_gc_failstring :: Addr -> IO (Addr)

virtualProtect :: Addr -> DWORD -> ProtectFlags -> IO ()
virtualProtect arg1 arg2 arg3 =
  prim_virtualProtect arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_virtualProtect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_virtualProtect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_virtualProtect" unsafe prim_virtualProtect :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_virtualProtect_gc_failed" unsafe access_prim_virtualProtect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_virtualProtect_gc_failstring" unsafe access_prim_virtualProtect_gc_failstring :: Addr -> IO (Addr)

virtualProtectEx :: HANDLE -> Addr -> DWORD -> ProtectFlags -> Addr -> IO ()
virtualProtectEx arg1 arg2 arg3 arg4 arg5 =
  prim_virtualProtectEx arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_virtualProtectEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_virtualProtectEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_virtualProtectEx" unsafe prim_virtualProtectEx :: Addr -> Addr -> Word32 -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_virtualProtectEx_gc_failed" unsafe access_prim_virtualProtectEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_virtualProtectEx_gc_failstring" unsafe access_prim_virtualProtectEx_gc_failstring :: Addr -> IO (Addr)

-- No VirtualQuery..()

virtualUnlock :: Addr -> DWORD -> IO ()
virtualUnlock arg1 arg2 =
  prim_virtualUnlock arg1 arg2
  >>= \ gc_result ->
  access_prim_virtualUnlock_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_virtualUnlock_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_virtualUnlock" unsafe prim_virtualUnlock :: Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_virtualUnlock_gc_failed" unsafe access_prim_virtualUnlock_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_virtualUnlock_gc_failstring" unsafe access_prim_virtualUnlock_gc_failstring :: Addr -> IO (Addr)

zeroMemory :: Addr -> DWORD -> IO ()
zeroMemory arg1 arg2 =
  prim_zeroMemory arg1 arg2
foreign import  ccall "prim_zeroMemory" unsafe prim_zeroMemory :: Addr -> Word32 -> IO ()

